/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.persistence;

import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.vc.Commit;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.Persistent;
import com.urbancode.air.vc.Repository;
import com.urbancode.air.vc.Session;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyFactory<T extends AbstractEntity<UUID>> {
    protected org.hibernate.Session getDBSession() {
        PropertyConfiguration config = PropertyConfiguration.getInstance();
        return config.getSessionLookup().getSession();
    }

    protected T getEntityForId(Class persistentClass, Object id, String typeName) {
        AbstractEntity result = null;
        result = (AbstractEntity)this.getDBSession().get(persistentClass, (Serializable)id);
        if (result == null) {
            throw new IllegalArgumentException("No " + typeName + " exists with ID " + String.valueOf(id) + ".");
        }
        return (T)result;
    }

    protected Session getVCSession() {
        PropertyConfiguration config = PropertyConfiguration.getInstance();
        Repository repository = config.getRepository();
        Session result = repository.getSession();
        return result;
    }

    protected T restore(Handle handle) {
        AbstractEntity result = (AbstractEntity)this.getVCSession().restore(handle);
        result = this.filterForRead(result);
        return (T)result;
    }

    protected List<T> restoreLatestWithPaths(List<String> paths, boolean skipVersionCount) {
        List result = this.getVCSession().restoreLatestWithPaths(paths, skipVersionCount);
        ArrayList<AbstractEntity> finRes = new ArrayList<AbstractEntity>(result.size());
        for (int i = 0; i < result.size(); ++i) {
            finRes.add(this.filterForRead((AbstractEntity)result.get(i)));
        }
        return finRes;
    }

    protected List<T> restoreAllInPath(Class<T> clazz, String path) {
        List<T> result = this.getVCSession().restoreAllInPath(clazz, path);
        result = this.filterListForRead(result);
        return result;
    }

    protected List<T> restoreAllInPathForCommit(Class<T> clazz, String path, Long commit) {
        List<T> result = this.getVCSession().restoreAllInPathForCommit(clazz, path, commit);
        result = this.filterListForRead(result);
        return result;
    }

    public Commit getCommit(Long commit) {
        return this.getVCSession().getCommit(commit.longValue());
    }

    protected int getVersionCount(Persistent p) {
        return this.getVCSession().getVersionCountForPersistent(p);
    }

    protected List<Commit> getCommits(Persistent p) {
        return this.getVCSession().getCommitsForPersistent(p);
    }

    protected T filterForRead(T result) {
        return result;
    }

    protected List<T> filterListForRead(List<T> result) {
        ArrayList<T> filteredResult = new ArrayList<T>();
        for (AbstractEntity singleResult : result) {
            if (this.filterForRead(singleResult) == null) continue;
            filteredResult.add(singleResult);
        }
        result = filteredResult;
        return result;
    }
}

