/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.property.prop_sheet;

import com.urbancode.air.i18n.TranslatableException;
import com.urbancode.air.property.PropertyConfiguration;
import com.urbancode.air.property.prop_def.PropDef;
import com.urbancode.air.property.prop_sheet.DefaultPropSheetResolver;
import com.urbancode.air.property.prop_sheet.PropSheetFactoryRegistry;
import com.urbancode.air.property.prop_sheet.PropSheetResolver;
import com.urbancode.air.property.prop_sheet_def.PropSheetDef;
import com.urbancode.air.property.prop_sheet_def.PropSheetDefFactoryRegistry;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroup;
import com.urbancode.air.property.prop_sheet_group.PropSheetGroupFactoryRegistry;
import com.urbancode.air.property.prop_value.PropValue;
import com.urbancode.air.vc.Handle;
import com.urbancode.air.vc.PersistenceData;
import com.urbancode.air.vc.Persistent;
import com.urbancode.persistence.IDGenerator;
import com.urbancode.persistence.hibernate.AbstractEntity;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="propSheetsCache")
@Entity
@Table(name="ps_prop_sheet")
public class PropSheet
extends AbstractEntity<UUID>
implements Persistent {
    private static final long serialVersionUID = -6676786342302221908L;
    public static final String PROP_SHEET_SEPARATOR = "/";
    @Transient
    private PersistenceData persistenceData = new PersistenceData((Persistent)this, true);
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    UUID id = IDGenerator.createID();
    @Column(name="name")
    @Length(max=256)
    String name;
    @OneToMany(mappedBy="propSheet", orphanRemoval=true)
    @Cascade(value={CascadeType.ALL})
    List<PropValue> propValues = new ArrayList<PropValue>();
    @Transient
    Handle propSheetGroupHandle;
    @ManyToOne
    @JoinColumn(name="prop_sheet_group_id")
    private PropSheetGroup propSheetGroup;
    @Column(name="prop_sheet_def_handle")
    String propSheetDefHandleString;
    @ManyToOne
    @JoinColumn(name="prop_sheet_def_id")
    private PropSheetDef propSheetDef;
    @Transient
    UUID propSheetDefId;
    @Column(name="template_handle")
    String templateHandleString;
    @ManyToOne
    @JoinColumn(name="template_prop_sheet_id")
    private PropSheet templatePropSheet;
    @Transient
    UUID templatePropSheetId;

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        PropSheet template;
        PropSheetDef propSheetDef;
        String result = this.name;
        if (result == null && (propSheetDef = this.getPropSheetDef()) != null) {
            result = propSheetDef.getName();
        }
        if (result == null && (template = this.getTemplate()) != null) {
            result = template.getName();
        }
        return result;
    }

    public void setName(String name) {
        this.name = name;
        this.persistenceData.setDirty(true);
    }

    public List<PropValue> getPropValueList() {
        ArrayList<PropValue> result = new ArrayList<PropValue>();
        HashSet<String> propValueNames = new HashSet<String>();
        for (PropValue propVal : this.propValues) {
            result.add(propVal);
            propValueNames.add(propVal.getName());
        }
        PropSheet template = this.getTemplate();
        if (template != null) {
            for (PropValue propVal : template.getPropValueList()) {
                if (propValueNames.contains(propVal.getName())) continue;
                result.add(propVal);
            }
        }
        Collections.sort(result);
        return result;
    }

    public List<PropValue> getDirectPropValueList() {
        ArrayList<PropValue> result = new ArrayList<PropValue>(this.propValues);
        Collections.sort(result);
        return result;
    }

    public List<String> getPropValueNames() {
        ArrayList<String> result = new ArrayList<String>();
        PropSheet template = this.getTemplate();
        if (template != null) {
            result.addAll(template.getPropValueNames());
        }
        for (PropValue propVal : this.propValues) {
            result.add(propVal.getName());
        }
        Collections.sort(result);
        return result;
    }

    public void clear() {
        for (PropValue value : this.getPropValueList()) {
            this.propValues.remove(value);
        }
        this.persistenceData.setDirty(true);
    }

    public Map<String, String> getPropMap() {
        HashMap<String, String> properties = new HashMap<String, String>();
        PropSheet template = this.getTemplate();
        if (template != null) {
            properties.putAll(template.getPropMap());
        }
        this.collectLocalProperties(properties);
        return properties;
    }

    public Map<String, String> getFlatDereferencedPropMap() {
        return this.getFlatDereferencedPropMap(new DefaultPropSheetResolver());
    }

    public Map<String, String> getFlatDereferencedPropMap(PropSheetResolver resolver) {
        PropSheetDef propSheetDef;
        HashMap<String, String> properties = new HashMap<String, String>();
        PropSheet template = this.getTemplate();
        if (template != null) {
            properties.putAll(template.getFlatDereferencedPropMap());
        }
        if ((propSheetDef = this.getPropSheetDef()) != null) {
            this.getFlatDerefencedPropMapByPropSheetDef(propSheetDef, properties, resolver);
        } else {
            this.collectLocalProperties(properties);
        }
        return properties;
    }

    public PropSheet getFlatDereferencedPropSheet() {
        return this.getFlatDereferencedPropSheet(new DefaultPropSheetResolver());
    }

    public PropSheet getFlatDereferencedPropSheet(PropSheetResolver resolver) {
        PropSheet template = this.getTemplate();
        PropSheet propSheet = template != null ? template.getFlatDereferencedPropSheet() : new PropSheet();
        this.collectLocalProperties(propSheet);
        PropSheetDef propSheetDef = this.getPropSheetDef();
        if (propSheetDef != null) {
            this.getFlatDerefencedPropSheetByPropSheetDef(propSheetDef, propSheet, resolver);
        }
        return propSheet;
    }

    private void collectLocalProperties(Map<String, String> properties) {
        for (PropValue property : this.propValues) {
            properties.put(property.getName(), property.getValue());
        }
    }

    private void collectLocalProperties(PropSheet properties) {
        for (PropValue property : this.propValues) {
            properties.setPropValue(property.getName(), property.getValue());
            if (!property.isSecure().booleanValue()) continue;
            properties.getPropValueObject(property.getName()).setSecure(true);
        }
    }

    private void getFlatDerefencedPropMapByPropSheetDef(PropSheetDef propSheetDef, Map<String, String> properties, PropSheetResolver resolver) {
        for (PropDef propDef : propSheetDef.getPropDefList()) {
            String propName = propDef.getName();
            String propValue = this.getPropValue(propName);
            if (PropDef.PropDefType.PROP_SHEET_REF.equals((Object)propDef.getType())) {
                if (StringUtils.isEmpty((String)propValue)) continue;
                PropSheet referencedPropSheet = resolver.resolveReference(propValue);
                Map<String, String> refPropMap = referencedPropSheet.getFlatDereferencedPropMap();
                for (Map.Entry<String, String> refPropEntry : refPropMap.entrySet()) {
                    String refPropName = propName + PROP_SHEET_SEPARATOR + refPropEntry.getKey();
                    properties.put(refPropName, refPropEntry.getValue());
                }
                continue;
            }
            if (propDef.isHidden()) {
                properties.put(propName, propDef.getDefaultValue());
                continue;
            }
            if (properties.containsKey(propName) && StringUtils.isEmpty((String)propValue)) continue;
            properties.put(propName, propValue);
        }
    }

    private void getFlatDerefencedPropSheetByPropSheetDef(PropSheetDef propSheetDef, PropSheet propSheet, PropSheetResolver resolver) {
        for (PropDef propDef : propSheetDef.getPropDefList()) {
            PropValue propValueObject;
            String propName = propDef.getName();
            String propValue = this.getPropValue(propName);
            if (PropDef.PropDefType.PROP_SHEET_REF.equals((Object)propDef.getType())) {
                if (!StringUtils.isEmpty((String)propValue)) {
                    PropSheet referencedPropSheet = resolver.resolveReference(propValue);
                    PropSheet flatRefPropSheet = referencedPropSheet.getFlatDereferencedPropSheet();
                    for (PropValue refPropValue : flatRefPropSheet.getPropValueList()) {
                        String refPropName = propName + PROP_SHEET_SEPARATOR + refPropValue.getName();
                        propSheet.setPropValue(refPropName, refPropValue.getValue());
                        if (!refPropValue.isSecure().booleanValue()) continue;
                        propSheet.getPropValueObject(refPropName).setSecure(true);
                    }
                }
                propSheet.setPropValue(propName, propValue);
            } else if (propDef.isHidden()) {
                if (StringUtils.isNotBlank((String)propValue)) {
                    propSheet.setPropValue(propName, propValue);
                } else {
                    propSheet.setPropValue(propName, propDef.getDefaultValue());
                }
            } else if (!StringUtils.isNotEmpty((String)propSheet.getPropValue(propName)) || !StringUtils.isEmpty((String)propValue)) {
                propSheet.setPropValue(propName, propValue);
            }
            if (!propDef.isSecure() || (propValueObject = propSheet.getPropValueObject(propName)) == null) continue;
            propValueObject.setSecure(true);
        }
    }

    public PropValue getPropValueObject(String name) {
        PropValue result = null;
        for (PropValue prop : this.propValues) {
            if (!prop.getName().equals(name)) continue;
            result = prop;
            break;
        }
        return result;
    }

    public String getPropValue(String name) {
        PropSheet template;
        String result = null;
        PropValue propValueObject = this.getPropValueObject(name);
        if (propValueObject != null) {
            result = propValueObject.getValue();
        }
        if ((template = this.getTemplate()) != null && result == null) {
            result = template.getPropValue(name);
        }
        return result;
    }

    public String getSafePropValue(String name) {
        PropSheet template;
        String result = null;
        PropValue propValueObject = this.getPropValueObject(name);
        if (propValueObject != null) {
            result = propValueObject.getSafeValue();
        }
        if ((template = this.getTemplate()) != null && result == null) {
            result = template.getSafePropValue(name);
        }
        return result;
    }

    public void addPropValue(PropValue propValue) {
        PropSheet propValuePropSheet = propValue.getPropSheet();
        if (propValuePropSheet != null && !propValuePropSheet.equals((Object)this)) {
            throw new TranslatableException("PropValue %s belongs to a different PropSheet already.", new Object[]{propValue});
        }
        String name = propValue.getName();
        if (this.getPropValueObject(name) != null) {
            throw new TranslatableException("A PropValue named %s already exists in this PropSheet.", new Object[]{name});
        }
        if (propValuePropSheet == null) {
            propValue.setPropSheet(this);
        }
        this.propValues.add(propValue);
        this.persistenceData.setDirty(true);
    }

    public PropValue setPropValue(String name, String value) {
        PropValue property = this.getPropValueObject(name);
        if (value == null && property != null) {
            this.propValues.remove(property);
        } else if (value != null) {
            boolean secure = false;
            PropDef propDef = this.getPropDef(name);
            if (propDef != null) {
                secure = propDef.isSecure();
            } else if (property != null) {
                secure = property.isSecure();
            }
            if (!secure || !"****".equals(value)) {
                if (property != null) {
                    property.setValue(value);
                } else {
                    property = new PropValue(name, "");
                    this.addPropValue(property);
                    property.setValue(value);
                }
                property.setSecure(secure);
            } else if (property == null && propDef != null && propDef.isSecure() && "****".equals(value)) {
                property = new PropValue(name, propDef.getDefaultValue(), true);
                this.addPropValue(property);
            }
        }
        this.persistenceData.setDirty(true);
        return property;
    }

    private PropDef getPropDef(String name) {
        PropDef result = null;
        PropSheetDef propSheetDef = this.getPropSheetDef();
        if (propSheetDef != null) {
            result = propSheetDef.getPropDef(name);
        }
        return result;
    }

    public void setPropValues(Map<String, String> propValues) {
        if (propValues == null || propValues.isEmpty()) {
            this.clear();
        } else {
            ArrayList<String> missedPropValNames = new ArrayList<String>();
            missedPropValNames.addAll(this.getPropValueNames());
            for (Map.Entry<String, String> propValue : propValues.entrySet()) {
                this.setPropValue(propValue.getKey(), propValue.getValue());
                missedPropValNames.remove(propValue.getKey());
            }
            for (String name : missedPropValNames) {
                this.setPropValue(name, null);
            }
        }
    }

    public void removePropValue(PropValue propValue) {
        this.propValues.remove(propValue);
        this.persistenceData.setDirty(true);
    }

    public PropValue setSecurePropValue(String name, String value) {
        PropValue property = this.getPropValueObject(name);
        if (property != null) {
            if (value == null) {
                this.propValues.remove(property);
                if (!this.isVersioned()) {
                    PropertyConfiguration config = PropertyConfiguration.getInstance();
                    Session session = config.getSessionLookup().getSession();
                    session.delete((Object)property);
                }
            } else {
                property.setSecure(true);
                property.setValue(value);
            }
        } else if (value != null) {
            property = new PropValue(name, value);
            property.setSecure(true);
            this.addPropValue(property);
        }
        this.persistenceData.setDirty(true);
        return property;
    }

    public PropSheetDef getPropSheetDef() {
        PropSheet template;
        PropSheetDef result = null;
        if (this.propSheetDef != null) {
            result = this.propSheetDef;
        } else if (this.propSheetDefId != null) {
            result = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefForId(this.propSheetDefId);
        }
        if (result == null && this.propSheetDefHandleString != null) {
            Handle handle = new Handle(this.propSheetDefHandleString);
            result = PropSheetDefFactoryRegistry.getFactory().getPropSheetDefForHandle(handle);
            if (result != null) {
                this.propSheetDefId = result.getId();
            }
        }
        if (result == null && (template = this.getTemplate()) != null) {
            result = template.getPropSheetDef();
        }
        return result;
    }

    public void setPropSheetDef(PropSheetDef propSheetDef) {
        this.setPropSheetDef(propSheetDef, false);
    }

    public void setPropSheetDef(PropSheetDef propSheetDef, boolean useSpecificVersion) {
        this.propSheetDefHandleString = null;
        this.propSheetDefId = null;
        this.propSheetDef = null;
        if (propSheetDef != null) {
            if (propSheetDef.isVersioned()) {
                int version = -1;
                if (useSpecificVersion) {
                    version = propSheetDef.getPersistenceData().getRelativeVersion();
                }
                Handle propSheetDefHandle = new Handle(propSheetDef.getPersistenceData().getPath(), Integer.valueOf(version));
                this.propSheetDefHandleString = propSheetDefHandle.toString();
            } else if (this.isVersioned()) {
                this.propSheetDefId = propSheetDef.getId();
            } else {
                this.propSheetDef = propSheetDef;
            }
        }
        this.persistenceData.setDirty(true);
    }

    public PropSheetGroup getPropSheetGroup() {
        PropSheetGroup result = null;
        if (this.propSheetGroup != null) {
            result = this.propSheetGroup;
        } else if (this.propSheetGroupHandle != null) {
            result = PropSheetGroupFactoryRegistry.getFactory().getPropSheetGroupForHandle(this.propSheetGroupHandle);
        }
        return result;
    }

    public void setPropSheetGroup(PropSheetGroup propSheetGroup) {
        this.propSheetGroupHandle = null;
        this.propSheetGroup = null;
        if (propSheetGroup != null) {
            if (propSheetGroup.isVersioned()) {
                Handle propSheetGroupHandle;
                this.propSheetGroupHandle = propSheetGroupHandle = new Handle(propSheetGroup.getPersistenceData().getPath(), Integer.valueOf(-1));
            } else {
                this.propSheetGroup = propSheetGroup;
            }
        }
        this.persistenceData.setDirty(true);
    }

    public PropSheet getTemplate() {
        PropSheet result = null;
        if (this.templatePropSheet != null) {
            result = this.templatePropSheet;
        } else if (this.templatePropSheetId != null) {
            result = PropSheetFactoryRegistry.getFactory().getPropSheetForId(this.templatePropSheetId);
        } else if (this.templateHandleString != null) {
            Handle handle = new Handle(this.templateHandleString);
            result = PropSheetFactoryRegistry.getFactory().getPropSheetForHandle(handle);
        }
        return result;
    }

    public void setTemplate(PropSheet templatePropSheet) {
        this.setTemplate(templatePropSheet, false);
    }

    public void setTemplate(PropSheet templatePropSheet, boolean useSpecificVersion) {
        this.templateHandleString = null;
        this.templatePropSheetId = null;
        this.templatePropSheet = null;
        if (templatePropSheet != null) {
            if (templatePropSheet.isVersioned()) {
                int version = -1;
                if (useSpecificVersion) {
                    version = templatePropSheet.getPersistenceData().getRelativeVersion();
                }
                Handle templatePropSheetHandle = new Handle(templatePropSheet.getPersistenceData().getPath(), Integer.valueOf(version));
                this.templateHandleString = templatePropSheetHandle.toString();
            } else if (this.isVersioned()) {
                this.templatePropSheetId = templatePropSheet.getId();
            } else {
                this.templatePropSheet = templatePropSheet;
            }
        }
        this.persistenceData.setDirty(true);
    }

    public boolean isVersioned() {
        return this.persistenceData.getPath() != null;
    }

    public PersistenceData getPersistenceData() {
        return this.persistenceData;
    }

    public void setDefaultPropertiesFromPropSheetDef() {
        PropSheetDef psDef = this.getPropSheetDef();
        for (PropDef propDef : psDef.getPropDefList()) {
            String value = propDef.getDefaultValue();
            if (value == null || value.equals("") && propDef.isRequired()) continue;
            if (propDef.isSecure()) {
                this.setSecurePropValue(propDef.getName(), value);
                continue;
            }
            this.setPropValue(propDef.getName(), value);
        }
    }

    public void updateFromPropSheetDef(PropSheetDef psd) {
        PropSheet ps = this;
        for (PropDef pd : psd.getPropDefList()) {
            String propName = pd.getName();
            String value = pd.getDefaultValue();
            boolean secure = pd.isSecure();
            PropValue pv = ps.getPropValueObject(propName);
            if (pv != null) {
                if (!pv.isUsingDefault()) continue;
                if (secure) {
                    ps.setSecurePropValue(propName, value);
                    continue;
                }
                ps.setPropValue(propName, value);
                continue;
            }
            if (secure) {
                ps.setSecurePropValue(propName, value);
                continue;
            }
            ps.setPropValue(propName, value);
        }
    }
}

