/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence;

import com.urbancode.persistence.IDGeneratorSimpleRandom;
import java.util.UUID;

public abstract class IDGenerator {
    private static IDGenerator instance;

    public static synchronized IDGenerator getInstance() {
        return instance;
    }

    public static synchronized void setInstance(IDGenerator generator) {
        instance = generator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UUID createID() {
        Class<IDGenerator> clazz = IDGenerator.class;
        synchronized (IDGenerator.class) {
            IDGenerator g = IDGenerator.getInstance();
            if (g == null) {
                g = new IDGeneratorSimpleRandom();
                IDGenerator.setInstance(g);
            }
            // ** MonitorExit[var1] (shouldn't be in output)
            return g.newID();
        }
    }

    static byte[] toBytes(long hi, long lo) {
        int i;
        byte[] a = new byte[16];
        for (i = 7; i >= 0; --i) {
            a[i] = (byte)hi;
            hi >>>= 8;
        }
        for (i = 15; i >= 8; --i) {
            a[i] = (byte)lo;
            lo >>>= 8;
        }
        return a;
    }

    static UUID randomUUID(byte[] data) {
        int i;
        data[6] = (byte)(data[6] & 0xF);
        data[6] = (byte)(data[6] | 0x40);
        data[8] = (byte)(data[8] & 0x3F);
        data[8] = (byte)(data[8] | 0x80);
        long hi = 0L;
        long lo = 0L;
        for (i = 0; i < 8; ++i) {
            hi <<= 8;
            hi |= (long)data[i] & 0xFFL;
        }
        for (i = 8; i < 16; ++i) {
            lo <<= 8;
            lo |= (long)data[i] & 0xFFL;
        }
        return new UUID(hi, lo);
    }

    public abstract UUID newID();
}

