/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.persistence.hibernate;

import com.urbancode.persistence.hibernate.HibernateFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateFilterConfig
implements Iterable<HibernateFilter> {
    private static final Logger log = LoggerFactory.getLogger(HibernateFilterConfig.class);
    Set<HibernateFilter> hibernateFilters = new HashSet<HibernateFilter>();

    public void reset() {
        this.hibernateFilters.clear();
    }

    public List<String> getEnabledFilters() {
        ArrayList<String> filterNames = new ArrayList<String>(this.hibernateFilters.size());
        for (HibernateFilter filter : this.hibernateFilters) {
            filterNames.add(filter.getName());
        }
        return filterNames;
    }

    public boolean disableFilter(String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException("The parameter filterName must be non-null.");
        }
        if (log.isTraceEnabled()) {
            Thread currentThread = Thread.currentThread();
            StringBuilder msg = new StringBuilder("Disabling hibernate filter '");
            msg.append(filterName);
            msg.append("' for Thread-");
            msg.append(currentThread.getId());
            msg.append(":");
            msg.append(currentThread.getName());
            msg.append(".");
            log.trace(msg.toString());
        }
        return this.hibernateFilters.remove(new HibernateFilter(filterName));
    }

    public void disableAllFilters() {
        if (log.isTraceEnabled()) {
            Thread currentThread = Thread.currentThread();
            StringBuilder msg = new StringBuilder("Disabling all hibernate filters for Thread-");
            msg.append(currentThread.getId());
            msg.append(":");
            msg.append(currentThread.getName());
            msg.append(".");
            log.trace(msg.toString());
        }
        this.hibernateFilters.clear();
    }

    public HibernateFilter enableFilter(String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException("The parameter filterName must be non-null.");
        }
        if (log.isTraceEnabled()) {
            Thread currentThread = Thread.currentThread();
            StringBuilder msg = new StringBuilder("Enabling filter '");
            msg.append(filterName);
            msg.append("' for Thread-");
            msg.append(currentThread.getId());
            msg.append(":");
            msg.append(currentThread.getName());
            msg.append(".");
            log.trace(msg.toString());
        }
        HibernateFilter filter = new HibernateFilter(filterName);
        this.hibernateFilters.add(filter);
        return filter;
    }

    public HibernateFilter enableFilter(String filterName, Map<String, Object> parameters) {
        if (filterName == null) {
            throw new IllegalArgumentException("The parameter filterName must be non-null.");
        }
        HibernateFilter filter = this.enableFilter(filterName);
        if (parameters != null) {
            Set<Map.Entry<String, Object>> entrySet = parameters.entrySet();
            for (Map.Entry<String, Object> entry : entrySet) {
                filter.pushParameter(entry.getKey(), entry.getValue());
            }
        }
        return filter;
    }

    public HibernateFilter getFilter(String filterName) {
        if (filterName == null) {
            throw new IllegalArgumentException("The parameter filterName must be non-null.");
        }
        for (HibernateFilter filter : this.hibernateFilters) {
            if (!filterName.equals(filter.getName())) continue;
            return filter;
        }
        return null;
    }

    @Override
    public Iterator<HibernateFilter> iterator() {
        return this.hibernateFilters.iterator();
    }
}

