/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal;

import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.QueryIterator;
import com.ibm.team.workitem.common.internal.AuditableCache;
import com.ibm.team.workitem.common.internal.util.CacheHelper;
import com.ibm.team.workitem.common.internal.util.CacheState;
import com.ibm.team.workitem.common.internal.util.WorkItemQueries;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class AttributeCache
extends CacheHelper {
    private AuditableCache.ScopedItemTypeCache<IAttribute> fAttributeCache = new AuditableCache.ScopedItemTypeCache(IAttribute.ITEM_TYPE, IAttribute.PROJECT_AREA_PROPERTY, Integer.MAX_VALUE);

    public AttributeCache(IAuditableCommon auditableCommon) {
        super(auditableCommon);
    }

    public IAttribute findAttribute(IProjectAreaHandle projectArea, String identifier, IProgressMonitor monitor) throws TeamRepositoryException {
        List<IAttribute> attributes = this.findAttributes(projectArea, monitor);
        for (IAttribute attribute : attributes) {
            if (!identifier.equals(attribute.getIdentifier())) continue;
            return attribute;
        }
        return null;
    }

    public List<IAttribute> findAttributes(IProjectAreaHandle projectArea, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkCache(projectArea, monitor);
        List<IAttribute> attributes = this.fAttributeCache.getAll((IAuditableHandle)projectArea, IAttribute.FULL_PROFILE);
        return attributes != null ? attributes : Collections.emptyList();
    }

    public IAttribute findCachedAttribute(IProjectAreaHandle projectArea, String identifier) throws TeamRepositoryException {
        List<IAttribute> attributes = this.fAttributeCache.getAll((IAuditableHandle)projectArea, IAttribute.FULL_PROFILE);
        if (attributes != null) {
            for (IAttribute attribute : attributes) {
                if (!identifier.equals(attribute.getIdentifier())) continue;
                return attribute;
            }
        }
        return null;
    }

    public List<IAttribute> findCachedAttributes(IProjectAreaHandle projectArea) throws TeamRepositoryException {
        return this.fAttributeCache.getAll((IAuditableHandle)projectArea, IAttribute.FULL_PROFILE);
    }

    @Override
    protected void updateCache(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryIterator<IAttributeHandle> iter = WorkItemQueries.attributesByProjectArea(auditableCommon, projectAreaHandle);
        List<IAttribute> attributes = auditableCommon.resolveAuditables2(iter.toList(monitor), IAttribute.FULL_PROFILE, 3, monitor);
        this.fAttributeCache.cacheAll(attributes, IAttribute.FULL_PROFILE);
    }

    AuditableCache.IItemTypeCache<IAttribute> getCache() {
        return this.fAttributeCache;
    }

    public void clearAttributeCache(IProjectAreaHandle projectAreaHandle) {
        this.flushCache(projectAreaHandle);
        this.fAttributeCache.invalidate((IAuditableHandle)projectAreaHandle);
    }

    @Override
    protected CacheState getCacheState(IProjectAreaHandle projectAreaHandle, IAuditableCommon auditableCommon, IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getCacheStateForItemType(IAttribute.ITEM_TYPE, projectAreaHandle, auditableCommon, monitor);
    }
}

