/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.attributeValueProviders;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.attributeValueProviders.AttributeValueProviderDescriptor;
import com.ibm.team.workitem.common.internal.attributeValueProviders.FallbackProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ICondition;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IConfiguration;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IDefaultValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IFilteredValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValidator;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.IValueSetProvider;
import com.ibm.team.workitem.common.internal.attributeValueProviders.Messages;
import com.ibm.team.workitem.common.internal.attributeValueProviders.ProviderType;
import com.ibm.team.workitem.common.internal.model.WorkItemCommonPlugin;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class AttributeValueProviderRegistry
extends ExtensionRegistryReader<AttributeValueProviderDescriptor> {
    private static AttributeValueProviderRegistry fgRegistry;
    private static final String EXTENSION_POINT_ID = "attributeValueProviders";
    private Map<ProviderType, Map<String, AttributeValueProviderDescriptor>> fDescriptorMaps;
    private final FallbackProvider fDefaultValueProvider = new FallbackProvider();

    private static String getProviderConfigurationLabel(IConfiguration configuration) {
        if (configuration != null) {
            return configuration.getIdentifier();
        }
        return "default";
    }

    public static synchronized AttributeValueProviderRegistry getInstance() {
        if (fgRegistry == null) {
            fgRegistry = new AttributeValueProviderRegistry();
            fgRegistry.start();
        }
        return fgRegistry;
    }

    protected AttributeValueProviderRegistry() {
        super("com.ibm.team.workitem.common", EXTENSION_POINT_ID);
    }

    public IValueProvider<?> getValueProvider(IConfiguration cfg, IAttribute attribute) {
        return this.getValueProvider(cfg, attribute, true);
    }

    public IValueProvider<?> getValueProvider(IConfiguration cfg, IAttribute attribute, boolean safe) {
        AttributeValueProviderDescriptor descriptor = this.getDescriptor(ProviderType.VALUE_PROVIDER, cfg, attribute);
        if (descriptor != null) {
            return safe ? new SafeValueProvider((IValueProvider)descriptor.getProvider()) : (IValueProvider)descriptor.getProvider();
        }
        return this.fDefaultValueProvider;
    }

    public IValueSetProvider<?> getValueSetProvider(IConfiguration cfg, IAttribute attribute) {
        return this.getValueSetProvider(cfg, attribute, true);
    }

    public IValueSetProvider<?> getValueSetProvider(IConfiguration cfg, IAttribute attribute, boolean safe) {
        AttributeValueProviderDescriptor descriptor = this.getDescriptor(ProviderType.VALUE_SET_PROVIDER, cfg, attribute);
        IValueSetProvider<Object> provider = this.fDefaultValueProvider;
        if (descriptor != null) {
            provider = (IValueSetProvider)descriptor.getProvider();
            if (safe) {
                provider = provider instanceof IFilteredValueSetProvider ? new SafeFilteredValueSetProvider((IFilteredValueSetProvider)provider) : new SafeValueSetProvider(provider);
            }
        }
        return provider;
    }

    public IDefaultValueProvider<?> getDefaultValueProvider(IConfiguration cfg, IAttribute attribute) {
        return this.getDefaultValueProvider(cfg, attribute, true);
    }

    public IDefaultValueProvider<?> getDefaultValueProvider(IConfiguration cfg, IAttribute attribute, boolean safe) {
        AttributeValueProviderDescriptor descriptor = this.getDescriptor(ProviderType.DEFAULT_VALUE_PROVIDER, cfg, attribute);
        if (descriptor != null) {
            return safe ? new SafeDefaultValueProvider((IDefaultValueProvider)descriptor.getProvider()) : (IDefaultValueProvider)descriptor.getProvider();
        }
        return this.fDefaultValueProvider;
    }

    public ICondition getCondition(IConfiguration cfg) {
        return this.getCondition(cfg, true);
    }

    public ICondition getCondition(IConfiguration cfg, boolean safe) {
        AttributeValueProviderDescriptor descriptor = this.getDescriptor(ProviderType.CONDITION, cfg, null);
        if (descriptor != null) {
            return safe ? new SafeWorkItemFilter((ICondition)descriptor.getProvider()) : (ICondition)descriptor.getProvider();
        }
        return this.fDefaultValueProvider;
    }

    public IValidator getValidator(IConfiguration cfg, IAttribute attribute) {
        return this.getValidator(cfg, attribute, true);
    }

    public IValidator getValidator(IConfiguration cfg, IAttribute attribute, boolean safe) {
        AttributeValueProviderDescriptor descriptor = this.getDescriptor(ProviderType.VALIDATOR, cfg, attribute);
        if (descriptor != null) {
            return safe ? new SafeValidator((IValidator)descriptor.getProvider()) : (IValidator)descriptor.getProvider();
        }
        return this.fDefaultValueProvider;
    }

    public AttributeValueProviderDescriptor getProviderDescriptor(IConfiguration cfg) {
        Map<String, AttributeValueProviderDescriptor> map = this.getMap(cfg.getElementName());
        if (map != null) {
            return map.get(this.getProviderId(cfg));
        }
        return null;
    }

    private AttributeValueProviderDescriptor getDescriptor(ProviderType valueProvider, IConfiguration cfg, IAttribute attribute) {
        AttributeValueProviderDescriptor descriptor;
        String id = this.getProviderId(cfg);
        AttributeValueProviderDescriptor attributeValueProviderDescriptor = descriptor = id != null ? this.getMap(valueProvider).get(id) : this.getDefaultDescriptor(valueProvider, attribute);
        if (id != null && descriptor == null) {
            WorkItemCommonPlugin.log(NLS.bind((String)this.getNotFoundMessagePattern(valueProvider), (Object)id, (Object[])new Object[0]), null);
        }
        if (attribute == null) {
            return descriptor;
        }
        return this.validateType(descriptor, attribute.getAttributeType());
    }

    private AttributeValueProviderDescriptor getDefaultDescriptor(ProviderType valueProvider, IAttribute attribute) {
        if (attribute == null) {
            return null;
        }
        for (AttributeValueProviderDescriptor descriptor : this.getMap(valueProvider).values()) {
            if (!descriptor.handlesAttributeId(attribute.getIdentifier()) || !descriptor.isDefault()) continue;
            return descriptor;
        }
        return null;
    }

    private AttributeValueProviderDescriptor validateType(AttributeValueProviderDescriptor descriptor, String attributeType) {
        if (descriptor != null && !descriptor.handlesCompatibleType(attributeType)) {
            WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.CANNOT_HANDLE_TYPE"), (Object)descriptor.getId(), (Object[])new Object[]{attributeType}), null);
            return null;
        }
        return descriptor;
    }

    private String getNotFoundMessagePattern(ProviderType valueProvider) {
        switch (valueProvider) {
            case VALUE_PROVIDER: {
                return Messages.getString("AttributeValueProviderRegistry.VALUE_PROVIDER_NOT_FOUND");
            }
            case VALUE_SET_PROVIDER: {
                return Messages.getString("AttributeValueProviderRegistry.VALUESET_PROVIDER_NOT_FOUND");
            }
            case DEFAULT_VALUE_PROVIDER: {
                return Messages.getString("AttributeValueProviderRegistry.DEFAULTVALUE_PROVIDER_NOT_FOUND");
            }
            case CONDITION: {
                return Messages.getString("AttributeValueProviderRegistry.WORKITEM_FILTER_NOT_FOUND");
            }
            case VALIDATOR: {
                return Messages.getString("AttributeValueProviderRegistry.VALIDATOR_NOT_FOUND");
            }
        }
        throw new IllegalStateException();
    }

    protected AttributeValueProviderDescriptor handleExtensionAdded(IConfigurationElement element) throws Exception {
        AttributeValueProviderDescriptor descriptor = new AttributeValueProviderDescriptor(element);
        Map<String, AttributeValueProviderDescriptor> map = this.getMap(element.getName());
        if (map != null) {
            map.put(descriptor.getId(), descriptor);
        }
        return descriptor;
    }

    protected void handleExtensionRemoved(IConfigurationElement element, AttributeValueProviderDescriptor descriptor) throws Exception {
        Map<String, AttributeValueProviderDescriptor> map = this.getMap(element.getName());
        if (map != null) {
            map.remove(descriptor.getId());
        }
    }

    private Map<String, AttributeValueProviderDescriptor> getMap(String name) {
        ProviderType providerType = ProviderType.fromId(name);
        return providerType == null ? null : this.getMap(providerType);
    }

    private Map<String, AttributeValueProviderDescriptor> getMap(ProviderType providerType) {
        Map<String, AttributeValueProviderDescriptor> map;
        if (this.fDescriptorMaps == null) {
            this.fDescriptorMaps = new HashMap<ProviderType, Map<String, AttributeValueProviderDescriptor>>();
        }
        if ((map = this.fDescriptorMaps.get((Object)providerType)) == null) {
            map = new HashMap<String, AttributeValueProviderDescriptor>();
            this.fDescriptorMaps.put(providerType, map);
        }
        return map;
    }

    private String getProviderId(IConfiguration configuration) {
        return configuration != null ? configuration.getString("providerId") : null;
    }

    private static final class SafeDefaultValueProvider
    implements IDefaultValueProvider<Object> {
        private final IDefaultValueProvider<?> fDelegate;

        private SafeDefaultValueProvider(IDefaultValueProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public Object getDefaultValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getDefaultValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_DEFAULTVALUE_PROVIDER"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().getDefaultValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    private static final class SafeFilteredValueSetProvider
    implements IFilteredValueSetProvider<Object> {
        private final IFilteredValueSetProvider<?> fDelegate;

        private SafeFilteredValueSetProvider(IFilteredValueSetProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public List<?> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getFilteredValueSet(attribute, workItem, workItemCommon, configuration, "", monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_VALUESET_PROVIDER"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().getValueSet(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }

        @Override
        public List<?> getFilteredValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, String filter, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getFilteredValueSet(attribute, workItem, workItemCommon, configuration, filter, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_FILTEREDVALUESET_PROVIDER"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().getValueSet(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    private static final class SafeValidator
    implements IValidator {
        private final IValidator fDelegate;

        private SafeValidator(IValidator delegate) {
            Assert.isNotNull((Object)delegate);
            this.fDelegate = delegate;
        }

        @Override
        public IStatus validate(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.validate(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_VALIDATOR"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().validate(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    private static final class SafeValueProvider
    implements IValueProvider<Object> {
        private final IValueProvider<?> fDelegate;

        private SafeValueProvider(IValueProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public Object getValue(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_VALUE_PROVIDER"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().getValue(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    private static final class SafeValueSetProvider
    implements IValueSetProvider<Object> {
        private final IValueSetProvider<?> fDelegate;

        private SafeValueSetProvider(IValueSetProvider<?> delegate) {
            Assert.isNotNull(delegate);
            this.fDelegate = delegate;
        }

        @Override
        public List<?> getValueSet(IAttribute attribute, IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.getValueSet(attribute, workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_VALUESET_PROVIDER"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().getValueSet(attribute, workItem, workItemCommon, configuration, monitor);
            }
        }
    }

    private static final class SafeWorkItemFilter
    implements ICondition {
        private final ICondition fDelegate;

        private SafeWorkItemFilter(ICondition delegate) {
            Assert.isNotNull((Object)delegate);
            this.fDelegate = delegate;
        }

        @Override
        public boolean matches(IWorkItem workItem, IWorkItemCommon workItemCommon, IConfiguration configuration, IProgressMonitor monitor) throws TeamRepositoryException {
            try {
                return this.fDelegate.matches(workItem, workItemCommon, configuration, monitor);
            }
            catch (Exception e) {
                WorkItemCommonPlugin.log(NLS.bind((String)Messages.getString("AttributeValueProviderRegistry.ERROR_INVOKING_WORKITEM_FILTER"), (Object)AttributeValueProviderRegistry.getProviderConfigurationLabel(configuration), (Object[])new Object[0]), e);
                return new FallbackProvider().matches(workItem, workItemCommon, configuration, monitor);
            }
        }
    }
}

