/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.emailtemplates;

import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.process.common.IProcessConfigurationData;
import com.ibm.team.process.common.IProcessConfigurationElement;
import com.ibm.team.process.common.ModelElement;
import com.ibm.team.workitem.common.internal.emailtemplates.EmailTemplate;
import com.ibm.team.workitem.common.internal.emailtemplates.Messages;
import com.ibm.team.workitem.common.internal.util.LocalizationContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class EmailTemplateFactory {
    public static final String EMAIL_TEMPLATES_CONFIGURATION_DATA_POINT = "com.ibm.team.workitem.configuration.emailTemplates";
    public static final String EMAIL_TEMPLATES_CONFIGURATION_NS = "http://com.ibm.team.workitem/emailTemplates";
    public static final String TEMPLATE_ELEMENT_NAME = "emailTemplate";
    public static final String TEMPLATE_ID = "id";
    public static final String TEMPLATE_SUBJECT = "subject";
    public static final String TEMPLATE_HTML = "html";
    public static final String TEMPLATE_PLAIN = "plainText";
    private static HashMap<String, TemplateDescription> TEMPLATE_MAP = new HashMap();

    static {
        TEMPLATE_MAP.put(TemplateDescription.WORK_ITEM_CHANGE.getId(), TemplateDescription.WORK_ITEM_CHANGE);
        TEMPLATE_MAP.put(TemplateDescription.MESSAGES_AT_ME.getId(), TemplateDescription.MESSAGES_AT_ME);
        TEMPLATE_MAP.put(TemplateDescription.APPROVAL.getId(), TemplateDescription.APPROVAL);
    }

    private EmailTemplateFactory() {
        throw new AssertionError((Object)"instantiation of this class is not allowed");
    }

    public static List<EmailTemplate> getDefaultTemplates(LocalizationContext lc) {
        ArrayList<EmailTemplate> templates = new ArrayList<EmailTemplate>();
        TemplateDescription[] templateDescriptionArray = TemplateDescription.values();
        int n = templateDescriptionArray.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateDescription t = templateDescriptionArray[n2];
            EmailTemplate template = new EmailTemplate(t.getId());
            template.setName(Messages.getString(lc, t.getNameKey()));
            template.setDescription(Messages.getString(lc, t.getDescriptionKey()));
            template.setSubject(Messages.getString(lc, t.getDefaultSubjectKey()));
            template.setHTMLBody(Messages.getString(t.getDefaultHTMLKey()));
            template.setPlainTextBody(Messages.getString(lc, t.getDefaultPlainTextKey()));
            templates.add(template);
            ++n2;
        }
        return templates;
    }

    public static List<EmailTemplate> readTemplates(ModelElement configurationElement) {
        ArrayList<EmailTemplate> templates = new ArrayList<EmailTemplate>();
        if (configurationElement != null) {
            for (Object element : configurationElement.getChildElements()) {
                ModelElement templateElement = (ModelElement)element;
                if (!TEMPLATE_ELEMENT_NAME.equals(templateElement.getName())) continue;
                templates.add(EmailTemplateFactory.createFromModelElement(templateElement));
            }
        }
        return templates;
    }

    public static List<EmailTemplate> readTemplates(IProcessConfigurationData configurationElement) {
        ArrayList<EmailTemplate> templates = new ArrayList<EmailTemplate>();
        if (configurationElement != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = configurationElement.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (TEMPLATE_ELEMENT_NAME.equals(element.getName())) {
                    templates.add(EmailTemplateFactory.createFromProcessConfigurationElement(element));
                }
                ++n2;
            }
        }
        return templates;
    }

    public static EmailTemplate readTemplateWithID(IProcessConfigurationData configurationElement, String templateID) {
        if (configurationElement != null) {
            IProcessConfigurationElement[] iProcessConfigurationElementArray = configurationElement.getElements();
            int n = iProcessConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                String id;
                IProcessConfigurationElement element = iProcessConfigurationElementArray[n2];
                if (TEMPLATE_ELEMENT_NAME.equals(element.getName()) && (id = element.getAttribute(TEMPLATE_ID)).equals(templateID)) {
                    return EmailTemplateFactory.createFromProcessConfigurationElement(element);
                }
                ++n2;
            }
        }
        return null;
    }

    public static EmailTemplate createFromModelElement(ModelElement templateElement) {
        String id = templateElement.getAttribute(TEMPLATE_ID);
        String subject = templateElement.getAttribute(TEMPLATE_SUBJECT);
        String html = templateElement.getAttribute(TEMPLATE_HTML);
        String plain = templateElement.getAttribute(TEMPLATE_PLAIN);
        EmailTemplate template = new EmailTemplate(id);
        template.setSubject(subject);
        template.setPlainTextBody(plain);
        template.setHTMLBody(html);
        EmailTemplateFactory.loadNameAndDescription(template);
        return template;
    }

    public static EmailTemplate createFromProcessConfigurationElement(IProcessConfigurationElement element) {
        String id = element.getAttribute(TEMPLATE_ID);
        String subject = element.getAttribute(TEMPLATE_SUBJECT);
        String html = element.getAttribute(TEMPLATE_HTML);
        String plain = element.getAttribute(TEMPLATE_PLAIN);
        EmailTemplate template = new EmailTemplate(id);
        template.setSubject(subject);
        template.setPlainTextBody(plain);
        template.setHTMLBody(html);
        EmailTemplateFactory.loadNameAndDescription(template);
        return template;
    }

    public static void writeTemplatesToMemento(IMemento memento, List<EmailTemplate> templates) {
        for (EmailTemplate template : templates) {
            IMemento child = memento.createChild(TEMPLATE_ELEMENT_NAME);
            EmailTemplateFactory.writeTemplateToMemento(template, child);
        }
    }

    public static XMLMemento writeTemplateToNewMemento(EmailTemplate template) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TEMPLATE_ELEMENT_NAME);
        EmailTemplateFactory.writeTemplateToMemento(template, (IMemento)memento);
        return memento;
    }

    private static void writeTemplateToMemento(EmailTemplate template, IMemento memento) {
        memento.putString(TEMPLATE_ID, template.getID());
        memento.putString(TEMPLATE_SUBJECT, template.getSubject());
        memento.putString(TEMPLATE_HTML, template.getHTMLBody());
        memento.putString(TEMPLATE_PLAIN, template.getPlainTextBody());
    }

    private static void loadNameAndDescription(EmailTemplate template) throws AssertionError {
        TemplateDescription t = TEMPLATE_MAP.get(template.getID());
        if (t == null) {
            throw new AssertionError((Object)("unknown template type: " + template.getID()));
        }
        template.setName(Messages.getString(t.getNameKey()));
        template.setDescription(Messages.getString(t.getDescriptionKey()));
    }

    public static void sortTemplates(List<EmailTemplate> templates) {
        Collections.sort(templates, new Comparator<EmailTemplate>(){

            @Override
            public int compare(EmailTemplate o1, EmailTemplate o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    public static enum TemplateDescription {
        WORK_ITEM_CHANGE("com.ibm.team.workitem.configuration.emailTemplates.workItemChange", "EmailTemplatesAspectEditor_WORK_ITEM_CHANGED_TEMPLATE_NAME", "EmailTemplatesAspectEditor_WORK_ITEM_CHANGED_TEMPLATE_DESCRIPTION", "EmailTemplatesAspectEditor_WORK_ITEM_CHANGED_DEFAULT_TEMPLATE_SUBJECT", "EmailTemplatesAspectEditor_WORK_ITEM_CHANGED_DEFAULT_TEMPLATE_PLAIN_TEXT", "EmailTemplatesAspectEditor_WORK_ITEM_CHANGED_DEFAULT_TEMPLATE_HTML"),
        MESSAGES_AT_ME("com.ibm.team.workitem.configuration.emailTemplates.messagesAtMe", "EmailTemplatesAspectEditor_MESSAGES_AT_ME_TEMPLATE_NAME", "EmailTemplatesAspectEditor_MESSAGES_AT_ME_TEMPLATE_DESCRIPTION", "EmailTemplatesAspectEditor_MESSAGES_AT_ME_DEFAULT_TEMPLATE_SUBJECT", "EmailTemplatesAspectEditor_MESSAGES_AT_ME_DEFAULT_TEMPLATE_PLAIN_TEXT", "EmailTemplatesAspectEditor_MESSAGES_AT_ME_DEFAULT_TEMPLATE_HTML"),
        APPROVAL("com.ibm.team.workitem.configuration.emailTemplates.approval", "EmailTemplatesAspectEditor_APPROVAL_TEMPLATE_NAME", "EmailTemplatesAspectEditor_APPROVAL_TEMPLATE_DESCRIPTION", "EmailTemplatesAspectEditor_APPROVAL_DEFAULT_TEMPLATE_SUBJECT", "EmailTemplatesAspectEditor_APPROVAL_DEFAULT_TEMPLATE_PLAIN_TEXT", "EmailTemplatesAspectEditor_APPROVAL_DEFAULT_TEMPLATE_HTML");

        private final String fId;
        private final String fNameKey;
        private final String fDescriptionKey;
        private final String fDefaultSubjectKey;
        private final String fDefaultPlainTextKey;
        private final String fDefaultHTMLKey;

        private TemplateDescription(String id, String nameKey, String descriptionKey, String defaultSubjectKey, String defaultPlainTextKey, String defaultHTMLKey) {
            this.fId = id;
            this.fNameKey = nameKey;
            this.fDescriptionKey = descriptionKey;
            this.fDefaultSubjectKey = defaultSubjectKey;
            this.fDefaultPlainTextKey = defaultPlainTextKey;
            this.fDefaultHTMLKey = defaultHTMLKey;
        }

        public String getId() {
            return this.fId;
        }

        private String getNameKey() {
            return this.fNameKey;
        }

        private String getDescriptionKey() {
            return this.fDescriptionKey;
        }

        private String getDefaultSubjectKey() {
            return this.fDefaultSubjectKey;
        }

        private String getDefaultPlainTextKey() {
            return this.fDefaultPlainTextKey;
        }

        private String getDefaultHTMLKey() {
            return this.fDefaultHTMLKey;
        }
    }
}

