/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.util;

import org.eclipse.core.runtime.Assert;

public class FileSize {
    public static final FileSize INVALID = new FileSize(-2L);
    public static final FileSize UNSPECIFIED = new FileSize(-1L);
    private long fValue;

    public FileSize(long value) {
        Assert.isTrue((value >= -2L ? 1 : 0) != 0);
        this.fValue = value;
    }

    public FileSize add(FileSize fileSize) {
        if (!this.isValid()) {
            return this;
        }
        if (!fileSize.isValid()) {
            return fileSize;
        }
        if (!this.isSpecified()) {
            return fileSize;
        }
        if (!fileSize.isSpecified()) {
            return this;
        }
        return new FileSize(this.fValue + fileSize.fValue);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FileSize other = (FileSize)obj;
        return this.fValue == other.fValue;
    }

    public int hashCode() {
        return (int)(this.fValue ^ this.fValue >>> 32);
    }

    public boolean isSpecified() {
        return this.fValue > -1L;
    }

    public boolean isValid() {
        return this.fValue != -2L;
    }

    public long longValue() {
        return this.fValue;
    }
}

