/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.common.internal.workflow;

import com.ibm.team.workitem.common.workflow.IStateGroup;
import com.ibm.team.workitem.common.workflow.StateResolutionPair;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;

public class StateGroup
implements IStateGroup {
    private final Set<StateResolutionPair> fStateResolutionPairs = new HashSet<StateResolutionPair>();
    private final String fTopLevelGroupId;
    private final String fIdentifier;
    private final String fName;
    private final URL fIconUrl;
    private final List<IStateGroup.OSLCGroup> fOSLCGroups;

    StateGroup(String topLevelGroupId, String id, String name, URL iconUrl, List<IStateGroup.OSLCGroup> oslcGroups) {
        Assert.isNotNull((Object)topLevelGroupId);
        Assert.isNotNull((Object)id);
        Assert.isNotNull(oslcGroups);
        this.fTopLevelGroupId = topLevelGroupId;
        this.fIdentifier = id;
        this.fName = name;
        this.fIconUrl = iconUrl;
        this.fOSLCGroups = oslcGroups;
    }

    public StateGroup(String topLevelGroupId, String id, String name, URL iconUrl, List<IStateGroup.OSLCGroup> oslcGroups, Set<StateResolutionPair> stateResolutionPairs) {
        this(topLevelGroupId, id, name, iconUrl, oslcGroups);
        this.addStateResolutionPairs(stateResolutionPairs);
    }

    @Override
    public String getIdentifier() {
        return this.fIdentifier;
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public URL getIconUrl() {
        return this.fIconUrl;
    }

    @Override
    public String getTopLevelGroupId() {
        return this.fTopLevelGroupId;
    }

    @Override
    public List<IStateGroup.OSLCGroup> getOSLCGroups() {
        return Collections.unmodifiableList(this.fOSLCGroups);
    }

    @Override
    public Collection<StateResolutionPair> getStateResolutionPairs() {
        return Collections.unmodifiableCollection(this.fStateResolutionPairs);
    }

    @Override
    public boolean contains(StateResolutionPair pair) {
        return this.fStateResolutionPairs.contains(pair);
    }

    public boolean isEmpty() {
        return this.fStateResolutionPairs.isEmpty();
    }

    void addStateResolutionPair(StateResolutionPair pair) {
        this.fStateResolutionPairs.add(pair);
    }

    void addStateResolutionPairs(Set<StateResolutionPair> pairs) {
        this.fStateResolutionPairs.addAll(pairs);
    }

    void clear() {
        this.fStateResolutionPairs.clear();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("\n-------------");
        buffer.append("\nTop Level Group: ");
        buffer.append(this.fTopLevelGroupId);
        buffer.append("\nID: ");
        buffer.append(this.fIdentifier);
        buffer.append("\nName: ");
        buffer.append(this.fName);
        buffer.append("\nIcon: ");
        buffer.append(this.fIconUrl);
        buffer.append(this.fOSLCGroups.toString());
        buffer.append("\nPairs: ");
        for (StateResolutionPair pair : this.fStateResolutionPairs) {
            buffer.append("\n  (");
            buffer.append(pair.toString());
            buffer.append(")");
        }
        return buffer.toString();
    }
}

