/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client;

import com.ibm.team.links.common.ILink;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IEventSource;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.query.IItemQuery;
import com.ibm.team.repository.common.query.IItemQueryPage;
import com.ibm.team.scm.client.IBaselineConnection;
import com.ibm.team.scm.client.IConnection;
import com.ibm.team.scm.client.IVersionableManager;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.Visibility;
import com.ibm.team.scm.client.content.IVersionedContentManager;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineHandle;
import com.ibm.team.scm.common.IBaselineSetHandle;
import com.ibm.team.scm.common.IChangeSetHandle;
import com.ibm.team.scm.common.IComponent;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.IWorkspaceHandle;
import com.ibm.team.scm.common.dto.IBaselineSearchCriteria;
import com.ibm.team.scm.common.dto.IBaselineSetSearchCriteria;
import com.ibm.team.scm.common.dto.IChangeHistorySyncReport;
import com.ibm.team.scm.common.dto.IChangeSetLinkSummary;
import com.ibm.team.scm.common.dto.IChangeSetSearchCriteria;
import com.ibm.team.scm.common.dto.IComponentSearchCriteria;
import com.ibm.team.scm.common.dto.IConsolidatedChangeSetsPathReport;
import com.ibm.team.scm.common.dto.IConsolidatedChangesReport;
import com.ibm.team.scm.common.dto.ILocateChangeSetsSearchCriteria;
import com.ibm.team.scm.common.dto.ILocateChangeSetsSearchResult;
import com.ibm.team.scm.common.dto.ILockSearchCriteria;
import com.ibm.team.scm.common.dto.ILockSearchResult;
import com.ibm.team.scm.common.dto.IPagedFetchDescriptor;
import com.ibm.team.scm.common.dto.IPermissionContextProvider;
import com.ibm.team.scm.common.dto.IReadScope;
import com.ibm.team.scm.common.dto.IStreamLockReport;
import com.ibm.team.scm.common.dto.IUpdateReport;
import com.ibm.team.scm.common.dto.IVersionablePermissionsReport;
import com.ibm.team.scm.common.dto.IWorkspaceSearchCriteria;
import com.ibm.team.scm.common.internal.dto.CreateLinksResult;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;

public interface IWorkspaceManager
extends IEventSource {
    public static final String KNOWN_WORKSPACES = "workspaces";
    public static final String KNOWN_COMPONENTS = "components";
    public static final String KNOWN_BASELINES = "baselines";
    public static final String COMPONENT_OWNER = "component_owner";
    public static final String COMPONENT_VISIBILITY = "component_visibility";
    public static final String USER_SUSPENDED = "suspended";
    public static final String USER_LOCKS = "user_locks";
    public static final int MAX_LOCATE_CHANGESETS = 256;
    public static final int MAX_LOCATE_TARGETS = 512;
    public static final int MAX_QUERY_SIZE = 512;
    public static final String ITEM_PERMISSION_CHANGE_EVENT = "item_permission_change_event";

    public ITeamRepository teamRepository();

    public IVersionableManager versionableManager();

    public List knownWorkspaceConnections();

    public List knownBaselineConnections();

    public List knownComponents();

    public IWorkspaceConnection getWorkspaceConnection(IWorkspaceHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<? extends IWorkspaceConnection> getWorkspaceConnections(List<? extends IWorkspaceHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IBaselineConnection getBaselineConnection(IBaselineHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IBaselineConnection getBaselineConnection(IBaseline var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IWorkspaceConnection copyWorkspace(IAuditableHandle var1, IWorkspaceConnection var2, String var3, String var4, IProgressMonitor var5) throws TeamRepositoryException;

    public IWorkspaceConnection createWorkspace(IContributorHandle var1, String var2, String var3, IProgressMonitor var4) throws TeamRepositoryException;

    public IWorkspaceConnection createWorkspace(IContributorHandle var1, String var2, String var3, IWorkspaceConnection var4, IWorkspaceConnection var5, IProgressMonitor var6) throws TeamRepositoryException;

    public IWorkspaceConnection createWorkspace(IContributorHandle var1, String var2, String var3, IBaselineSetHandle var4, IProgressMonitor var5) throws TeamRepositoryException;

    public IWorkspaceConnection createStream(IProcessAreaHandle var1, String var2, String var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List findWorkspaceDeliverRelationships(IWorkspaceHandle var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List findWorkspaceAcceptRelationships(IWorkspaceHandle var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IItemQueryPage findWorkspacesByName(String var1, boolean var2, boolean var3, boolean var4, int var5, IProgressMonitor var6) throws TeamRepositoryException;

    public List<IWorkspaceHandle> findWorkspaces(IWorkspaceSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IWorkspaceHandle> findWorkspacesContainingChangeset(IChangeSetHandle var1, IWorkspaceSearchCriteria var2, int var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List<IWorkspaceHandle> findWorkspacesContainingComponent(IComponentHandle var1, IWorkspaceSearchCriteria var2, int var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List<ILocateChangeSetsSearchResult> locateChangeSets(ILocateChangeSetsSearchCriteria var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IItemQueryPage fetchNextPage(IItemQueryPage var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List findItems(IItemQuery var1, Object[] var2) throws TeamRepositoryException;

    public List findItems(IItemQuery var1, Object[] var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void deleteWorkspace(IWorkspaceHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IBaselineSetHandle safelyDeleteStream(IWorkspaceHandle var1, IWorkspaceConnection var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComment(IChangeSetHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setName(IBaselineSetHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComment(IBaselineSetHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List findComponents(String var1, IAuditableHandle var2, boolean var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List<IComponentHandle> findComponents(IComponentSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IAuditableHandle> findOwnersForComponents(List<? extends IComponentHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<Visibility> findVisibilityForComponents(List<? extends IComponentHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<IReadScope> findReadScopeForComponents(List<? extends IComponentHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List findBaselineSets(String var1, IProcessAreaHandle var2, boolean var3, IProgressMonitor var4) throws TeamRepositoryException;

    public List findBaselineSets(IBaselineSetSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IComponent createComponent(String var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void renameComponent(IComponentHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComponentOwnerAndVisibility(IComponentHandle var1, IAuditableHandle var2, IReadScope var3, IProgressMonitor var4) throws TeamRepositoryException;

    public void setComponentOwner(IComponentHandle var1, IAuditableHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void setComponentVisibility(IComponentHandle var1, Visibility var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List findAllWorkspaces(IAuditableHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public Set findAllWorkspaceNames(IAuditableHandle var1, IProgressMonitor var2) throws TeamRepositoryException;

    public Set<String> findAllComponentNames(IProgressMonitor var1) throws TeamRepositoryException;

    public List findAllBaselines(IComponentHandle var1, String var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IBaselineHandle> findBaselines(IBaselineSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public List<IChangeSetLinkSummary> getChangeSetLinkSummary(Collection<? extends IChangeSetHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public CreateLinksResult createLinks(String var1, IWorkspaceHandle var2, IChangeSetHandle var3, List<URI> var4, List<String> var5, List<String> var6, List<String> var7, boolean var8, boolean var9, IProgressMonitor var10) throws TeamRepositoryException;

    public void deleteLinks(List<ILink> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<IChangeSetHandle> findChangeSets(IChangeSetSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public void refreshWorkspaceConnections(Collection<IWorkspaceConnection> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public IVersionableLockOperationFactory lockOperationFactory();

    public void applyLockOperations(Collection<IVersionableLockOperation> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public Collection<IStreamLockReport> getLocks() throws TeamRepositoryException;

    public ILockSearchResult findLocks(ILockSearchCriteria var1, int var2, IProgressMonitor var3) throws TeamRepositoryException;

    public boolean sameRepository(IConnection var1);

    public List<IChangeSetHandle> suspendedChangeSets();

    public List<IChangeSetHandle> suspendedChangeSets(IComponentHandle var1);

    public void removeSuspended(Collection var1, IProgressMonitor var2) throws TeamRepositoryException;

    public List<IChangeSetHandle> transferChangeSetsFromRemoteRepository(List<IChangeSetHandle> var1, ITeamRepository var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IChangeHistorySyncReport compareBaselineSets(IBaselineSetHandle var1, IBaselineSetHandle var2, List<IComponentHandle> var3, IProgressMonitor var4) throws TeamRepositoryException;

    public IUpdateReport compareBaselineSetConfigurations(IBaselineSetHandle var1, IBaselineSetHandle var2, List<IComponentHandle> var3, IProgressMonitor var4) throws TeamRepositoryException;

    public void refresh(IProgressMonitor var1) throws TeamRepositoryException;

    public IVersionedContentManager getSCMContentManager();

    public void setPermissions(IVersionableHandle[] var1, IComponentHandle var2, IPermissionContextProvider var3, IProgressMonitor var4) throws TeamRepositoryException;

    public IPermissionContextProvider getPermissions(IVersionableHandle var1, IComponentHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IVersionablePermissionsReport[] getPermissions(IVersionableHandle[] var1, IComponentHandle var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IConsolidatedChangesReport getConsolidatedChanges(IChangeSetHandle[] var1, IPagedFetchDescriptor var2, IProgressMonitor var3) throws TeamRepositoryException;

    public IConsolidatedChangeSetsPathReport calculateParentPaths(IContextHandle var1, IChangeSetHandle[] var2, UUID[] var3, IVersionableHandle[] var4, IProgressMonitor var5) throws TeamRepositoryException;

    public void removeChangeSetLinks(List<IChangeSetHandle> var1, IProgressMonitor var2) throws TeamRepositoryException;

    public static interface IVersionableLockOperation {
    }

    public static interface IVersionableLockOperationFactory {
        public IVersionableLockOperation acquire(IVersionableHandle var1, IWorkspaceConnection var2, IComponentHandle var3);

        public IVersionableLockOperation acquireSubtree(IFolderHandle var1, IWorkspaceConnection var2, IComponentHandle var3);

        public IVersionableLockOperation release(IVersionableHandle var1, IWorkspaceConnection var2, IComponentHandle var3, boolean var4);

        public IVersionableLockOperation releaseSubtree(IFolderHandle var1, IWorkspaceConnection var2, IComponentHandle var3);

        public IVersionableLockOperation transfer(IVersionableHandle var1, IWorkspaceConnection var2, IComponentHandle var3, IContributorHandle var4);
    }
}

