/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.scm.client.internal;

import com.ibm.team.process.client.IClientProcess;
import com.ibm.team.process.client.IProcessItemService;
import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.advice.AdvisableOperation;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.client.IWorkspaceConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public abstract class SCMAdvisableOperation
extends AdvisableOperation {
    public SCMAdvisableOperation(String operationId, Object operationData, IProcessArea processArea, IDevelopmentLine developmentLine) {
        super(operationId, operationData, processArea, developmentLine);
    }

    public static ProcessOperationData getOperationDataFor(IWorkspaceConnection remoteConnection, IProgressMonitor monitor) throws TeamRepositoryException {
        IProcessItemService processService = (IProcessItemService)remoteConnection.teamRepository().getClientLibrary(IProcessItemService.class);
        if (processService == null) {
            return null;
        }
        IProcessArea processArea = null;
        IDevelopmentLine line = null;
        IAuditableHandle ownerHandle = remoteConnection.getResolvedWorkspace().getOwner();
        if (ownerHandle instanceof IProcessAreaHandle) {
            processArea = (IProcessArea)remoteConnection.teamRepository().itemManager().fetchCompleteItem((IItemHandle)ownerHandle, 0, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        IClientProcess process = processService.getClientProcess(processArea, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        if (processArea instanceof ITeamArea) {
            line = processService.getDevelopmentLine((IProcessArea)((ITeamArea)processArea), (IProgressMonitor)new SubProgressMonitor(monitor, 10));
        }
        return new ProcessOperationData(line, process, processArea);
    }

    public static class ProcessOperationData {
        private IDevelopmentLine target;
        private final IClientProcess process;
        private final IProcessArea processArea;

        ProcessOperationData(IDevelopmentLine target, IClientProcess process, IProcessArea processArea) {
            this.target = target;
            this.process = process;
            this.processArea = processArea;
        }

        public IDevelopmentLine getDevelopmentLine() {
            return this.target;
        }

        public IClientProcess getProcess() {
            return this.process;
        }

        public IProcessArea getProcessArea() {
            return this.processArea;
        }
    }
}

