/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.model.DBTableSizeDTO;
import java.util.Arrays;
import java.util.Comparator;

public class DBTableSizeStringBuilder {
    private static final String COMPONENT_COL = "Component";
    private static final String ITEM_TYPE_COL = "Item Type";
    private static final String ITEM_COUNT_COL = "Item Count";
    private static final String STATE_COUNT_COL = "State Count";
    private static final String CONTENT_SIZE_COL = "Content Size (K)";
    private static final String SPACE = " ";
    private static final String TAB = "                              ";
    private static final String SHORT_TAB = "                  ";

    public static String buildTableString(DBTableSizeDTO[] rows) {
        DBTableSizeDTO[] sortedRows = new DBTableSizeDTO[rows.length];
        System.arraycopy(rows, 0, sortedRows, 0, rows.length);
        Arrays.sort(sortedRows, new DBTableSizeDTOComparator());
        StringBuffer buffer = new StringBuffer(20000);
        buffer.append("=======================================================================================================================================================");
        DBTableSizeStringBuilder.addNewLine(buffer);
        buffer.append("Component                              Item Type                              Item Count                  State Count                  Content Size (K)");
        DBTableSizeStringBuilder.addNewLine(buffer);
        buffer.append("=======================================================================================================================================================");
        DBTableSizeStringBuilder.addNewLine(buffer);
        String lastComponent = null;
        DBTableSizeDTO[] dBTableSizeDTOArray = sortedRows;
        int n = sortedRows.length;
        int n2 = 0;
        while (n2 < n) {
            DBTableSizeDTO row = dBTableSizeDTOArray[n2];
            String component = row.getComponent();
            if (!component.equals(lastComponent)) {
                if (lastComponent != null) {
                    buffer.append("-------------------------------------------------------------------------------------------------------------------------------------------------------");
                    DBTableSizeStringBuilder.addNewLine(buffer);
                }
                buffer.append(component);
                lastComponent = component;
            } else {
                DBTableSizeStringBuilder.addSpaces(buffer, component.length());
            }
            DBTableSizeStringBuilder.addSpaces(buffer, COMPONENT_COL.length() + TAB.length() - component.length());
            buffer.append(row.getTypeName());
            DBTableSizeStringBuilder.addSpaces(buffer, ITEM_TYPE_COL.length() + TAB.length() - row.getTypeName().length());
            buffer.append(row.getItemCount());
            Long itemCount = row.getItemCount();
            DBTableSizeStringBuilder.addSpaces(buffer, ITEM_COUNT_COL.length() + SHORT_TAB.length() - itemCount.toString().length());
            buffer.append(row.getStateCount());
            Long stateCount = row.getStateCount();
            DBTableSizeStringBuilder.addSpaces(buffer, STATE_COUNT_COL.length() + SHORT_TAB.length() - stateCount.toString().length());
            buffer.append(row.getContentSize());
            DBTableSizeStringBuilder.addNewLine(buffer);
            ++n2;
        }
        return buffer.toString();
    }

    private static void addSpaces(StringBuffer buffer, int spacesNeeded) {
        int i = 0;
        while (i < spacesNeeded) {
            buffer.append(SPACE);
            ++i;
        }
    }

    private static void addNewLine(StringBuffer buffer) {
        buffer.append("\n");
    }

    private static class DBTableSizeDTOComparator
    implements Comparator<DBTableSizeDTO> {
        private DBTableSizeDTOComparator() {
        }

        @Override
        public int compare(DBTableSizeDTO o1, DBTableSizeDTO o2) {
            int componentCompare = o1.getComponent().compareTo(o2.getComponent());
            if (componentCompare != 0) {
                return componentCompare;
            }
            return o1.getTypeName().compareTo(o2.getTypeName());
        }
    }
}

