/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.utils;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;

public class UTF8InputStream
extends InputStream {
    private static final String UTF_8 = "UTF-8";
    private static final int BOM_BYTE_COUNT = 3;
    private PushbackInputStream pushbackStream;
    private boolean isChecked = false;

    public UTF8InputStream(InputStream in) {
        this.pushbackStream = new PushbackInputStream(in, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAndRemoveBOM() throws IOException {
        UTF8InputStream uTF8InputStream = this;
        synchronized (uTF8InputStream) {
            if (this.isChecked) {
                return;
            }
            this.isChecked = true;
            byte[] bom = new byte[3];
            int bytesRead = this.pushbackStream.read(bom, 0, bom.length);
            if (bytesRead != -1) {
                if (bytesRead < 3) {
                    this.pushbackStream.unread(bom, 0, bytesRead);
                } else if (bom[0] != -17 || bom[1] != -69 || bom[2] != -65) {
                    this.pushbackStream.unread(bom);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.pushbackStream.close();
    }

    @Override
    public int read() throws IOException {
        this.checkAndRemoveBOM();
        return this.pushbackStream.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.checkAndRemoveBOM();
        return this.pushbackStream.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkAndRemoveBOM();
        return this.pushbackStream.read(b, off, len);
    }

    @Override
    public boolean markSupported() {
        return this.pushbackStream.markSupported();
    }

    @Override
    public long skip(long n) throws IOException {
        this.checkAndRemoveBOM();
        return this.pushbackStream.skip(n);
    }

    public static InputStreamReader getUTF8InputStreamReader(InputStream inputStream) {
        return new InputStreamReader((InputStream)new UTF8InputStream(inputStream), Charset.forName(UTF_8));
    }

    public static BufferedReader getUTF8BufferedReader(InputStream inputStream) {
        return new BufferedReader(UTF8InputStream.getUTF8InputStreamReader(inputStream));
    }
}

