/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc.metadata;

import com.urbancode.air.vc.PersistentRecord;
import com.urbancode.air.vc.metadata.RawRecordMetadata;
import com.urbancode.air.vc.metadata.RecordMetadataGenerator;
import com.urbancode.persistence.IDGenerator;
import java.io.Serializable;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Type;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="vc_persistent_record_metadata")
@Cache(usage=CacheConcurrencyStrategy.READ_ONLY, region="vcCache")
@Immutable
public class RecordMetadata
implements Serializable {
    private static final long serialVersionUID = -7465955933156989477L;
    @Id
    @Column(name="id")
    @Type(type="uuid-char")
    private UUID id = IDGenerator.createID();
    @NotNull
    @Column(name="metadata_generator")
    @Length(min=1, max=255)
    private String metadataGeneratorName;
    @NotNull
    @Column(name="metadata_key")
    @Length(min=1, max=255)
    private String key;
    @NotNull
    @Column(name="metadata_value")
    @Length(min=1, max=255)
    private String value;
    @NotNull
    @ManyToOne
    @JoinColumn(name="persistent_record_id")
    private PersistentRecord record;
    @NotNull
    @Column(name="persistent_record_commit")
    private Long recordCommit;

    private RecordMetadata() {
    }

    public RecordMetadata(PersistentRecord record, RecordMetadataGenerator metadataGenerator, RawRecordMetadata rawMetadata) {
        this.record = record;
        this.recordCommit = record.getCommit();
        this.metadataGeneratorName = metadataGenerator.getClass().getName();
        this.key = rawMetadata.getKey();
        this.value = rawMetadata.getValue();
    }
}

