/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.vc.xml;

import com.urbancode.air.vc.VCHelper;
import com.urbancode.air.vc.xml.DocumentBuilderHelper;
import com.urbancode.commons.xml.marshall.BaseXMLHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XMLVCHelper<T>
extends BaseXMLHelper<T>
implements VCHelper<T> {
    private static final Logger log = Logger.getLogger(XMLVCHelper.class);
    private static final String CDATA_BEGIN = "<![CDATA[";
    private static final String CDATA_END = "]]>";

    public static String replaceIllegalXmlChars(String input) {
        StringBuilder builder = new StringBuilder();
        int length = input.length();
        int currentPos = 0;
        while (currentPos < length) {
            int repairBegins = input.indexOf(CDATA_BEGIN, currentPos);
            if (repairBegins == -1) {
                repairBegins = length;
            }
            String replaceThis = input.substring(currentPos, repairBegins);
            builder.append(XMLVCHelper.removeInvalidCharacterReferences(replaceThis));
            currentPos = repairBegins;
            int repairEnds = input.indexOf(CDATA_END, repairBegins);
            repairEnds = repairEnds == -1 ? length : (repairEnds += CDATA_END.length());
            builder.append(input.substring(repairBegins, repairEnds));
            currentPos = repairEnds;
        }
        String result = builder.toString();
        result = XMLVCHelper.removeIllegalCodePoints(result);
        return result;
    }

    private static String removeInvalidCharacterReferences(String input) {
        StringBuilder builder = new StringBuilder();
        int len = input.length();
        int beginRef = -1;
        int endRef = -1;
        int i = 0;
        while (i < len) {
            char c = input.charAt(i);
            if (beginRef == -1 && c == '&') {
                beginRef = i;
            } else if (beginRef > -1 && c == ';') {
                endRef = i;
            }
            if (beginRef > -1 && endRef > -1) {
                String charRef = input.substring(beginRef, endRef + 1);
                if (XMLVCHelper.isLegalCharacterReference(charRef)) {
                    builder.append(charRef);
                } else {
                    builder.append("&amp;");
                    i = beginRef;
                }
                beginRef = -1;
                endRef = -1;
            } else if (beginRef == -1) {
                builder.append(input.charAt(i));
            }
            if (i == len - 1 && beginRef != -1) {
                endRef = beginRef;
                continue;
            }
            ++i;
        }
        return builder.toString();
    }

    private static boolean isLegalCharacterReference(String str) {
        int codepoint;
        block7: {
            if (str.equals("&quot;") || str.equals("&lt;") || str.equals("&gt;") || str.equals("&amp;")) {
                return true;
            }
            if (str.length() <= 3) {
                return false;
            }
            int len = str.length();
            codepoint = -1;
            try {
                if (str.charAt(0) == '&' && str.charAt(1) == '#' && str.charAt(len - 1) == ';') {
                    if (str.charAt(2) == 'x') {
                        String hexValue = str.substring(3, len - 1);
                        codepoint = Integer.parseInt(hexValue, 16);
                    } else {
                        String decimalValue = str.substring(2, len - 1);
                        codepoint = Integer.parseInt(decimalValue, 10);
                    }
                }
            }
            catch (NumberFormatException e) {
                if (!log.isDebugEnabled()) break block7;
                log.debug((Object)String.format("Error parsing '%s'", str), (Throwable)e);
            }
        }
        return XMLVCHelper.isLegalCodePoint(codepoint);
    }

    private static String removeIllegalCodePoints(String input) {
        StringBuilder builder = new StringBuilder();
        for (int cp : XMLVCHelper.toCodePointArray(input)) {
            if (!XMLVCHelper.isLegalCodePoint(cp)) continue;
            builder.append(Character.toChars(cp));
        }
        return builder.toString();
    }

    private static boolean isLegalCodePoint(int cp) {
        return cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF;
    }

    private static int[] toCodePointArray(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Cannot convert null string to array");
        }
        int sLen = s.length();
        int cpCount = s.codePointCount(0, sLen);
        int[] result = new int[cpCount];
        int offset = 0;
        for (int i = 0; i < cpCount; ++i) {
            int cp;
            result[i] = cp = s.codePointAt(offset);
            offset += Character.charCount(cp);
        }
        return result;
    }

    @Override
    public void write(T persistent, OutputStream output) {
        try {
            Document document = this.toXML(persistent);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(output);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error writing XML for persistent " + persistent, e);
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Error writing XML for persistent " + persistent, e);
        }
        catch (TransformerException e) {
            throw new RuntimeException("Error writing XML for persistent " + persistent, e);
        }
    }

    @Override
    public T restore(InputStream input) {
        Object result;
        try {
            DocumentBuilder builder = DocumentBuilderHelper.getDocumentBuilder();
            Document document = builder.parse(input);
            result = this.toObject(document);
            if (result == null) {
                throw new RuntimeException(this.getClass().getName() + " returned a null object when converting from XML.");
            }
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        catch (SAXException e) {
            throw new RuntimeException("Error reading from stored XML", e);
        }
        return (T)result;
    }

    protected String getNullableStringAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        if (resultString != null && resultString.isEmpty()) {
            resultString = null;
        }
        return resultString;
    }

    protected UUID getUUIDAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        UUID result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = UUID.fromString(resultString);
        }
        return result;
    }

    protected Boolean getBooleanAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        Boolean result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = Boolean.valueOf(resultString);
        }
        return result;
    }

    protected Long getLongAttribute(Element element, String name) {
        String resultString = element.getAttribute(name);
        Long result = null;
        if (resultString != null && !resultString.isEmpty()) {
            result = Long.valueOf(resultString);
        }
        return result;
    }
}

