/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CommandResult;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.wvcm.WvcmException;

public class CCaseElemInfo
extends CCaseObjInfo {
    private String _elementType;
    private String _permissions;
    private static Map<String, String> ELEM_TYPES = null;
    private static Map<String, String> PERMISSIONS = null;

    public String getElemType() {
        return this._elementType;
    }

    public String getPermissions() {
        return this._permissions;
    }

    public CCaseElemInfo(CCaseLib cc, String universalSelector, boolean isDirectory, String pathName, String mtype, String creationDateString, String elementType, String permissions) {
        super(cc, universalSelector, isDirectory, pathName, mtype, creationDateString);
        this._elementType = elementType;
        this._permissions = permissions;
    }

    public static Map<String, CCaseElemInfo> getElemInfos(CCaseLib cc, Collection<String> pathNames, SrvcFeedback feedback) throws WvcmException {
        CommandResult.ResultBehaviorFlags flags = new CommandResult.ResultBehaviorFlags(CommandResult.ResultBehaviorFlags.Kind.IGNORE_NO_VIEW_INFO, CommandResult.ResultBehaviorFlags.Kind.NOT_FOUND_IMPLIES_BACKSLASH_IN_NAME_ON_WINDOWS);
        Map<String, CCaseElemInfo> elemInfos = CCaseElemInfo.getElemInfos(cc, pathNames, flags, feedback);
        if (elemInfos == null) {
            throw new IllegalStateException(pathNames + " not found, but no exception thrown");
        }
        return elemInfos;
    }

    private static void fixPermissions(CCaseLib cc, Map<String, CCaseElemInfo> elemInfos, SrvcFeedback feedback) throws WvcmException {
        int count = elemInfos.size();
        if (count == 0) {
            return;
        }
        String[] elemPaths = new String[count];
        int i = 0;
        for (String name : elemInfos.keySet()) {
            CCaseElemInfo elemInfo = elemInfos.get(name);
            if (elemInfo == null) continue;
            elemPaths[i++] = elemInfo.getPathName();
        }
        Map<String, String> results = cc.getExecutePermissionMap(feedback, elemPaths);
        for (String name : elemInfos.keySet()) {
            CCaseElemInfo elemInfo = elemInfos.get(name);
            if (elemInfo == null) continue;
            elemInfo._permissions = results.get(elemInfo.getPathName());
        }
    }

    private static Map<String, CCaseElemInfo> getElemInfos(CCaseLib cc, Collection<String> pathNames, CommandResult.ResultBehaviorFlags flags, SrvcFeedback feedback) throws WvcmException {
        HashMap<String, CCaseElemInfo> result = new HashMap<String, CCaseElemInfo>(pathNames.size());
        if (pathNames.size() == 0) {
            return result;
        }
        ArrayList<String> pathNamesList = new ArrayList<String>(pathNames);
        List<String[]> tokensList = cc.describeForElemInfo(pathNamesList, flags, feedback);
        Iterator<String> pathnamesIter = pathNames.iterator();
        for (String[] tokens : tokensList) {
            String name = pathnamesIter.next();
            if (tokens == null || tokens.length == 0) {
                result.put(name, null);
                continue;
            }
            if ("file element".equals(tokens[0])) {
                tokens[0] = "file element";
            } else if ("directory element".equals(tokens[0])) {
                tokens[0] = "directory element";
            }
            tokens[1] = String.valueOf(tokens[1].toCharArray());
            tokens[2] = String.valueOf(tokens[2].toCharArray());
            tokens[3] = String.valueOf(tokens[3].toCharArray());
            tokens[4] = CCaseElemInfo.optimizedElementType(tokens[4]);
            tokens[5] = CCaseElemInfo.optimizedPermission(tokens[5]);
            result.put(name, new CCaseElemInfo(cc, tokens[1], tokens[0].startsWith("directory"), tokens[2], tokens[0], tokens[3], tokens[4], tokens[5]));
        }
        return result;
    }

    private static String optimizedElementType(String elemType) {
        String ret;
        if (ELEM_TYPES == null) {
            ELEM_TYPES = new HashMap<String, String>();
        }
        if ((ret = ELEM_TYPES.get(elemType)) == null) {
            elemType = String.valueOf(elemType.toCharArray());
            ELEM_TYPES.put(elemType, elemType);
            ret = elemType;
        }
        return ret;
    }

    private static String optimizedPermission(String permission) {
        String ret;
        if (PERMISSIONS == null) {
            PERMISSIONS = new HashMap<String, String>();
        }
        if ((ret = PERMISSIONS.get(permission)) == null) {
            permission = String.valueOf(permission.toCharArray());
            PERMISSIONS.put(permission, permission);
            ret = permission;
        }
        return ret;
    }
}

