/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.calm.foundation.common.linking;

import com.ibm.team.calm.foundation.common.IHttpClient;
import com.ibm.team.calm.foundation.common.internal.Messages;
import com.ibm.team.calm.foundation.common.internal.linking.CALMBackLinkOperation;
import com.ibm.team.calm.foundation.common.internal.linking.HttpClientWrapper;
import com.ibm.team.calm.foundation.common.internal.linking.IHttpAccess;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformation;
import com.ibm.team.calm.foundation.common.linking.CALMLinkTypeInformationRegistry;
import com.ibm.team.calm.foundation.common.linking.OSLCResourceDescription;
import com.ibm.team.calm.foundation.common.linking.ResourceUpdater;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class CALMBackLinkUpdater {
    public static final int PROBLEM_MODIFYING_CALM_LINK = 327680;
    private final String fLinkedResourceUrl;
    private final String fLinkedResourceComment;
    private List<ResourceUpdater> fSuccessfulWrites;

    public CALMBackLinkUpdater(String linkedResourceUrl, String linkedResourceComment) throws IllegalArgumentException {
        if (linkedResourceUrl == null || linkedResourceComment == null) {
            throw new IllegalArgumentException();
        }
        this.fLinkedResourceUrl = linkedResourceUrl;
        this.fLinkedResourceComment = linkedResourceComment;
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<IReference> addedReferences, Collection<IReference> removedReferences, boolean ignoreProblems) throws TeamRepositoryException {
        ArrayList<BackLinkChange> changes = new ArrayList<BackLinkChange>();
        this.populateChanges(addedReferences, OperationType.ADD, changes);
        this.populateChanges(removedReferences, OperationType.REMOVE, changes);
        return this.updateBacklinks(httpClient, changes, ignoreProblems);
    }

    public IStatus updateBacklinks(IHttpClient httpClient, Collection<BackLinkChange> changes, boolean ignoreProblems) throws TeamRepositoryException {
        return this.updateBacklinksNew(httpClient, changes, ignoreProblems);
    }

    public IStatus updateBacklinks(IHttpAccess httpAccess, Collection<IReference> addedReferences, Collection<IReference> removedReferences, boolean ignoreProblems) throws TeamRepositoryException {
        httpAccess.setModifyingResponse(!ignoreProblems);
        return this.updateBacklinks(new HttpClientWrapper(httpAccess), addedReferences, removedReferences, ignoreProblems);
    }

    public IStatus updateBacklinks(IHttpAccess httpAccess, Collection<BackLinkChange> changes, boolean ignoreProblems) throws TeamRepositoryException {
        httpAccess.setModifyingResponse(!ignoreProblems);
        return this.updateBacklinksNew(new HttpClientWrapper(httpAccess), changes, ignoreProblems);
    }

    private IStatus updateBacklinksNew(IHttpClient httpAccess, Collection<BackLinkChange> changes, boolean ignoreProblems) throws TeamRepositoryException {
        if (httpAccess == null) {
            return Status.OK_STATUS;
        }
        MultiStatus status = new MultiStatus("com.ibm.team.calm.foundation.common", 327680, Messages.getString("CALMBackLinkUpdater.PROBLEM_ADD_OR_REMOVE_BACKLINKS"), null);
        Map<String, List<BackLinkChange>> groupByResourceUri = this.groupByResourceUri(changes);
        Collection<ResourceUpdater> successfulReads = this.readRemoteResources(httpAccess, groupByResourceUri, status, ignoreProblems);
        if (!status.isOK() && !ignoreProblems) {
            return this.mergeMultiStatus(status);
        }
        return this.tryToWriteModifications(successfulReads, ignoreProblems);
    }

    public void revert() {
        if (this.fSuccessfulWrites != null) {
            this.tryToRevertModifications(this.fSuccessfulWrites);
            this.fSuccessfulWrites = null;
        }
    }

    private void populateChanges(Collection<IReference> references, OperationType operationType, Collection<BackLinkChange> modifiedReferences) {
        if (references != null) {
            for (IReference reference : references) {
                modifiedReferences.add(new BackLinkChange(reference.createURI().toString(), reference.getLink().getLinkType().getLinkTypeId(), operationType));
            }
        }
    }

    private Map<String, List<BackLinkChange>> groupByResourceUri(Collection<BackLinkChange> changes) throws TeamRepositoryException {
        HashMap<String, List<BackLinkChange>> modifiedResources = new HashMap<String, List<BackLinkChange>>();
        for (BackLinkChange change : changes) {
            String sourceUrl = change.getUri();
            if (sourceUrl.equals(this.fLinkedResourceUrl)) continue;
            ArrayList<BackLinkChange> refs = (ArrayList<BackLinkChange>)modifiedResources.get(sourceUrl);
            if (refs == null) {
                refs = new ArrayList<BackLinkChange>();
                modifiedResources.put(sourceUrl, refs);
            }
            refs.add(change);
        }
        return modifiedResources;
    }

    private Collection<ResourceUpdater> readRemoteResources(IHttpClient httpAccess, Map<String, List<BackLinkChange>> changes, MultiStatus status, boolean ignoreProblems) throws TeamRepositoryException {
        ArrayList<ResourceUpdater> result = new ArrayList<ResourceUpdater>();
        for (Map.Entry<String, List<BackLinkChange>> entry : changes.entrySet()) {
            String sourceURL = entry.getKey();
            List<BackLinkChange> refs = entry.getValue();
            if (refs.isEmpty()) continue;
            try {
                ResourceUpdater resource = this.readRemoteResource(httpAccess, sourceURL, refs);
                if (resource == null) continue;
                result.add(resource);
            }
            catch (NotLoggedInException ex) {
                if (ignoreProblems) continue;
                throw ex;
            }
            catch (TeamRepositoryException ex) {
                status.add((IStatus)new Status(4, "com.ibm.team.calm.foundation.common", 327680, ex.getMessage(), (Throwable)ex));
            }
        }
        return result;
    }

    private ResourceUpdater readRemoteResource(IHttpClient httpAccess, String sourceURL, List<BackLinkChange> refs) throws TeamRepositoryException {
        HashSet<String> changedProperties = new HashSet<String>();
        OSLCResourceDescription targetResourceDescription = null;
        for (BackLinkChange ref : refs) {
            CALMLinkTypeInformation calmLinkType = ref.getCALMLinkType();
            String backLinkProp = calmLinkType.getTargetResourceBackLinkProperty();
            if (backLinkProp != null) {
                changedProperties.add(backLinkProp);
            }
            targetResourceDescription = calmLinkType.getTargetResourceDescription();
        }
        if (targetResourceDescription != null && !changedProperties.isEmpty()) {
            String[] requiredProperties = changedProperties.toArray(new String[changedProperties.size()]);
            ResourceUpdater updater = targetResourceDescription.loadResourceWithUpdater(sourceURL, null, httpAccess, requiredProperties);
            if (updater == null) {
                throw new TeamRepositoryException(NLS.bind((String)Messages.getString("CALMBackLinkUpdater.ERROR_UNKNOWN_VERSION"), (Object)sourceURL));
            }
            for (BackLinkChange ref : refs) {
                String propertyId = ref.getCALMLinkType().getTargetResourceBackLinkProperty();
                if (ref.getOperationType() == OperationType.ADD) {
                    updater.addLink(propertyId, this.fLinkedResourceUrl, this.fLinkedResourceComment);
                    continue;
                }
                updater.removeLink(propertyId, this.fLinkedResourceUrl);
            }
            return updater;
        }
        return null;
    }

    private IStatus tryToWriteModifications(Collection<ResourceUpdater> updaters, boolean ignoreProblems) throws NotLoggedInException {
        ArrayList<ResourceUpdater> result = new ArrayList<ResourceUpdater>();
        for (ResourceUpdater cur : updaters) {
            try {
                cur.write();
                result.add(cur);
            }
            catch (NotLoggedInException ex) {
                if (ignoreProblems) continue;
                this.tryToRevertModifications(result);
                throw ex;
            }
            catch (TeamRepositoryException ex) {
                if (ignoreProblems) continue;
                this.tryToRevertModifications(result);
                return new Status(4, "com.ibm.team.calm.foundation.common", 327680, ex.getMessage(), (Throwable)ex);
            }
        }
        this.fSuccessfulWrites = result;
        return Status.OK_STATUS;
    }

    private void tryToRevertModifications(Collection<ResourceUpdater> updates) {
        for (ResourceUpdater curOp : updates) {
            try {
                curOp.revert();
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
    }

    private IStatus mergeMultiStatus(MultiStatus status) {
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            return children[0];
        }
        StringBuilder builder = new StringBuilder();
        IStatus[] iStatusArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus curChild = iStatusArray[n2];
            builder.append(curChild.getMessage()).append('|');
            ++n2;
        }
        return new Status(status.getSeverity(), status.getPlugin(), status.getCode(), builder.toString(), null);
    }

    public static class BackLinkChange {
        private final String fTargetResourceUri;
        private final CALMLinkTypeInformation fCALMLinkType;
        private final OperationType fOperation;

        public BackLinkChange(String targetResourceUri, String linkTypeId, CALMBackLinkOperation.OperationType operationType) {
            this(targetResourceUri, linkTypeId, operationType.toNew());
        }

        public BackLinkChange(String targetResourceUri, String linkTypeId, OperationType operationType) {
            if (targetResourceUri == null || linkTypeId == null || operationType == null) {
                throw new IllegalArgumentException();
            }
            this.fTargetResourceUri = targetResourceUri;
            this.fCALMLinkType = CALMLinkTypeInformationRegistry.getLinkTypeInformation(linkTypeId);
            this.fOperation = operationType;
        }

        public String getUri() {
            return this.fTargetResourceUri;
        }

        public CALMLinkTypeInformation getCALMLinkType() {
            return this.fCALMLinkType;
        }

        public OperationType getOperationType() {
            return this.fOperation;
        }
    }

    public static enum OperationType {
        ADD,
        REMOVE;

    }
}

