/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.auth;

import com.ibm.team.repository.transport.auth.Messages;
import com.ibm.team.repository.transport.auth.Tracer;
import com.ibm.team.repository.transport.auth.TransportAuthException;
import java.text.MessageFormat;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.params.HttpClientParams;

public class TransportAuthUtil {
    public static final String X_NO_RETRY_HEADER = "X-com-ibm-team-repository.common.remoteaccess.noRetry";
    public static final String FORM_AUTH_HEADER = "X-com-ibm-team-repository-web-auth-msg";
    public static final String FORM_AUTH_REQUIRED_MSG = "authrequired";
    public static final String FORM_AUTH_FAILED_MSG = "authfailed";
    public static final String FORM_AUTH_URI = "j_security_check";
    public static final String FORM_AUTH_USER_FIELD = "j_username";
    public static final String FORM_AUTH_PASSWORD_FIELD = "j_password";
    public static final String FORM_LOGOUT_URI = "/auth/logout";
    public static final String FORM_AUTH_FAILED_URI = "/auth/authfailed";
    public static final String FORM_AUTH_REQUESTED_URI = "/auth/authrequired";
    public static final String FORM_AUTH = "FORM";
    public static final String BASIC_AUTH = "BASIC";
    public static final String LOCATION = "Location";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded; charset=utf-8";
    public static final String SLASH = "/";
    private static final String NLS_UNEXPECTED_LOGIN_ERROR = "TransportAuthUtil.UnexpectedLoginError";
    private static final String NLS_UNEXPECTED_STATUS = "TransportAuthUtil.UnexpectedStatus";
    private static final String NLS_INVALID_CREDENTIALS = "TransportAuthUtil.InvalidCredentials";
    private static final String NLS_SERVLET_ERROR = "TransportAuthUtil.ServletError";
    private static final String NLS_SERVER_CONFIG_ERROR = "TransportAuthUtil.ServerConfigError";
    private static final String NLS_LOGIN_ERROR = "TransportAuthUtil.LoginError";
    private static final Tracer _tracer = new Tracer(TransportAuthUtil.class);

    public static boolean formAuthRequested(HttpMethod method) {
        _tracer.enter("formAuthRequested", new Object[0]);
        try {
            Header locationHeader = method.getResponseHeader(LOCATION);
            boolean retval = TransportAuthUtil.hasAuthRequiredHeader(method) || locationHeader != null && locationHeader.getValue().matches("^.*/auth/authrequired.*$");
            _tracer.trace("formAuthRequested - %s", retval);
            boolean bl = retval;
            return bl;
        }
        finally {
            _tracer.leave("formAuthRequested", new Object[0]);
        }
    }

    public static boolean hasAuthRequiredHeader(HttpMethod method) {
        _tracer.enter("hasAuthRequiredHeader", new Object[0]);
        try {
            Header formAuthMsg = method.getResponseHeader(FORM_AUTH_HEADER);
            boolean retval = formAuthMsg != null && formAuthMsg.getValue().equals(FORM_AUTH_REQUIRED_MSG);
            _tracer.trace("hasAuthRequiredHeader - %s", retval);
            boolean bl = retval;
            return bl;
        }
        finally {
            _tracer.leave("hasAuthRequiredHeader", new Object[0]);
        }
    }

    public static HttpMethod formBasedAuthenticate(String repoPath, HostConfiguration hostConfig, HttpClient httpClient, UsernamePasswordCredentials storedCredentials, HttpState privateState) throws TransportAuthException {
        _tracer.enter("formBasedAuthenticate", new Object[0]);
        try {
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            String formAuthURI = String.valueOf(repoPath) + FORM_AUTH_URI;
            _tracer.debug("formAuthURI: %s", formAuthURI);
            PostMethod postMethod = new PostMethod(formAuthURI);
            try {
                int rc;
                block20: {
                    postMethod.addParameter(FORM_AUTH_USER_FIELD, storedCredentials.getUserName());
                    postMethod.addParameter(FORM_AUTH_PASSWORD_FIELD, storedCredentials.getPassword());
                    postMethod.setRequestHeader(CONTENT_TYPE_HEADER, CONTENT_TYPE_FORM_URLENCODED);
                    try {
                        rc = httpClient.executeMethod(hostConfig, (HttpMethod)postMethod, privateState);
                        _tracer.debug("statusCode: %d", rc);
                        if (rc != 400) break block20;
                        TransportAuthUtil.visitAuthenticatedURL(repoPath, httpClient, privateState);
                        HttpMethod method = TransportAuthUtil.formBasedAuthenticate(repoPath, hostConfig, httpClient, storedCredentials, privateState);
                        TransportAuthUtil.visitAuthenticatedURL(repoPath, httpClient, privateState);
                        HttpMethod httpMethod = method;
                        return httpMethod;
                    }
                    catch (Exception e) {
                        if (e.getClass().equals(TransportAuthException.class)) {
                            _tracer.trace("formBasedAuthenticate - re-throwing TransportAuthException", new Object[0]);
                            throw (TransportAuthException)e;
                        }
                        String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                        _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - %s", msg);
                        throw new TransportAuthException(msg, e);
                    }
                }
                Header authHeader = postMethod.getResponseHeader(FORM_AUTH_HEADER);
                if (authHeader != null) {
                    if (authHeader.getValue().equals(FORM_AUTH_REQUIRED_MSG)) {
                        _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - authHeader: %s", authHeader.getValue());
                        throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_SERVER_CONFIG_ERROR), FORM_AUTH_URI));
                    }
                    if (authHeader.getValue().equals(FORM_AUTH_FAILED_MSG)) {
                        _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - authHeader: %s", authHeader.getValue());
                        throw new TransportAuthException(Messages.getString(NLS_INVALID_CREDENTIALS));
                    }
                    _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - authHeader: %s", authHeader.getValue());
                    throw new TransportAuthException(MessageFormat.format(Messages.getString(NLS_SERVLET_ERROR), FORM_AUTH_REQUIRED_MSG, FORM_AUTH_FAILED_MSG, authHeader.getValue()));
                }
                if (rc == 302) {
                    String redirectURI = postMethod.getResponseHeader(LOCATION).getValue();
                    if (redirectURI.matches("^.*/auth/authfailed.*$")) {
                        _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - redirectUri: %s", redirectURI);
                        throw new TransportAuthException(Messages.getString(NLS_INVALID_CREDENTIALS));
                    }
                } else if (rc != 200) {
                    String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_STATUS), formAuthURI, 302, rc);
                    _tracer.trace("formBasedAuthenticate - throwing TransportAuthException - %s", msg);
                    throw new TransportAuthException(msg);
                }
            }
            finally {
                postMethod.releaseConnection();
            }
            PostMethod postMethod2 = postMethod;
            return postMethod2;
        }
        finally {
            _tracer.leave("formBasedAuthenticate", new Object[0]);
        }
    }

    public static void formBasedAuthenticate(String repoPath, HttpClient httpClient, UsernamePasswordCredentials storedCredentials, HttpState privateState) throws TransportAuthException {
        _tracer.enter("formBasedAuthenticate", new Object[0]);
        try {
            TransportAuthUtil.formBasedAuthenticate(repoPath, null, httpClient, storedCredentials, privateState);
        }
        finally {
            _tracer.leave("formBasedAuthenticate", new Object[0]);
        }
    }

    public static void visitAuthenticatedURL(String repoPath, HttpClient httpClient, HttpState privateState) throws TransportAuthException {
        TransportAuthUtil.visitAuthenticatedURLWithStatus(repoPath, httpClient, privateState);
    }

    public static int visitAuthenticatedURLWithStatus(String repoPath, HttpClient httpClient, HttpState privateState) throws TransportAuthException {
        _tracer.enter("visitAuthenticatedURL", new Object[0]);
        try {
            int statusCode;
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            GetMethod authenticatedURL = new GetMethod(String.valueOf(repoPath) + "authenticated/identity");
            _tracer.debug("Path: %s", authenticatedURL.getPath());
            authenticatedURL.setFollowRedirects(true);
            try {
                try {
                    statusCode = httpClient.executeMethod(null, (HttpMethod)authenticatedURL, privateState);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format(Messages.getString(NLS_UNEXPECTED_LOGIN_ERROR), e.getMessage());
                    _tracer.trace("visitAuthenticatedURL - throwning TransportAuthException: %s", msg);
                    throw new TransportAuthException(msg, e);
                }
            }
            finally {
                authenticatedURL.releaseConnection();
            }
            _tracer.debug("HTTP status code after touching \"%s\": %d", authenticatedURL.getPath(), statusCode);
            int n = statusCode;
            return n;
        }
        finally {
            _tracer.leave("visitAuthenticatedURL", new Object[0]);
        }
    }

    public static String determineAuthMethod(HttpClient httpClient, String repoPath) throws TransportAuthException {
        if (httpClient == null) {
            throw new IllegalArgumentException("httpClient must not be null");
        }
        if (repoPath == null) {
            throw new IllegalArgumentException("repoPath must not be null");
        }
        _tracer.enter("determineAuthMethod", new Object[0]);
        try {
            String string;
            if (!repoPath.endsWith(SLASH)) {
                repoPath = String.valueOf(repoPath) + SLASH;
            }
            repoPath = String.valueOf(repoPath) + FORM_AUTH_URI;
            _tracer.debug("path: %s", repoPath);
            GetMethod formAuth = new GetMethod(repoPath);
            String serverAuthMethod = null;
            formAuth.setFollowRedirects(false);
            try {
                try {
                    int rc = httpClient.executeMethod((HttpMethod)formAuth);
                    _tracer.debug("status: %d", rc);
                    serverAuthMethod = rc == 200 ? FORM_AUTH : (rc == 302 && formAuth.getResponseHeader("location").getValue().matches("^.*/auth/authfailed.*$") ? FORM_AUTH : BASIC_AUTH);
                }
                catch (Exception e) {
                    String msg = MessageFormat.format(Messages.getString(NLS_LOGIN_ERROR), e.getMessage());
                    _tracer.trace("determineAuthMethod - throwing TransportAuthException: %s", msg);
                    throw new TransportAuthException(msg, e);
                }
                _tracer.trace("determineAuthMethod - authMethod: %s", serverAuthMethod);
                string = serverAuthMethod;
            }
            catch (Throwable throwable) {
                formAuth.releaseConnection();
                throw throwable;
            }
            formAuth.releaseConnection();
            return string;
        }
        finally {
            _tracer.leave("determineAuthMethod", new Object[0]);
        }
    }

    public static void setCredentials(HttpClient httpClient, AuthScope authScope, String userid, String password) {
        _tracer.enter("setCredentials", new Object[0]);
        try {
            httpClient.getState().clearCredentials();
            httpClient.getState().clearCookies();
            if (userid == null || password == null) {
                HttpClientParams httpClientParams = httpClient.getParams();
                httpClientParams.setAuthenticationPreemptive(false);
            } else {
                UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(userid, password);
                httpClient.getState().setCredentials(authScope, (Credentials)defaultcreds);
            }
        }
        finally {
            _tracer.leave("setCredentials", new Object[0]);
        }
    }

    public static boolean credDefined(UsernamePasswordCredentials storedCredentials) {
        _tracer.enter("credDefined", new Object[0]);
        try {
            String storedUsername = null;
            String storedPassword = null;
            if (storedCredentials != null) {
                storedUsername = storedCredentials.getUserName();
                storedPassword = storedCredentials.getPassword();
            }
            boolean retval = storedUsername != null && storedUsername.length() != 0 && storedPassword != null && storedPassword.length() != 0;
            _tracer.trace("credDefined: %s", retval);
            boolean bl = retval;
            return bl;
        }
        finally {
            _tracer.leave("credDefined", new Object[0]);
        }
    }
}

