/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.reports.common.internal;

import com.ibm.team.reports.common.internal.IReportBundleRegistry;
import com.ibm.team.repository.common.FileLocator;
import com.ibm.team.repository.common.LogFactory;
import com.ibm.team.repository.common.util.ExtensionRegistryReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ReportBundleRegistry
extends ExtensionRegistryReader<String>
implements IReportBundleRegistry {
    private static final String PLUGIN_ID = "com.ibm.team.reports.common";
    private static final String EXTENSION_POINT_ID = "reportBundle";
    private static final String BUNDLE_ELEMENT_NAME = "bundle";
    private static final String MAP_FILE_ATTRIBUTE = "mapFile";
    private static final Log LOG = LogFactory.getLog((String)"com.ibm.team.reports");
    private final List<IReportBundleRegistry.ReportInfo> reports = new LinkedList<IReportBundleRegistry.ReportInfo>();
    private Map<String, IReportBundleRegistry.ReportInfo> idToInfoMap = null;
    private Map<String, IReportBundleRegistry.ReportInfo> nameToInfoMap = null;

    ReportBundleRegistry() {
        super(PLUGIN_ID, EXTENSION_POINT_ID);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IReportBundleRegistry.ReportInfo> getIdToInfoMap() {
        List<IReportBundleRegistry.ReportInfo> list = this.reports;
        synchronized (list) {
            if (this.idToInfoMap == null) {
                this.idToInfoMap = new HashMap<String, IReportBundleRegistry.ReportInfo>(this.reports.size());
                for (IReportBundleRegistry.ReportInfo reportInfo : this.reports) {
                    this.idToInfoMap.put(reportInfo.id, reportInfo);
                }
            }
            return this.idToInfoMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, IReportBundleRegistry.ReportInfo> getNameToInfoMap() {
        List<IReportBundleRegistry.ReportInfo> list = this.reports;
        synchronized (list) {
            if (this.nameToInfoMap == null) {
                this.nameToInfoMap = new HashMap<String, IReportBundleRegistry.ReportInfo>(this.reports.size());
                for (IReportBundleRegistry.ReportInfo reportInfo : this.reports) {
                    this.nameToInfoMap.put(reportInfo.name, reportInfo);
                }
            }
            return this.nameToInfoMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        List<IReportBundleRegistry.ReportInfo> list = this.reports;
        synchronized (list) {
            this.reports.clear();
            if (this.idToInfoMap != null) {
                this.idToInfoMap.clear();
                this.idToInfoMap = null;
            }
            if (this.nameToInfoMap != null) {
                this.nameToInfoMap.clear();
                this.nameToInfoMap = null;
            }
        }
    }

    protected String handleExtensionAdded(IConfigurationElement element) {
        if (element.getName().equals(BUNDLE_ELEMENT_NAME)) {
            String bundleSymbolicName = element.getDeclaringExtension().getContributor().getName();
            String mapFile = element.getAttribute(MAP_FILE_ATTRIBUTE);
            this.add(bundleSymbolicName, mapFile);
            return bundleSymbolicName;
        }
        return null;
    }

    protected void handleExtensionRemoved(IConfigurationElement element, String bundleSymbolicName) {
        if (element.getName().equals(BUNDLE_ELEMENT_NAME)) {
            this.remove(bundleSymbolicName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(String bundleSymboclicName, String mapFile) {
        block19: {
            URL url = FileLocator.find((String)bundleSymboclicName, (IPath)new Path(mapFile), null);
            if (url != null) {
                InputStream stream = null;
                try {
                    try {
                        stream = url.openStream();
                        Properties properties = new Properties();
                        properties.load(stream);
                        Enumeration<?> e = properties.propertyNames();
                        while (e.hasMoreElements()) {
                            String file;
                            String[] segments;
                            String id;
                            String path;
                            Object property = e.nextElement();
                            if (property == null || !(property instanceof String) || (path = properties.getProperty(id = ((String)property).trim())) == null) continue;
                            path = path.trim();
                            if (id.length() == 0 || path.length() == 0 || (segments = path.split("/")).length == 0 || (segments = (file = segments[segments.length - 1]).split("\\.")).length == 0) continue;
                            String name = segments[0].trim();
                            IReportBundleRegistry.ReportInfo reportInfo = new IReportBundleRegistry.ReportInfo(id, name, bundleSymboclicName, path);
                            List<IReportBundleRegistry.ReportInfo> list = this.reports;
                            synchronized (list) {
                                this.reports.add(reportInfo);
                            }
                        }
                    }
                    catch (IOException iOException) {
                        LOG.error((Object)("Could not open file: " + bundleSymboclicName + '.' + mapFile));
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException2) {}
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            stream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(String bundleSymbolicName) {
        List<IReportBundleRegistry.ReportInfo> list = this.reports;
        synchronized (list) {
            ListIterator<IReportBundleRegistry.ReportInfo> i = this.reports.listIterator();
            while (i.hasNext()) {
                IReportBundleRegistry.ReportInfo reportInfo = i.next();
                if (!reportInfo.bundle.equals(bundleSymbolicName)) continue;
                i.remove();
            }
        }
    }
}

