/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models;

import com.google.gson.annotations.SerializedName;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.http.ContentType;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientIntegrated;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Change;
import com.urbancode.release.rest.models.ChangeType;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Team;
import com.urbancode.release.rest.models.Version;
import com.urbancode.release.rest.models.internal.ApplicationEnvironment;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.TaskPlan;
import java.util.Map;

public class Application
extends ClientIntegrated<Application> {
    public Team[] teams;
    public String[] releaseEnvironments;
    public String level;
    public Boolean automated;
    public Application[] children;
    @JsonReadOnly
    public Version[] versions;
    @SerializedName(value="targets")
    @JsonReadOnly
    public ApplicationEnvironment[] applicationEnvironments;
    @JsonReadOnly
    public TaskPlan[] tasks;
    @JsonReadOnly
    public Release.ChangeCount totalChanges;

    public Application() {
        this.path = "/applications/";
        this.oldPath = "/application/";
    }

    public Team[] getTeams() {
        return this.teams;
    }

    public Application setTeams(Team ... teams) {
        return this.teams(teams);
    }

    public Application teams(Team ... teams) {
        this.handleNull(teams, "teams");
        this.teams = teams;
        return this;
    }

    public Version[] getVersions() {
        return this.versions;
    }

    public Application setReleaseEnvironments(ReleaseEnvironment ... releaseEnvironments) {
        return this.releaseEnvironments(releaseEnvironments);
    }

    public Application releaseEnvironments(ReleaseEnvironment ... releaseEnvironments) {
        this.handleNull(releaseEnvironments, "releaseEnvironments");
        this.releaseEnvironments = Application.ids(releaseEnvironments);
        return this;
    }

    public String getLevel() {
        return this.level;
    }

    public Boolean getAutomated() {
        return this.automated;
    }

    public Application[] getChildren() {
        return this.children;
    }

    public Application children(Application[] children) {
        this.children = children;
        return this;
    }

    public ApplicationEnvironment[] getApplicationEnvironments() {
        return this.applicationEnvironments;
    }

    public TaskPlan[] getTasks() {
        return this.tasks;
    }

    public Release.ChangeCount getTotalChanges() {
        return this.totalChanges;
    }

    public Application setAutomated(boolean automated) {
        return this.automated(automated);
    }

    public Application automated(boolean automated) {
        this.automated = automated;
        return this;
    }

    public String[] getReleaseEnvironments() {
        return this.releaseEnvironments;
    }

    @Deprecated
    public Application[] getAllWithTeams() {
        return ((Response)this.query.apply(RestAssured.given()).expect().contentType(ContentType.JSON).when().get(this.oldPath() + "teams", new Object[0])).as(Application[].class, ObjectMapperType.GSON);
    }

    @Deprecated
    public Application getByExternalId(String externalId) {
        return ((Response)RestAssured.expect().contentType(ContentType.JSON).get(this.oldPath() + "externalId/" + externalId, new Object[0])).as(Application.class, ObjectMapperType.GSON);
    }

    @Deprecated
    public Response integrateByExternalId(String externalId) {
        return (Response)RestAssured.given().post(this.oldPath() + "externalId/" + externalId + "/integrate", new Object[0]);
    }

    @Deprecated
    public ApplicationEnvironment[] getApplicationEnvironmentsRemote() {
        return ((Response)RestAssured.given().get(this.oldPath(this.id) + "/targets", new Object[0])).as(ApplicationEnvironment[].class);
    }

    @Deprecated
    public Version[] getVersionsRemote() {
        return ((Response)RestAssured.given().get(this.oldPath(this.id) + "/versions", new Object[0])).as(Version[].class);
    }

    public Response updateChanges(Change ... changes) {
        for (Change change : changes) {
            change.application(this);
        }
        return new Change.ChangesUpdate().changes(changes).type(Change.ChangeAssociation.APPLICATION).id(this.id).send();
    }

    public Application defaults() {
        return this.teams(Team.SAMPLE_TEAM);
    }

    public int getChangeCount(Change.Status status, ChangeType type) {
        Map<String, Release.ChangeTotal> statusObject;
        switch (status) {
            case ACCEPTED: {
                statusObject = this.totalChanges.Accepted;
                break;
            }
            case COMPLETED: {
                statusObject = this.totalChanges.Completed;
                break;
            }
            case IN_PROGRESS: {
                statusObject = this.totalChanges.InProgress;
                break;
            }
            case NEW: {
                statusObject = this.totalChanges.New;
                break;
            }
            default: {
                statusObject = this.totalChanges.Other;
            }
        }
        if (type == null) {
            return statusObject.get((Object)"total").count;
        }
        return statusObject.get((Object)type.id).count;
    }
}

