/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.google.common.base.Objects;
import com.jayway.restassured.RestAssured;
import com.jayway.restassured.internal.mapper.ObjectMapperType;
import com.jayway.restassured.response.Response;
import com.urbancode.release.rest.framework.ClientEntity;
import com.urbancode.release.rest.framework.Clients;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.Application;
import com.urbancode.release.rest.models.RecurringDeployment;
import com.urbancode.release.rest.models.Release;
import com.urbancode.release.rest.models.Role;
import com.urbancode.release.rest.models.Team;
import com.urbancode.release.rest.models.User;
import com.urbancode.release.rest.models.Version;
import com.urbancode.release.rest.models.internal.ApprovalSet;
import com.urbancode.release.rest.models.internal.ApprovalTemplate;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.DeploymentExecutionUpdate;
import com.urbancode.release.rest.models.internal.DeploymentPlan;
import com.urbancode.release.rest.models.internal.FederatedDeployment;
import com.urbancode.release.rest.models.internal.InternalClients;
import com.urbancode.release.rest.models.internal.Phase;
import com.urbancode.release.rest.models.internal.ReleaseEnvironment;
import com.urbancode.release.rest.models.internal.SegmentExecution;
import com.urbancode.release.rest.models.internal.Task;
import com.urbancode.release.rest.models.internal.TaskExecution;
import com.urbancode.release.rest.models.internal.TaskPlan;
import com.urbancode.release.rest.models.internal.TaskTag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ScheduledDeployment
extends ClientEntity<ScheduledDeployment> {
    public String description;
    public Long scheduledDate;
    public Long endTimeOverride;
    public Long completionTimeOverride;
    public Release release;
    public Phase phase;
    public ReleaseEnvironment environment;
    public Role role;
    public ApprovalSet approval;
    public DeploymentPlan deploymentPlan;
    public RecurringDeployment rule;
    public Boolean autoPickVersions;
    public Boolean autoStart;
    public Boolean autoManualTaskNotification;
    public Boolean regexPattern;
    public String pattern;
    public String versionId;
    public Boolean deleteEndTimeOverride;
    @JsonReadOnly
    public String status;
    @JsonReadOnly
    public String gateStatus;
    @JsonReadOnly
    public String shortName;
    @JsonReadOnly
    public String derivedName;
    @JsonReadOnly
    public User creator;
    @JsonReadOnly
    public User executingUserId;
    @JsonReadOnly
    public String executingUser;
    @JsonReadOnly
    public Version[] versions;
    @JsonReadOnly
    public Boolean projectedVersions;
    @JsonReadOnly
    public Version[] selectedVersions;
    @JsonReadOnly
    public Version[] autoSelectedVersions;
    @JsonReadOnly
    public DeploymentExecution deploymentExecution;
    @JsonReadOnly
    public Application[] notApplicableApplications;
    @JsonReadOnly
    public FederatedDeployment[] federatedDeployments;
    @JsonReadOnly
    public Phase[] phases;
    public DeploymentExecutionUpdate update;

    public ScheduledDeployment() {
        this.path = "/scheduledDeployments/";
        this.oldPath = "/scheduledDeployment/";
        this.writeToOldPath = true;
    }

    public Long getScheduledDate() {
        return this.scheduledDate;
    }

    public Long getEndTimeOverride() {
        return this.endTimeOverride;
    }

    public DeploymentExecution getDeploymentExecution() {
        return this.deploymentExecution;
    }

    public String getStatus() {
        return this.status;
    }

    public Release getRelease() {
        return this.release;
    }

    public ScheduledDeployment scheduledDate(Long scheduledDate) {
        this.scheduledDate = scheduledDate;
        return this;
    }

    public ScheduledDeployment endTimeOverride(Long endTimeOverride) {
        this.endTimeOverride = endTimeOverride;
        return this;
    }

    public ScheduledDeployment completionTimeOverride(Long completionTimeOverride) {
        this.completionTimeOverride = completionTimeOverride;
        return this;
    }

    public ScheduledDeployment release(Release release) {
        this.handleNull(release, "release");
        this.release = release;
        return this;
    }

    public ScheduledDeployment phase(Phase phase) {
        this.handleNull(phase, "phase");
        this.phase = phase;
        return this;
    }

    public ScheduledDeployment environment(ReleaseEnvironment environment) {
        this.handleNull(environment, "environment");
        this.environment = environment;
        return this;
    }

    public ScheduledDeployment role(Role role) {
        this.handleNull(role, "role");
        this.role = role;
        return this;
    }

    public ScheduledDeployment deploymentPlan(DeploymentPlan deploymentPlan) {
        this.handleNull(deploymentPlan, "deploymentPlan");
        this.deploymentPlan = deploymentPlan;
        return this;
    }

    public ScheduledDeployment deleteEndTimeOverride(boolean deleteEndTimeOverride) {
        this.deleteEndTimeOverride = deleteEndTimeOverride;
        return this;
    }

    public ScheduledDeployment addVersion(Version version) {
        RestAssured.given().post(this.oldPath(this.id) + "/version/" + version.id, new Object[0]);
        return this;
    }

    public ScheduledDeployment removeVersion(Version version) {
        RestAssured.given().delete(this.oldPath(this.id) + "/version/" + version.id, new Object[0]);
        return this;
    }

    public ScheduledDeployment excludeApplication(Version version) {
        RestAssured.given().post(this.oldPath(this.id) + "/version/" + version.id + "/exclude", new Object[0]);
        return this;
    }

    public ScheduledDeployment createReleaseVersion(String name) {
        RestAssured.given().body(String.format("{\"name\":\"%s\"}", name)).put(this.oldPath(this.id) + "/snapshot", new Object[0]);
        return this;
    }

    public ScheduledDeployment execute() {
        RestAssured.given().put(this.oldPath(this.id) + "/execute", new Object[0]);
        return this;
    }

    public ScheduledDeployment abort() {
        RestAssured.given().put(this.oldPath(this.id) + "/abort", new Object[0]);
        return this;
    }

    public ScheduledDeployment reopen() {
        RestAssured.given().put(this.oldPath(this.id) + "/reopen", new Object[0]);
        return this;
    }

    public static ScheduledDeployment provisionSimpleDeployment(Release release, ReleaseEnvironment env, Application app) {
        if (((Release)release.get()).phases.length == 0) {
            throw new RuntimeException("The Release must have at least one phase to use provisionSimpleDeployment");
        }
        release.addApplication(app);
        Clients.environmentReservation().startDate(946702800000L).endDate(4102462800000L).environment(env).phase(release.phases[0]).save();
        return (ScheduledDeployment)InternalClients.scheduledDeployment().release(release).phase(release.phases[0]).environment(env).deploymentPlan(release.phases[0].deploymentPlan).scheduledDate(1402517280000L).save();
    }

    public static ScheduledDeployment provisionSimpleDeployment(String newReleaseName, ReleaseEnvironment env, String newAppName) {
        Long oneMonth = 2764800000L;
        return ScheduledDeployment.provisionSimpleDeployment((Release)((Release)Clients.release().defaults().targetDate(System.currentTimeMillis() + oneMonth).name(newReleaseName)).save(), env, (Application)((Application)Clients.application().name(newAppName)).releaseEnvironments(env).teams(Team.SAMPLE_TEAM).save());
    }

    public static ScheduledDeployment provisionSimpleDeploymentWithVersion(String newReleaseName, ReleaseEnvironment env, String newAppName, String newVersionName) {
        ScheduledDeployment sd = ScheduledDeployment.provisionSimpleDeployment(newReleaseName, env, newAppName);
        return sd.addVersion((Version)((Version)Clients.version().name(newVersionName)).application(sd.release.baseApplication.children[0]).save());
    }

    public static ScheduledDeployment provisionSimpleDeploymentWithVersion(Release release, ReleaseEnvironment env, Application app, Version version) {
        return ScheduledDeployment.provisionSimpleDeployment(release, env, app).addVersion(version);
    }

    @Deprecated
    public static ScheduledDeployment provisionSuperDeployment() {
        ScheduledDeployment sd = ScheduledDeployment.provisionSimpleDeploymentWithVersion("Release for Super SD " + System.currentTimeMillis(), ReleaseEnvironment.DEV_1, "App for Super SD " + System.currentTimeMillis(), "1.0");
        ((ApprovalTemplate)InternalClients.approvalTemplate().phaseId(((Release)sd.getRelease().get()).getPhases()[0].getId()).executorRoleId(Role.ADMIN.id).name("Approval for Super Deployment" + System.currentTimeMillis())).save();
        DeploymentPlan plan2 = DeploymentPlan.createSimpleDeploymentPlan("DeploymentPlan_" + System.currentTimeMillis(), ((ScheduledDeployment)sd.get()).release, 3, 3);
        TaskTag tag = (TaskTag)((TaskTag)InternalClients.taskTag().name("Tag for Super SD " + System.currentTimeMillis())).color("#000000").save();
        TaskPlan taskPlan1 = (TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)((TaskPlan)InternalClients.taskPlan().name("Adding task with a Role to Plan")).taskPattern(Task.ExecutionPattern.ALWAYS)).executorRoleOrGroup(Role.ADMIN)).updateVersion(false)).save();
        DeploymentPlan plan = (DeploymentPlan)((Phase)((Release)sd.getRelease().get()).phases[0].get()).deploymentPlan.get();
        ((DeploymentPlan)((DeploymentExecution)sd.getDeploymentExecution().get()).deploymentPlan.get()).segments[0].addTask(taskPlan1);
        return sd;
    }

    public static List<ScheduledDeployment> getDeploymentsForReleasePhaseEnvironment(Release r, Phase p, ReleaseEnvironment e) {
        ArrayList<ScheduledDeployment> result = new ArrayList<ScheduledDeployment>();
        for (ScheduledDeployment sd : (ScheduledDeployment[])InternalClients.scheduledDeployment().getAll()) {
            if (!sd.release.id.equals(r.id) || !sd.phase.id.equals(p.id) || !sd.environment.id.equals(e.id)) continue;
            result.add(sd);
        }
        return result;
    }

    @Deprecated
    public DeploymentExecutionUpdate getUpdate() {
        DeploymentExecutionUpdate result;
        this.update = result = ((DeploymentExecutionUpdate)InternalClients.deploymentExecutionUpdate().id(this.id)).scheduledDeployment(this).getUpdate();
        return result;
    }

    public UpdateFormat getUpdateFormat() {
        return ((Response)RestAssured.given().param("format", "update").get("/scheduledDeployments/" + this.id, new Object[0])).as(UpdateFormat.class, ObjectMapperType.GSON);
    }

    public static class InnerUpdate {
        public Long lastRefresh;
        public String name;
        public Long startTimePlanned;
        public Long startTimeEstimated;
        public Long startTimeActual;
        public Long endTimePlanned;
        public Long endTimeEstimated;
        public Long endTimeActual;
        public Long durationPlanned;
        public Long durationRemaining;
        public String status;
        public String result;
        public Boolean belongsToCurrentUser;
        public Boolean isReady;
        public String userId;
        public String userName;
    }

    public static class UpdateFormat {
        public Boolean refresh;
        public Map<String, InnerUpdate> update;

        public InnerUpdate getUpdateFor(ClientEntity<?> fullEntity) {
            return this.update.get(fullEntity.id);
        }

        public boolean matches(TaskExecution task) {
            InnerUpdate patch = this.getUpdateFor(task);
            return Objects.equal(task.status, patch.status) && Objects.equal(task.result, patch.result);
        }

        public boolean matches(SegmentExecution segment) {
            InnerUpdate patch = this.getUpdateFor(segment);
            boolean match = Objects.equal(segment.status, patch.status);
            if (!match) {
                return false;
            }
            for (TaskExecution task : segment.tasks) {
                if (this.matches(task)) continue;
                return false;
            }
            return true;
        }

        public boolean matches(DeploymentExecution deployment) {
            InnerUpdate patch = this.getUpdateFor(deployment);
            boolean match = Objects.equal(deployment.status, patch.status);
            if (!match) {
                return false;
            }
            for (SegmentExecution segment : deployment.segments) {
                if (this.matches(segment)) continue;
                return false;
            }
            return true;
        }

        public boolean matches(ScheduledDeployment sd) {
            return this.matches(sd.deploymentExecution);
        }
    }
}

