/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import net.oauth.client.ExcerptInputStream;
import net.oauth.client.URLConnectionResponse;
import net.oauth.http.HttpClient;
import net.oauth.http.HttpMessage;
import net.oauth.http.HttpResponseMessage;

public class URLConnectionClient
implements HttpClient {
    private static final String EOL = "\r\n";

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpResponseMessage execute(HttpMessage request) throws IOException {
        void var8_14;
        String key;
        String httpMethod = request.method;
        List<Map.Entry<String, String>> addHeaders = request.headers;
        URL url = request.url;
        URLConnection connection = url.openConnection();
        connection.setDoInput(true);
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection http = (HttpURLConnection)connection;
            http.setRequestMethod(httpMethod);
            http.setInstanceFollowRedirects(false);
        }
        StringBuilder headers = new StringBuilder(httpMethod);
        headers.append(" ").append(url.getPath());
        String query = url.getQuery();
        if (query != null && query.length() > 0) {
            headers.append("?").append(query);
        }
        headers.append(EOL);
        for (Map.Entry<String, List<String>> entry : connection.getRequestProperties().entrySet()) {
            key = entry.getKey();
            for (String value : entry.getValue()) {
                headers.append(key).append(": ").append(value).append(EOL);
            }
        }
        String contentLength = null;
        for (Map.Entry<String, List<String>> entry : addHeaders) {
            key = entry.getKey();
            if ("Content-Length".equalsIgnoreCase(key) && connection instanceof HttpURLConnection) {
                contentLength = (String)((Object)entry.getValue());
            } else {
                connection.setRequestProperty(key, (String)((Object)entry.getValue()));
            }
            headers.append(key).append(": ").append((String)((Object)entry.getValue())).append(EOL);
        }
        byte[] byArray = null;
        InputStream body = request.getBody();
        if (body != null) {
            try {
                if (contentLength != null) {
                    ((HttpURLConnection)connection).setFixedLengthStreamingMode(Integer.parseInt(contentLength));
                }
                connection.setDoOutput(true);
                OutputStream output = connection.getOutputStream();
                try {
                    int n;
                    ExcerptInputStream ex = new ExcerptInputStream(body);
                    byte[] b = new byte[1024];
                    while ((n = ex.read(b)) > 0) {
                        output.write(b, 0, n);
                    }
                    byte[] byArray2 = ex.getExcerpt();
                }
                finally {
                    output.close();
                }
            }
            finally {
                body.close();
            }
        }
        return new URLConnectionResponse(request, headers.toString(), (byte[])var8_14, connection);
    }
}

