/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.common.internal.process.config;

import com.ibm.team.filesystem.common.internal.process.ComponentMatchBlock;
import com.ibm.team.filesystem.common.internal.util.StringMatcher;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.internal.process.PCD_asObject;
import com.ibm.team.scm.common.internal.process.PCD_defaultValue;
import com.ibm.team.scm.common.internal.process.PCD_mayBeNull;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ProtectFileTypeAdvisorConfig {
    public static String ROOT_NODE_NAME = "config";
    @PCD_mayBeNull
    public ComponentMatchBlock compMatcher = new ComponentMatchBlock();
    public List<VersionableMatchRule> pathMatchers = new ArrayList<VersionableMatchRule>();
    @PCD_defaultValue(value="ALLOW_MATCHES")
    @PCD_asObject
    public Mode mode = Mode.ALLOW_MATCHES;

    public List<MatcherInitializationException> initMatchers() {
        ArrayList<MatcherInitializationException> exceptions = new ArrayList<MatcherInitializationException>();
        for (VersionableMatchRule rule : this.pathMatchers) {
            try {
                rule.initMatcher();
            }
            catch (MatcherInitializationException e) {
                exceptions.add(e);
            }
        }
        return exceptions;
    }

    public static class MatcherInitializationException
    extends TeamRepositoryException {
        private static final long serialVersionUID = 7909502540457045602L;
        public final VersionableMatchRule rule;

        public MatcherInitializationException(VersionableMatchRule rule) {
            super("Bad matcher: " + rule.matchText);
            this.rule = rule;
        }
    }

    public static enum MatcherType {
        NAME_PATTERN,
        REGEX;

    }

    public static enum Mode {
        DENY_MATCHES,
        ALLOW_MATCHES;

    }

    public static class VersionableMatchRule {
        public String matchText = "";
        public MatcherType type = MatcherType.NAME_PATTERN;
        public boolean matchAll = true;
        public boolean matchAddition = false;
        public boolean matchDelete = false;
        public boolean matchModify = false;
        public boolean matchRename = false;
        public boolean matchMove = false;
        private transient Pattern regex;
        private transient StringMatcher stringMatcher;

        public boolean matches(String name) {
            if (this.type == MatcherType.NAME_PATTERN) {
                return this.stringMatcher.match(name);
            }
            return this.regex.matcher(name).find();
        }

        public boolean matchesChangeType(int changeType, IVersionable previous, IVersionable current) {
            if (this.matchAll) {
                return true;
            }
            if (this.matchAddition && VersionableMatchRule.eq(1, changeType) || this.matchDelete && VersionableMatchRule.eq(2, changeType) || this.matchModify && VersionableMatchRule.eq(4, changeType)) {
                return true;
            }
            if (VersionableMatchRule.eq(8, changeType)) {
                if (this.matchRename && !previous.getName().equals(current.getName())) {
                    return true;
                }
                if (this.matchMove) {
                    if (previous.getParent() == null) {
                        return current.getParent() != null;
                    }
                    if (current.getParent() == null) {
                        return previous.getParent() != null;
                    }
                    if (!current.getParent().sameItemId((IItemHandle)previous.getParent())) {
                        return true;
                    }
                }
            }
            return false;
        }

        private static boolean eq(int type, int toCheck) {
            return type == (type & toCheck);
        }

        public void initMatcher() throws MatcherInitializationException {
            if (this.type == MatcherType.NAME_PATTERN) {
                this.stringMatcher = new StringMatcher(this.matchText, false, false);
                return;
            }
            try {
                this.regex = Pattern.compile(this.matchText);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new MatcherInitializationException(this);
            }
        }
    }
}

