/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.common.internal.model.WorkItem;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ListChangeDetails;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class WorkItemChangeEvent
extends WorkItemEvent {
    protected static final int UNDEFINED_CHANGE = 0;
    public static final int LOCAL_CHANGE = 1;
    public static final int REMOTE_CHANGE = 2;
    public static final int UPGRADE_CHANGE = 3;
    private final IWorkItem fWorkItem;
    private Map<String, AttributeChange> fAttributeDetails;
    private Map<String, List<String>> fDependenciesMap;
    private Map<String, String[]> fDependentsMap;
    private Map<String, IStatus> fValidationStatusMap;

    public WorkItemChangeEvent(IWorkItem workItem) {
        this.fWorkItem = workItem;
    }

    public IWorkItem getWorkItem() {
        return this.fWorkItem;
    }

    @Override
    public WorkItemEvent.EventKind getKind() {
        return WorkItemEvent.EventKind.ATTRIBUTE_CHANGE;
    }

    public void addAttributeDetails(String attributeIdentifier, String[] attributeDependents, IAdaptable details, int type) {
        this.addAttributeDetails(attributeIdentifier, attributeDependents, details, type, null);
    }

    public void addAttributeDetails(String attributeIdentifier, String[] attributeDependents, IAdaptable details, int type, IStatus validationStatus) {
        if (this.fAttributeDetails == null) {
            this.fAttributeDetails = new HashMap<String, AttributeChange>();
        }
        if (!this.fAttributeDetails.containsKey(attributeIdentifier)) {
            this.fAttributeDetails.put(attributeIdentifier, new AttributeChange(details, type));
        } else {
            ListChangeDetails second;
            ListChangeDetails first;
            AttributeChange change = this.fAttributeDetails.get(attributeIdentifier);
            if (change.getDetails() instanceof ListChangeDetails && details instanceof ListChangeDetails) {
                Object found;
                first = (ListChangeDetails)change.getDetails();
                second = (ListChangeDetails)details;
                ArrayList<Object> added = new ArrayList<Object>(first.getAdded());
                ArrayList<Object> removed = new ArrayList<Object>(first.getRemoved());
                for (Object element : second.getAdded()) {
                    found = this.find(removed, element);
                    if (found != null) {
                        removed.remove(found);
                        continue;
                    }
                    added.add(element);
                }
                for (Object element : second.getRemoved()) {
                    found = this.find(added, element);
                    if (found != null) {
                        added.remove(found);
                        continue;
                    }
                    removed.add(element);
                }
                Object newDetails = change.getDetails() instanceof ReferencesChangeDetails ? new ReferencesChangeDetails(added, removed) : new ListChangeDetails(added, removed);
                this.fAttributeDetails.put(attributeIdentifier, new AttributeChange((IAdaptable)newDetails, type));
            } else if (change.getDetails() instanceof ChangeDetails && details instanceof ChangeDetails) {
                first = (ChangeDetails)change.getDetails();
                second = (ChangeDetails)details;
                this.fAttributeDetails.put(attributeIdentifier, new AttributeChange((IAdaptable)new ChangeDetails(first.getOldValue(), second.getNewValue()), type));
            } else {
                this.fAttributeDetails.put(attributeIdentifier, new AttributeChange(null, type));
            }
        }
        if (attributeDependents.length > 0) {
            if (this.fDependenciesMap == null) {
                this.fDependenciesMap = new HashMap<String, List<String>>();
            }
            int i = 0;
            while (i < attributeDependents.length) {
                String dependent = attributeDependents[i];
                List<String> dependencies = this.fDependenciesMap.get(dependent);
                if (dependencies == null) {
                    dependencies = new ArrayList<String>();
                    this.fDependenciesMap.put(dependent, dependencies);
                }
                dependencies.add(attributeIdentifier);
                ++i;
            }
            if (this.fDependentsMap == null) {
                this.fDependentsMap = new HashMap<String, String[]>();
            }
            this.fDependentsMap.put(attributeIdentifier, attributeDependents);
        }
        if (validationStatus != null) {
            if (this.fValidationStatusMap == null) {
                this.fValidationStatusMap = new HashMap<String, IStatus>();
            }
            this.fValidationStatusMap.put(attributeIdentifier, validationStatus);
        }
    }

    public String[] getChangedAttributes() {
        if (this.fAttributeDetails == null) {
            return new String[0];
        }
        Set<String> keySet = this.fAttributeDetails.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }

    public IAdaptable getAttributeChangeDetails(String attributeIdentifier) {
        if (this.fAttributeDetails == null) {
            return null;
        }
        AttributeChange attributeChange = this.fAttributeDetails.get(attributeIdentifier);
        if (attributeChange == null) {
            return null;
        }
        return attributeChange.getDetails();
    }

    public <T> T getAttributeChangeDetails(String attributeIdentifier, Class<T> adapter) {
        IAdaptable details = this.getAttributeChangeDetails(attributeIdentifier);
        return (T)(details != null ? details.getAdapter(adapter) : null);
    }

    public int getAttributeChangeType(String attributeIdentifier) {
        if (this.fAttributeDetails == null) {
            return 0;
        }
        AttributeChange attributeChange = this.fAttributeDetails.get(attributeIdentifier);
        if (attributeChange == null) {
            return 0;
        }
        return attributeChange.getKind();
    }

    public String[] getAffectedDependents() {
        if (this.fDependenciesMap == null) {
            return new String[0];
        }
        Set<String> dependents = this.fDependenciesMap.keySet();
        return dependents.toArray(new String[dependents.size()]);
    }

    public String[] getChangedDependencies(String dependentIdentifier) {
        if (this.fDependenciesMap == null) {
            return new String[0];
        }
        List<String> dependents = this.fDependenciesMap.get(dependentIdentifier);
        if (dependents == null) {
            return new String[0];
        }
        return dependents.toArray(new String[dependents.size()]);
    }

    public String[] getDependentAttributes(String identifier) {
        if (this.fDependentsMap == null) {
            return new String[0];
        }
        String[] dependents = this.fDependentsMap.get(identifier);
        if (dependents == null) {
            return new String[0];
        }
        return dependents;
    }

    public boolean affects(String attributeIdentifier) {
        return ((WorkItem)this.fWorkItem).isAttributeSet(attributeIdentifier) && this.fAttributeDetails != null && this.fAttributeDetails.containsKey(attributeIdentifier);
    }

    public boolean affectsDependencies(String dependentIdentifier) {
        return this.fDependenciesMap != null && this.fDependenciesMap.containsKey(dependentIdentifier);
    }

    public boolean affects(IWorkItemHandle workItem) {
        return this.fWorkItem.sameItemId((IItemHandle)workItem);
    }

    public IStatus getValidationStatus(String attributeId) {
        IStatus status = this.fValidationStatusMap == null ? Status.OK_STATUS : this.fValidationStatusMap.get(attributeId);
        return status == null ? Status.OK_STATUS : status;
    }

    private Object find(List<Object> removed, Object element) {
        for (Object current : removed) {
            if (!this.equals(current, element)) continue;
            return current;
        }
        return null;
    }

    private boolean equals(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        return left != null && left.equals(right);
    }

    private static class AttributeChange {
        private IAdaptable fDetails;
        private int fKind;

        public AttributeChange(IAdaptable details, int kind) {
            this.fDetails = details;
            this.fKind = kind;
        }

        public IAdaptable getDetails() {
            return this.fDetails;
        }

        public int getKind() {
            return this.fKind;
        }
    }
}

