/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal;

import com.ibm.team.process.common.advice.IOperationReport;
import com.ibm.team.process.common.advice.ProcessRunnable;
import com.ibm.team.process.internal.common.advice.OperationReport;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.IWorkItemRepositoryService;
import com.ibm.team.workitem.common.internal.rcp.dto.StatusResultDTO;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class WorkItemDeleteRunnable
extends ProcessRunnable {
    private final IClientLibraryContext fContext;
    private IWorkItemHandle[] fWorkItems;
    private StatusResultDTO[] fStatus;

    public WorkItemDeleteRunnable(IWorkItemHandle workItem, IClientLibraryContext context) {
        this(Collections.singletonList(workItem), context);
    }

    public WorkItemDeleteRunnable(List<IWorkItemHandle> workItems, IClientLibraryContext context) {
        this.fContext = context;
        this.fWorkItems = workItems != null ? workItems.toArray(new IWorkItemHandle[workItems.size()]) : new IWorkItemHandle[]{};
    }

    public IOperationReport run(IProgressMonitor monitor) throws TeamRepositoryException {
        this.fStatus = (StatusResultDTO[])this.fContext.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<StatusResultDTO[]>(){

            public StatusResultDTO[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                IWorkItemRepositoryService workItemService = (IWorkItemRepositoryService)WorkItemDeleteRunnable.this.fContext.getServiceInterface(IWorkItemRepositoryService.class);
                return workItemService.deleteWorkItems(WorkItemDeleteRunnable.this.fWorkItems);
            }
        }, monitor);
        return this.mergeOperationReport();
    }

    public StatusResultDTO[] getStatus() {
        return this.fStatus;
    }

    public void dispose() {
        this.fWorkItems = null;
        this.fStatus = null;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    private OperationReport mergeOperationReport() {
        OperationReport report = null;
        StatusResultDTO[] statusResultDTOArray = this.fStatus;
        int n = this.fStatus.length;
        int n2 = 0;
        while (n2 < n) {
            StatusResultDTO curRes = statusResultDTOArray[n2];
            IOperationReport curReport = curRes.getOperationReport();
            if (curReport != null) {
                if (report == null) {
                    report = (OperationReport)curReport;
                } else {
                    report.append(curReport);
                }
            }
            ++n2;
        }
        return report;
    }
}

