/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.ILink;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.client.URIService;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;

public class ClientUtils {
    public static <T> T getClientLibrary(IItemHandle handle, Class<T> clazz) {
        ITeamRepository repository = (ITeamRepository)handle.getOrigin();
        return (T)repository.getClientLibrary(clazz);
    }

    public static IProgressMonitor getProgressMonitor(IProgressMonitor monitor) {
        if (monitor != null) {
            return monitor;
        }
        return new NullProgressMonitor();
    }

    public static <T> T castObject(Object input, Class<T> clazz) {
        if (input == null) {
            return null;
        }
        if (clazz.isAssignableFrom(input.getClass())) {
            return (T)input;
        }
        if (input instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)input;
            return (T)adaptable.getAdapter(clazz);
        }
        return null;
    }

    public static void copyStream(InputStream in, OutputStream out, IProgressMonitor monitor) throws IOException {
        byte[] bytes = new byte[32000];
        int length = in.read(bytes);
        while (length > -1) {
            out.write(bytes, 0, length);
            monitor.worked(length);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            length = in.read(bytes);
        }
    }

    public static void silentClose(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {}
    }

    public static URI createURI(String repositoryURIInContext, IReference reference) {
        String repositoryURI = ClientUtils.getRepositoryURI(repositoryURIInContext, reference);
        if (reference.isItemReference() && ((IItemReference)reference).getReferencedItem() instanceof IAuditableHandle) {
            return Location.itemLocation((IItemHandle)((IItemReference)reference).getReferencedItem(), (String)repositoryURI, (String)reference.getExtraInfo(), null).toAbsoluteUri();
        }
        if (reference.isURIReference()) {
            URI uri = ((IURIReference)reference).getURI();
            if (uri.isAbsolute() || repositoryURI == null) {
                return uri;
            }
            try {
                return Location.location((Location)Location.location((URI)uri), (String)repositoryURI, null).toAbsoluteUri();
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (IllegalStateException illegalStateException) {}
            return uri;
        }
        return null;
    }

    public static IItemHandle findItemHandle(String repositoryURIInContext, IReference reference) {
        IItemHandle handle = null;
        if (reference.isItemReference()) {
            handle = ((IItemReference)reference).getReferencedItem();
        } else if (reference.isURIReference()) {
            try {
                handle = URIService.resolveItemHandle(ClientUtils.createURI(repositoryURIInContext, reference));
            }
            catch (TeamRepositoryException teamRepositoryException) {}
        }
        if (handle != null && handle.getOrigin() == null) {
            try {
                ITeamRepository teamRepository;
                String repositoryURI = ClientUtils.getRepositoryURI(repositoryURIInContext, reference);
                if (repositoryURI != null && (teamRepository = ClientURIUtils.findTeamRepository((URI)new URI(repositoryURI))) != null) {
                    ((ItemHandle)handle).setOrigin((Object)teamRepository);
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            if (handle.getOrigin() == null) {
                handle = null;
            }
        }
        return handle;
    }

    private static String getRepositoryURI(String repositoryURIInContext, IReference reference) {
        String repositoryURI = ClientUtils.getRepositoryURI(reference);
        if (repositoryURI == null || repositoryURI.length() == 0) {
            repositoryURI = repositoryURIInContext;
        }
        if (repositoryURI == null || repositoryURI.length() == 0) {
            return null;
        }
        return repositoryURI;
    }

    private static String getRepositoryURI(IReference reference) {
        ILink link;
        IItemHandle handle;
        if (reference.isItemReference() && (handle = ((IItemReference)reference).getReferencedItem()).getOrigin() instanceof ITeamRepository) {
            return ((ITeamRepository)handle.getOrigin()).getRepositoryURI();
        }
        if (reference.isURIReference()) {
            try {
                URI uri = ((IURIReference)reference).getURI();
                Location location = Location.location((URI)uri);
                String repoUri = location.getRepoUri();
                if (repoUri != null && repoUri.length() != 0) {
                    return repoUri;
                }
            }
            catch (TeamRepositoryException teamRepositoryException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        if ((link = reference.getLink()) != null && link.getOrigin() instanceof ITeamRepository) {
            return ((ITeamRepository)link.getOrigin()).getRepositoryURI();
        }
        return null;
    }
}

