/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.util;

import com.ibm.team.process.common.IAccessGroup;
import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.internal.util.Messages;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import org.eclipse.core.runtime.IProgressMonitor;

public class ResolvedAccessContext {
    private UUID fContext;
    private Object fElement;

    public ResolvedAccessContext(UUID uuid) {
        this.fContext = uuid;
        this.fElement = uuid;
    }

    public ResolvedAccessContext(IProcessArea processArea) {
        this.fContext = processArea.getItemId();
        this.fElement = processArea;
    }

    public ResolvedAccessContext(IAccessGroup accessGroup) {
        this.fContext = accessGroup.getGroupContextId();
        this.fElement = accessGroup;
    }

    public boolean isAccessGroup() {
        return this.fElement instanceof IAccessGroup;
    }

    public boolean isProcessArea() {
        return this.fElement instanceof IProcessArea;
    }

    public UUID getContextId() {
        return this.fContext;
    }

    public Object getElement() {
        return this.fElement;
    }

    public String getLabel() {
        if (this.fContext.equals((Object)IContext.PUBLIC)) {
            return Messages.ResolvedAccessContext_PUBLIC;
        }
        if (this.fElement instanceof IAccessGroup) {
            return ((IAccessGroup)this.fElement).getName();
        }
        if (this.fElement instanceof IProcessArea) {
            return ((IProcessArea)this.fElement).getName();
        }
        return NLS.bind((String)Messages.ResolvedAccessContext_UNKNOWN_CONTEXT, (Object)this.fContext, (Object[])new Object[0]);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ResolvedAccessContext) {
            return this.fContext.equals((Object)((ResolvedAccessContext)obj).getContextId());
        }
        return false;
    }

    public int hashCode() {
        return this.fContext.hashCode();
    }

    public static ResolvedAccessContext resolveContext(IAuditableCommon auditableCommon, UUID contextId, IProgressMonitor monitor) throws TeamRepositoryException {
        Object accessContext = auditableCommon.resolveAccessContext(contextId, monitor);
        if (accessContext instanceof IProcessArea) {
            return new ResolvedAccessContext((IProcessArea)accessContext);
        }
        if (accessContext instanceof IAccessGroup) {
            return new ResolvedAccessContext((IAccessGroup)accessContext);
        }
        return new ResolvedAccessContext(contextId);
    }

    public static ResolvedAccessContext getDefaultContext(IWorkItemCommon workItemCommon, IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        ICategoryHandle categoryHandle;
        IAuditableCommon auditableCommon = workItemCommon.getAuditableCommon();
        ICategory category = (ICategory)auditableCommon.resolveAuditable((IAuditableHandle)(categoryHandle = workItem.getCategory()), ICategory.SMALL_PROFILE, monitor);
        if (category.isReadAccessEnabled()) {
            IProcessAreaHandle processAreaHandle = workItemCommon.findProcessArea((IWorkItemHandle)workItem, monitor);
            IProcessArea processArea = (IProcessArea)auditableCommon.resolveAuditable((IAuditableHandle)processAreaHandle, ItemProfile.PROCESS_AREA_DEFAULT, monitor);
            return new ResolvedAccessContext(processArea);
        }
        IProjectArea projectArea = (IProjectArea)auditableCommon.resolveAuditable((IAuditableHandle)workItem.getProjectArea(), ItemProfile.PROJECT_AREA_DEFAULT, monitor);
        return new ResolvedAccessContext((IProcessArea)projectArea);
    }
}

