/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.transport.client;

import com.ibm.team.repository.transport.client.CertificateStore;
import com.ibm.team.repository.transport.client.ITrustStoreProvider;
import java.io.File;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class SharedTrustStoreProvider
implements ITrustStoreProvider {
    private static CertificateStore sessionCerts;
    private static CertificateStore runtimeCerts;
    private static final String userTrustStoreLocation;
    private static final String userTrustStorePassword;

    static {
        String userHome = System.getProperty("user.home");
        userTrustStoreLocation = String.valueOf(userHome) + "/.jazzcerts".replace('/', File.separatorChar);
        userTrustStorePassword = "ibmrationaljazz";
    }

    private static synchronized void buildSessionTrustStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (sessionCerts == null) {
            sessionCerts = new CertificateStore();
        }
    }

    private static synchronized void buildRuntimeTrustStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (runtimeCerts != null) {
            return;
        }
        CertificateStore store = SharedTrustStoreProvider.loadSystemCertificates();
        SharedTrustStoreProvider.addCertificatesFromStore(store, userTrustStoreLocation, userTrustStorePassword);
        runtimeCerts = store;
    }

    public static CertificateStore loadSystemCertificates() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        CertificateStore store = new CertificateStore();
        String javaHome = System.getProperty("java.home");
        String file = System.getProperty("javax.net.ssl.trustStore");
        String password = System.getProperty("javax.net.ssl.trustStorePassword");
        SharedTrustStoreProvider.addCertificatesFromStore(store, file, password);
        file = (String.valueOf(javaHome) + "/lib/security/cacerts").replace('/', File.separatorChar);
        password = null;
        SharedTrustStoreProvider.addCertificatesFromStore(store, file, password);
        file = (String.valueOf(javaHome) + "/lib/security/jssecacerts").replace('/', File.separatorChar);
        password = null;
        SharedTrustStoreProvider.addCertificatesFromStore(store, file, password);
        return store;
    }

    public static void addCertificatesFromStore(CertificateStore store, String file, String password) {
        if (file == null || file.length() < 1) {
            return;
        }
        File f = new File(file);
        if (f.canRead()) {
            try {
                store.loadCertificates(f, password);
            }
            catch (Exception exception) {}
        }
    }

    public SharedTrustStoreProvider() {
        try {
            if (sessionCerts == null) {
                SharedTrustStoreProvider.buildSessionTrustStore();
            }
            if (runtimeCerts == null) {
                SharedTrustStoreProvider.buildRuntimeTrustStore();
            }
        }
        catch (KeyStoreException keyStoreException) {
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (CertificateException certificateException) {
        }
        catch (IOException iOException) {}
    }

    @Override
    public CertificateStore getRuntimeTrustStore() {
        return runtimeCerts;
    }

    @Override
    public CertificateStore getSessionTrustStore() {
        return sessionCerts;
    }

    @Override
    public void installCertificate(Certificate cert) throws NoSuchAlgorithmException, CertificateException, KeyStoreException, IOException {
        File f = new File(userTrustStoreLocation);
        KeyStore ks = CertificateStore.load(f, userTrustStorePassword);
        ks.setCertificateEntry(CertificateStore.computeAlias(cert), cert);
        CertificateStore.store(ks, f, userTrustStorePassword);
    }
}

