/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropStreamSegment;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.Messages;
import com.ibm.rational.wvcm.interop.SendoverData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.Baseline;
import javax.wvcm.Component;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableFolder;
import javax.wvcm.ControllableResource;
import javax.wvcm.DetailedFeedback;
import javax.wvcm.Feedback;
import javax.wvcm.FolderVersion;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.PropertyRequestItem;
import javax.wvcm.Provider;
import javax.wvcm.ProviderFactory;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Stream;
import javax.wvcm.SymbolicLinkVersion;
import javax.wvcm.Task;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.VersionSet;
import javax.wvcm.Workspace;
import javax.wvcm.WorkspaceProvider;
import javax.wvcm.WvcmException;

public class InteropStream {
    private InteropStreamSegment _thisSegment;
    private InteropStreamSegment _thatSegment;
    private long _minorVersion;
    private long _lastAttemptedSyncDate;
    private long _lastSyncDate;
    private long _stateId;
    private InteropCore.InteropStreamOperation _operation;
    protected InteropCore.NewRoot[] _newSyncRoots;
    private static final VersionSet.CompareFlag[] CF_ACT_NEW = new VersionSet.CompareFlag[]{VersionSet.CompareFlag.ACTIVITIES, VersionSet.CompareFlag.NEW_ONLY};
    private static final ControllableResource.CheckinFlag[] CF_IDENTICAL = new ControllableResource.CheckinFlag[]{ControllableResource.CheckinFlag.CHECKIN_IDENTICAL};
    private static int CURRENT_MAJOR_VERSION = 10;
    private static int CURRENT_MINOR_VERSION = 10;
    private String _upgradeMessage;
    private static final String TERMINATOR1 = "\n\n\n.";
    private static final String TERMINATOR1_PAT = "\n\n\n\\.";
    public static final String TERMINATOR2 = "\n\n.";
    public static final String TERMINATOR2_PAT = "\n\n\\.";
    public static final String TERMINATOR3 = "\n.";
    public static final String TERMINATOR3_PAT = "\n\\.";
    private static final String TERMINATOR4 = "\n\n\n+";
    private static final String TERMINATOR4_PAT = "\n\n\n\\+";
    private static final String TERMINATOR5 = "\n\n+";
    private static final String TERMINATOR5_PAT = "\n\n\\+";
    private static final Workspace.MergeFlag[] MF_NO_CHECKOUTS = new Workspace.MergeFlag[]{Workspace.MergeFlag.NO_CHECKOUT};
    private static final Workspace.MergeFlag[] MF_NO_CHECKOUTS_UPDATE = new Workspace.MergeFlag[]{Workspace.MergeFlag.NO_CHECKOUT, Workspace.MergeFlag.UPDATE_STREAM};

    private InteropStream(InteropStreamSegment thisSegment, InteropStreamSegment thatSegment, long minorVersion, long lastAttemptedSyncDate, long lastSyncDate, long stateId, InteropCore.InteropStreamOperation operation, InteropCore.NewRoot[] roots) {
        this._thisSegment = thisSegment;
        this._thatSegment = thatSegment;
        this._minorVersion = minorVersion;
        this._lastAttemptedSyncDate = lastAttemptedSyncDate;
        this._lastSyncDate = lastSyncDate;
        this._stateId = stateId;
        this._operation = operation;
        this._newSyncRoots = roots;
    }

    public InteropStream(InteropStreamSegment thisSegment, InteropStreamSegment thatSegment) {
        this(thisSegment, thatSegment, 0L, 0L, 0L, 0L, InteropCore.InteropStreamOperation.INITIALIZE, new InteropCore.NewRoot[0]);
    }

    private String createThatWorkspaceName(String thatSyncStreamName, Feedback f) {
        String wsName = this.thatSegment().get_initArgs().get("com.ibm.team.interop.OTHER_WORKSPACE_NAME");
        if (wsName == null || wsName.length() == 0) {
            wsName = f.format(Messages.InteropStream_OTHER_WORKSPACE_NAME, new Object[]{thatSyncStreamName});
        }
        return wsName;
    }

    private void reserveThatStream(Feedback f) throws WvcmException {
        Stream thatSyncStream = this.thatSyncStream();
        String thisStreamName = (String)InteropUtilities.doReadProperty((Resource)this.thisSyncStream(), Resource.DISPLAY_NAME, f.nest(10));
        thatSyncStream.initProperty(InteropCore.PN_RESERVED_FOR_INTEROP, (Object)thisStreamName);
        try {
            thatSyncStream.doWriteProperties(f.nest(100));
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.CANNOT_OVERWRITE)) {
                thatSyncStream = InteropUtilities.createNewProxy(thatSyncStream);
                String reservedBy = InteropUtilities.doReadProperty((Resource)thatSyncStream, InteropCore.PN_RESERVED_FOR_INTEROP, f.nest());
                throw new WvcmException(f.format(Messages.InteropStream_ERROR_OTHER_STREAM_RESERVED, new Object[]{reservedBy}), (Resource)thatSyncStream, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
            }
            throw e;
        }
    }

    private void reserveInteropStream(Feedback f) throws WvcmException {
        Stream stream = this.thisSyncStream();
        InteropStream currentIS = this.refresh(f.nest(50));
        if (this._stateId != currentIS._stateId) {
            throw new WvcmException(InteropCore.msg(f, InteropCore.Msg.ERROR_STALE_DATA, new Object[0]), WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN);
        }
        stream.initProperty(InteropCore.PN_INTEROP_STREAM_LOCKED, (Object)InteropUtilities.TRUE_STRING);
        try {
            stream.doWriteProperties(f.nest(100));
        }
        catch (WvcmException e) {
            if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.CANNOT_OVERWRITE)) {
                throw new WvcmException(InteropCore.msg(f, InteropCore.Msg.ERROR_STREAM_RESERVED, stream), WvcmException.ReasonCode.CONFLICT, (Throwable)e);
            }
            throw e;
        }
    }

    private void updateISMetadata(Feedback f) throws WvcmException {
        Stream thisSyncStream = this.thisSyncStream();
        ++this._stateId;
        thisSyncStream.setProperty(InteropCore.PN_INTEROP_STREAM, (Object)this.unparse());
        thisSyncStream.doWriteProperties(f.nest(100));
        if (this._upgradeMessage != null) {
            f.notifyWarning(this._upgradeMessage);
            this._upgradeMessage = null;
        }
    }

    private void unreserveInteropStream(Feedback f) throws WvcmException {
        Stream thisSyncStream = this.thisSyncStream();
        try {
            InteropUtilities.forceAbortWvcmException((Provider)thisSyncStream.workspaceProvider(), 2, f);
            thisSyncStream.removeProperty(InteropCore.PN_INTEROP_STREAM_LOCKED);
            thisSyncStream.doWriteProperties(f.nest(100));
        }
        catch (Exception exception) {
            f.notifyWarning(Messages.InteropStream_ERROR_COULD_NOT_UNRESERVE);
        }
    }

    private void unreserveThatStream(Feedback f) throws WvcmException {
        Stream thatSyncStream = this.thatSyncStream();
        try {
            InteropUtilities.forceAbortWvcmException((Provider)thatSyncStream.workspaceProvider(), 3, f);
            thatSyncStream.removeProperty(InteropCore.PN_RESERVED_FOR_INTEROP);
            thatSyncStream.doWriteProperties(f.nest(100));
        }
        catch (Exception exception) {
            f.notifyWarning(Messages.InteropStream_ERROR_COULD_NOT_UNRESERVE_OTHER);
        }
    }

    private List<ControllableResource> getPrunedSyncRoots(boolean isThis, Workspace ws, ResourceList<Component> optionalNamedComponents, Feedback f) throws WvcmException {
        Feedback fResult = f.nest(f.getPropertyRequestForResult());
        InteropStreamSegment segment = isThis ? this.thisSegment() : this.thatSegment();
        ArrayList<ControllableResource> roots = new ArrayList<ControllableResource>();
        ArrayList<VersionHistory> prunedRoots = new ArrayList<VersionHistory>();
        WorkspaceProvider p = ws.workspaceProvider();
        String[] paths = segment.get_syncRootPaths();
        ArrayList<ControllableResource> rootsWithoutBaselines = new ArrayList<ControllableResource>();
        int n = paths.length;
        int i = 0;
        String[] stringArray = paths;
        int n2 = paths.length;
        int n3 = 0;
        while (n3 < n2) {
            String path = stringArray[n3];
            VersionHistory vh = p.versionHistory(p.location(path));
            ControllableResource root = InteropUtilities.doFindCRInWorkspace(ws, vh, fResult);
            if (root == null) {
                try {
                    InteropUtilities.doReadProperty((Resource)ws, Workspace.CHILD_LIST, f.nest());
                }
                catch (WvcmException e) {
                    throw new WvcmException(Messages.InteropStream_ERROR_WS_NOT_VISIBLE, (Resource)ws, WvcmException.ReasonCode.CONFLICT, (Throwable)e);
                }
                prunedRoots.add(vh);
            } else if (optionalNamedComponents != null) {
                Configuration config = (Configuration)InteropUtilities.tryGetProperty((Resource)root, ControllableResource.CONFIGURATION);
                if (config == null) {
                    root = (ControllableResource)root.doReadProperties((Feedback)InteropCore.PR_CONFIG_VH);
                    config = root.getConfiguration();
                }
                if (config == null) {
                    roots.add(root);
                } else {
                    Component comp = (Component)config.getVersionHistory();
                    if (optionalNamedComponents.contains((Object)comp)) {
                        roots.add(root);
                    } else {
                        prunedRoots.add(vh);
                        rootsWithoutBaselines.add(root);
                    }
                }
            } else {
                roots.add(root);
            }
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
            ++n3;
        }
        this.internalDeleteSyncRoots(isThis, prunedRoots, f.nest());
        if (!rootsWithoutBaselines.isEmpty()) {
            Feedback nowork = f.nest();
            StringBuffer friendlyPathnames = new StringBuffer();
            for (ControllableResource root : rootsWithoutBaselines) {
                String pathname = InteropUtilities.getFriendlyPathname((Resource)root, 0, nowork);
                friendlyPathnames.append(pathname).append('\n');
            }
            throw new WvcmException(InteropCore.msg(f.nest(), InteropCore.Msg.ERROR_ROOTS_HAVE_NO_BASELINES, rootsWithoutBaselines.size(), friendlyPathnames.toString()), WvcmException.ReasonCode.FORBIDDEN);
        }
        return roots;
    }

    private void finishSendoverThisStream(Workspace thatSyncWs, ResourceList<Task> srcTasks, String taskName, Feedback f) throws WvcmException {
        InteropCore.sendoverTasks(thatSyncWs, taskName, "", srcTasks, f.nest(10));
        InteropCore.closeCurrentActivity(thatSyncWs, taskName, f.nest(50));
        this.setThatSentover(f.nest(100));
    }

    private void sendoverThisStream(ResourceList<Component> thatNamedComponents, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace mergedWs = this.thisInternalWs();
        Stream mergedStream = this.thisInternalStream();
        Workspace cloneWs = this.thisCloneWs();
        Stream cloneStream = this.thisCloneStream();
        Workspace thatSyncWs = this.thatSyncWs();
        List<ControllableResource> tgtRoots = this.thatSyncRootsInComponentList(this.thatSyncWs(), thatNamedComponents, f.nest(InteropCore.PR_PATH_CONFIG_COMP_DN, 55));
        WorkspaceProvider srcP = mergedStream.workspaceProvider();
        ResourceList srcChangedVersions = srcP.resourceList((Resource[])new Version[0]);
        ResourceList srcTasks = srcP.resourceList((Resource[])new Task[0]);
        f.notifyActive(Messages.InteropStream_MSG_CHANGES_IN_STREAM);
        InteropCore.computeNewVersionList((ResourceList<Version>)srcChangedVersions, (ResourceList<Task>)srcTasks, (ResourceList.ResponseIterator<VersionSet.CompareReport>)cloneStream.doCompareReport((VersionSet)mergedStream, CF_ACT_NEW, f.nest(InteropCore.PR_CHANGED_VERSIONS_ACT, 50)));
        if (srcChangedVersions.size() > 0) {
            f.notifyActive(Messages.InteropStream_MSG_COMPUTING_OTHER_ROOTS);
            HashSet<String> tgtRootPaths = new HashSet<String>();
            for (ControllableResource tgtRoot : tgtRoots) {
                if (tgtRoot == null) continue;
                tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
            }
            this.setTaskIdsProperty(f.nest(60), thatSyncWs, (List<Task>)srcTasks);
            try {
                this.sendoverChanges(thatSyncWs, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, mergedWs, false, null, f.nest(90));
            }
            catch (WvcmException e) {
                this.cleanupWorkspace(thatSyncWs, f.nest(95));
                String taskName = f.format(Messages.InteropStream_NAME_FAILED_SYNCHRONIZE_TASK, new Object[]{InteropUtilities.currentDate()});
                this.finishSendoverThisStream(thatSyncWs, (ResourceList<Task>)srcTasks, taskName, f.nest(100));
                throw e;
            }
            String taskName = f.format(Messages.InteropStream_NAME_SYNCHRONIZE_TASK, new Object[]{InteropUtilities.currentDate()});
            this.finishSendoverThisStream(thatSyncWs, (ResourceList<Task>)srcTasks, taskName, f.nest(100));
        }
        cloneWs.doUpdate(InteropUtilities.makeList(mergedStream), nowork);
        cloneStream.doUpdate(InteropUtilities.makeList(cloneWs), nowork);
    }

    private void setTaskIdsProperty(Feedback f, Workspace tgtSyncWs, List<Task> srcTasks) throws WvcmException {
        ArrayList<String> taskIds = new ArrayList<String>(srcTasks.size());
        for (Task srcTask : srcTasks) {
            String taskId = InteropUtilities.getProperty((Resource)srcTask, InteropUtilities.PN_TASK_ID);
            if (taskId == null) continue;
            taskIds.add(taskId);
        }
        if (taskIds.size() > 0) {
            String evValue = ((Object)taskIds).toString();
            tgtSyncWs.setProperty(InteropCore.PN_TASK_IDS, (Object)evValue.substring(1, evValue.length() - 1));
            tgtSyncWs.doWriteProperties(f.nest(100));
        }
    }

    private ResourceList<Baseline> getSentoverBaselines() throws WvcmException {
        WorkspaceProvider thatP = this.thatProvider();
        ResourceList baselines = thatP.resourceList((Resource[])new Baseline[0]);
        String[] stringArray = this.thatSegment().get_sentoverBaselinePaths();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String srcBlName = stringArray[n2];
            baselines.add((Object)thatP.baseline(thatP.location(srcBlName)));
            ++n2;
        }
        return baselines;
    }

    private ResourceList<Baseline> readSentoverBaselines(Feedback f) throws WvcmException {
        ResourceList result = this.thatProvider().resourceList((Resource[])new Baseline[0]);
        ResourceList.ResponseIterator baselines = this.getSentoverBaselines().doReadProperties(f);
        while (baselines.hasNext()) {
            result.add((Object)((Baseline)baselines.next()));
        }
        return result;
    }

    private ResourceList<Component> readSentoverComponents(Feedback f) throws WvcmException {
        ResourceList result = this.thatProvider().resourceList((Resource[])new Component[0]);
        ResourceList<Baseline> oldBaselines = this.readSentoverBaselines(f.nest(InteropCore.PR_VH, 100));
        for (Baseline b : oldBaselines) {
            result.add((Object)((Component)b.getVersionHistory()));
        }
        return result;
    }

    private Map<Component, Baseline> readSentoverComponentsAndBaselines(Feedback f) throws WvcmException {
        LinkedHashMap<Component, Baseline> results = new LinkedHashMap<Component, Baseline>();
        ResourceList<Baseline> oldBaselines = this.readSentoverBaselines(f.nest(InteropCore.PR_VH, 100));
        for (Baseline b : oldBaselines) {
            results.put((Component)b.getVersionHistory(), b);
        }
        return results;
    }

    private ResourceList<Component> readSentoverComponentsWithNames(Feedback f) throws WvcmException {
        ResourceList result = this.thatProvider().resourceList((Resource[])new Component[0]);
        ResourceList<Baseline> oldBaselines = this.readSentoverBaselines(f.nest(InteropCore.PR_VH_NAME, 100));
        for (Baseline b : oldBaselines) {
            result.add((Object)((Component)b.getVersionHistory()));
        }
        return result;
    }

    private Map<Component, Baseline> getNewBaselineMap(ResourceList<Baseline> newBaselines, ResourceList<Component> components, Workspace workspace, Feedback f) throws WvcmException {
        HashMap<Component, Baseline> newBaselineMap = new HashMap<Component, Baseline>();
        if (newBaselines != null) {
            ResourceList.ResponseIterator baselines = newBaselines.doReadProperties(f.nest(InteropCore.PR_NAME_VH, 100));
            while (baselines.hasNext()) {
                Baseline newBaseline = (Baseline)baselines.next();
                newBaselineMap.put((Component)newBaseline.getVersionHistory(), newBaseline);
            }
        } else {
            int n = components.size();
            int i = 0;
            while (i < n) {
                Component srcComp = (Component)components.get(i);
                Configuration srcConf = InteropUtilities.doFindConfigurationInWorkspace(workspace, srcComp, f.nest(InteropUtilities.PR_CI_DN, 100 * (i + 1) / n));
                newBaselineMap.put((Component)components.get(i), (Baseline)srcConf.getCheckedIn());
                ++i;
            }
        }
        return newBaselineMap;
    }

    private void sendoverThatBaselines(ResourceList<Baseline> thatBaselines, boolean isImport, Feedback f) throws WvcmException {
        ResourceList<Component> srcComponents = this.readSentoverComponentsWithNames(f.nest(2));
        this.sendoverThatBaselines(srcComponents, thatBaselines, isImport, f);
    }

    protected void sendoverThatBaselines(ResourceList<Component> srcComponents, ResourceList<Baseline> thatBaselines, boolean isImport, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace srcWs = this.thatSyncWs();
        Stream srcStream = this.thatSyncStream();
        Workspace tgtWs = this.thisCloneWs();
        Stream tgtStream = this.thisCloneStream();
        List<ControllableResource> tgtRoots = this.thisSyncRoots(this.thisCloneWs(), f.nest(InteropCore.PR_PATH, 1));
        HashSet<String> tgtRootPaths = new HashSet<String>();
        for (ControllableResource tgtRoot : tgtRoots) {
            if (tgtRoot == null) continue;
            tgtRootPaths.add(tgtRoot.getPathnameLocation().string());
        }
        WorkspaceProvider srcP = srcStream.workspaceProvider();
        WorkspaceProvider tgtP = tgtStream.workspaceProvider();
        boolean srcHasChanges = false;
        ResourceList<Baseline> srcOldBaselines = this.getSentoverBaselines();
        Map<Component, Baseline> srcNewBaselinesMap = this.getNewBaselineMap(thatBaselines, srcComponents, srcWs, f.nest(4));
        int n = srcComponents.size();
        String[] newSentoverBaselinePaths = Arrays.copyOf(this.thatSegment().get_sentoverBaselinePaths(), n);
        LinkedHashMap<Component, String> tgtCompAndBaselineName = new LinkedHashMap<Component, String>(srcComponents.size());
        int i = 0;
        while (i < n) {
            Component srcComp = (Component)srcComponents.get(i);
            Baseline srcOldBaseline = (Baseline)srcOldBaselines.get(i);
            Baseline srcNewBaseline = srcNewBaselinesMap.get(srcComp);
            if (srcNewBaseline != null) {
                srcP.clearCache(f);
                tgtP.clearCache(f);
                ResourceList srcChangedVersions = srcP.resourceList((Resource[])new Version[0]);
                ResourceList srcTasks = srcP.resourceList((Resource[])new Task[0]);
                newSentoverBaselinePaths[i] = srcNewBaseline.getResourceIdentifier();
                String compName = srcComp.getDisplayName();
                f.notifyActive(f.format(Messages.InteropStream_MSG_CHANGES_IN_COMPONENT, new Object[]{compName}));
                InteropCore.computeNewVersionList((ResourceList<Version>)srcChangedVersions, (ResourceList<Task>)srcTasks, (ResourceList.ResponseIterator<VersionSet.CompareReport>)srcOldBaseline.doCompareReport((VersionSet)srcWs, CF_ACT_NEW, f.nest(InteropCore.PR_CHANGED_VERSIONS_ACT, InteropUtilities.LP(5, i, n, 4, 88))));
                if (srcChangedVersions.size() > 0) {
                    srcHasChanges = true;
                    try {
                        this.sendoverChanges(tgtWs, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, srcWs, false, null, f.nest(InteropUtilities.LP(100, i, n, 4, 88)));
                    }
                    catch (WvcmException e) {
                        this.cleanupWorkspace(tgtWs, f);
                        throw e;
                    }
                    String taskName = f.format(Messages.InteropStream_MSG_BRING_OVER_TASKNAME, new Object[]{srcNewBaseline.getDisplayName()});
                    HashSet<String> commentSet = new HashSet<String>();
                    for (Version version : srcChangedVersions) {
                        InteropUtilities.addComment((Resource)version, commentSet);
                    }
                    String comments = InteropUtilities.concatenateComments(commentSet, f);
                    InteropCore.sendoverTasks(tgtWs, taskName, comments, (ResourceList<Task>)srcTasks, f.nest(InteropUtilities.LP(100, i, n, 4, 88)));
                    InteropCore.closeCurrentActivity(tgtWs, taskName, nowork);
                }
                if (isImport) {
                    Component tgtComp = InteropCore.lookupClone(srcComp, tgtWs.workspaceProvider());
                    tgtCompAndBaselineName.put(tgtComp, srcNewBaseline.getDisplayName());
                }
            }
            ++i;
        }
        if (srcHasChanges) {
            InteropUtilities.updateStreamWithWorkspace(tgtStream, tgtWs, f.nest(89));
            if (!tgtCompAndBaselineName.isEmpty()) {
                Workspace thisSyncWs = this.thisSyncWs().doUpdate(InteropUtilities.makeList(tgtStream), f.nest(95));
                for (Map.Entry entry : tgtCompAndBaselineName.entrySet()) {
                    Component tgtComp = (Component)((Component)entry.getKey()).doReadProperties((Feedback)InteropUtilities.PR_DN);
                    Configuration tgtConf = InteropUtilities.doFindConfigurationInWorkspace(thisSyncWs, tgtComp, nowork);
                    tgtConf.doCheckout(null, nowork);
                    tgtConf.setDisplayName((String)entry.getValue());
                    tgtConf = (Configuration)tgtConf.doCheckin(CF_IDENTICAL, (Feedback)InteropUtilities.PR_CI_DN);
                    f.notifyCompleted(f.format(Messages.InteropStream_MSG_BASELINED_COMPONENT_WITH_BL_DN, new Object[]{tgtConf.getCheckedIn().getDisplayName(), tgtComp.getDisplayName()}));
                }
            }
            this.thatSegment().set_sentoverBaselinePaths(newSentoverBaselinePaths);
        }
        f.notifyPercentComplete(100);
    }

    private int resourcesPerCloneLinkUpdate() throws WvcmException {
        WorkspaceProvider thisProvider = this.thisProvider();
        Map initArgs = thisProvider.initArgs();
        if (initArgs.containsKey("com.ibm.team.interop.RESOURCES_PER_CLONE_LINK_UPDATE")) {
            String strResPerUpdate = (String)initArgs.get("com.ibm.team.interop.RESOURCES_PER_CLONE_LINK_UPDATE");
            return Integer.valueOf(strResPerUpdate);
        }
        return 0;
    }

    private void checkForExceptions(ResourceList.ResponseIterator<?> ri) throws WvcmException {
        while (ri.hasNext()) {
            ri.next();
        }
    }

    private void createFiles(SendoverData sd, boolean isTree, Feedback nowork) throws WvcmException {
        int size = sd.getTgtCr2srcVer().size();
        if (size == 0) {
            return;
        }
        nowork.notifyActive(nowork.format(Messages.InteropStream_MSG_CREATING_FILES, new Object[]{size}));
        Provider tgtP = sd.tgtWorkspace.provider();
        Provider srcP = sd.srcWorkspace.provider();
        ResourceList tgtCRs = tgtP.resourceList((Resource[])new ControllableResource[0]);
        for (ControllableResource tgtCR : sd.getTgtCr2srcVer().keySet()) {
            Version srcVersion = sd.getTgtCr2srcVer().get(tgtCR);
            InteropCore.createFile(sd, tgtCR, false, srcVersion, isTree, nowork);
            tgtCRs.add((Object)tgtCR);
        }
        nowork.notifyActive(nowork.format(Messages.InteropStream_MSG_CHECKING_IN_FILES, new Object[]{size}));
        sd.tgtWorkspace.doVersionControl(tgtCRs, nowork);
        nowork.notifyActive(nowork.format(Messages.InteropStream_CONNECTING_CLONES, new Object[]{tgtCRs.size()}));
        boolean tgtHasCloneInfo = InteropCore.hasCloneInfo(tgtP.initArgs());
        ResourceList vHs = tgtHasCloneInfo ? tgtP.resourceList((Resource[])new VersionHistory[0]) : srcP.resourceList((Resource[])new VersionHistory[0]);
        Iterator<List<?>> tgtCRChunks = InteropUtilities.chunkify(tgtCRs, this.resourcesPerCloneLinkUpdate()).iterator();
        ResourceList.ResponseIterator<ControllableResource> tgtCRIter = InteropUtilities.doReadProperties(tgtCRChunks.next(), tgtP, nowork.nest(InteropCore.PR_VH_CLONE));
        for (Version srcVer : sd.getTgtCr2srcVer().values()) {
            ControllableResource tgtCR = (ControllableResource)tgtCRIter.next();
            VersionHistory tgtVH = tgtCR.getVersionHistory();
            VersionHistory srcVH = srcVer.getVersionHistory();
            if (tgtHasCloneInfo) {
                InteropCore.initClone((Resource)tgtVH, (Resource)srcVH, nowork);
                vHs.add((Object)tgtVH);
            } else {
                InteropCore.initClone((Resource)srcVH, (Resource)tgtVH, nowork);
                vHs.add((Object)srcVH);
            }
            if (tgtCRIter.hasNext()) continue;
            ResourceList.ResponseIterator ri = vHs.doWriteProperties(nowork);
            this.checkForExceptions(ri);
            if (!tgtCRChunks.hasNext()) continue;
            tgtCRIter = InteropUtilities.doReadProperties(tgtCRChunks.next(), tgtP, nowork.nest(InteropCore.PR_VH_CLONE));
            vHs.clear();
        }
    }

    private int getMaxNumBatchEntries(Feedback nowork) throws WvcmException {
        return InteropCore.getInt((Provider)this.thisProvider(), "com.ibm.team.connector.scm.MAX_NUM_BATCH_ENTRIES", nowork);
    }

    public void sendoverChanges(Workspace tgtWorkspace, Set<String> tgtRootPaths, ResourceList<Version> srcChangedVersions, Workspace srcWorkspace, boolean isTree, Map<VersionHistory, Version> srcVh2srcVer, Feedback f) throws WvcmException {
        f.notifyActive(f.format(Messages.InteropStream_MSG_TRANSFER_COUNT, new Object[]{String.valueOf(srcChangedVersions.size())}));
        InteropCore.incrementSyncStat(InteropCore.SyncStatType.CHANGES, (Resource)tgtWorkspace, srcChangedVersions.size());
        SendoverData sd = new SendoverData(tgtWorkspace, tgtRootPaths, srcChangedVersions, srcWorkspace, srcVh2srcVer, f.nest(95));
        Feedback nowork = f.nest();
        this.sendoverFolders(sd, isTree, nowork);
        sd.srcVh2srcVer = null;
        this.sendoverContent(sd, isTree, nowork);
        this.restoreFilesLeaveUncommitted(sd, isTree, nowork);
        this.createFiles(sd, isTree, nowork);
        InteropCore.removeDeletedChildren(sd, nowork);
        f.notifyActive(Messages.InteropStream_MSG_CHECKING_IN_CHANGES);
        tgtWorkspace.doCheckinAll(null, null, f.nest(100));
    }

    private void restoreFilesLeaveUncommitted(SendoverData sd, boolean isTree, Feedback nowork) throws WvcmException {
        Map<ControllableResource, InteropCore.FilesToRestoreInfo> filesToRestore = sd.filesToRestoreInfo;
        if (!filesToRestore.isEmpty()) {
            Workspace tgtWs = sd.tgtWorkspace;
            WorkspaceProvider tgtP = tgtWs.workspaceProvider();
            ResourceList tgtCRs = tgtP.resourceList((Resource[])new ControllableResource[0]);
            Set<ControllableResource> keys = filesToRestore.keySet();
            for (ControllableResource controllableResource : keys) {
                Version tgtVersion = filesToRestore.get((Object)controllableResource).tgtVersionToRestore;
                ControllableResource tgtCrCopy = tgtP.controllableResource(controllableResource.location());
                tgtCrCopy.setProperty(ControllableResource.CHECKED_IN, (Object)tgtVersion);
                tgtCRs.add((Object)tgtCrCopy);
            }
            for (List list : InteropUtilities.chunkify(tgtCRs, this.getMaxNumBatchEntries(nowork))) {
                ResourceList<?> tgtCRChunk = InteropUtilities.makeResourceList((Provider)tgtP, list);
                nowork.notifyActive(nowork.format(Messages.InteropStream_MSG_PREPARING_TO_RESTORE, new Object[]{tgtCRChunk.size()}));
                try {
                    tgtWs = tgtWs.doCreateVersionControlledResources(tgtCRChunk, nowork);
                }
                catch (WvcmException wvcmException) {
                    this.doCreateVCR(tgtCRChunk, nowork);
                }
            }
            nowork.notifyCompleted(Messages.InteropStream_MSG_PREP_COMPLETED);
            for (ControllableResource controllableResource : keys) {
                InteropCore.FilesToRestoreInfo filesToRestoreInfo = filesToRestore.get(controllableResource);
                Version srcVersion = filesToRestoreInfo.srcVersion;
                InteropCore.copyVersionToCR(controllableResource, srcVersion, false, isTree, nowork);
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_RESTORED_FILE, new Object[]{filesToRestoreInfo.bindingName}));
                sd.reportProgress();
            }
            InteropCore.incrementSyncStat(InteropCore.SyncStatType.FILES_CREATED, (Provider)tgtP, filesToRestore.size());
        }
    }

    private void doCreateVCR(ResourceList<ControllableResource> tgtCRChunk, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        for (ControllableResource cr : tgtCRChunk) {
            try {
                cr.doCreateVersionControlledResource(cr.getCheckedIn(), nowork);
            }
            catch (WvcmException e) {
                if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.ONE_CONTROLLED_RESOURCE_PER_HISTORY_PER_WORKSPACE)) {
                    nowork.notifyWarning(nowork.format(Messages.InteropCore_WARNING_HARD_LINK_IGNORED, new Object[]{cr.location()}));
                    continue;
                }
                if (e.getReasonCode().equals((Object)WvcmException.ReasonCode.RESOURCE_ALREADY_EXISTS_AT_LOCATION)) continue;
                throw e;
            }
        }
    }

    private void sendoverFolders(SendoverData sd, boolean isTree, Feedback nowork) throws WvcmException {
        boolean srcVersionKnowsParent = InteropCore.versionKnowsParent(sd.srcWorkspace.provider().initArgs());
        InteropUtilities.forceAbortWvcmException((Provider)sd.tgtWorkspace.workspaceProvider(), 6, nowork);
        HashSet<VersionHistory> tgtVHs = new HashSet<VersionHistory>(sd.tgtVh2srcVer.keySet());
        for (VersionHistory tgtVH : tgtVHs) {
            Version srcVersion = sd.tgtVh2srcVer.get(tgtVH);
            if (srcVersion == null || !(srcVersion instanceof FolderVersion) || sd.tgtProcessed.contains(tgtVH.location().string())) continue;
            VersionHistory srcFolderVH = srcVersion.getVersionHistory();
            FolderVersion srcFolderVer = srcVersionKnowsParent ? (FolderVersion)InteropUtilities.doFindVersionInWorkspace(sd.srcWorkspace, srcFolderVH, nowork.nest(InteropCore.PR_VERSION_CHILDMAP)) : (FolderVersion)srcVersion.doReadProperties((Feedback)InteropCore.PR_VERSION_CHILDMAP);
            if (srcFolderVer == null) {
                sd.tgtProcessed.add(tgtVH.location().string());
                continue;
            }
            ControllableFolder tgtCF = (ControllableFolder)InteropUtilities.doFindCRInWorkspace(sd.tgtWorkspace, tgtVH, nowork.nest(InteropCore.PR_PATH_CR_CHILD_CLONE));
            if (tgtCF == null || !isTree && !InteropUtilities.isPathAChildOf((ControllableResource)tgtCF, sd.tgtRootPaths)) continue;
            InteropCore.sendoverFolder(sd, isTree, tgtCF, tgtVH, srcFolderVer, srcFolderVH, nowork);
        }
        int total = sd.clonesToUpdateSize();
        if (total > 0) {
            nowork.notifyActive(nowork.format(Messages.InteropStream_CONNECTING_CLONES, new Object[]{total}));
            List<Resource> clonesToUpdate = sd.getClonesToUpdate();
            Provider provider = clonesToUpdate.get(0).provider();
            for (List<?> clonesChunk1 : InteropUtilities.chunkify(clonesToUpdate, this.resourcesPerCloneLinkUpdate())) {
                ResourceList<?> clonesChunk = InteropUtilities.makeResourceList(provider, clonesChunk1);
                ResourceList.ResponseIterator ri = clonesChunk.doWriteProperties(nowork);
                this.checkForExceptions(ri);
            }
            sd.clearClonesToUpdate();
        }
    }

    private void sendoverContent(SendoverData sd, boolean isTree, Feedback nowork) throws WvcmException {
        ArrayList<VersionHistory> tgtVhs = new ArrayList<VersionHistory>(sd.tgtVh2srcVer.keySet());
        Iterator<List<?>> iterator = InteropUtilities.chunkify(tgtVhs, this.getMaxNumBatchEntries(nowork)).iterator();
        while (iterator.hasNext()) {
            List<VersionHistory> tgtVhChunk1;
            List<VersionHistory> tgtVhChunk = tgtVhChunk1 = iterator.next();
            Map<VersionHistory, ControllableResource> tgtVhs2Crs = InteropUtilities.doFindCRsInWorkspace(sd.tgtWorkspace, tgtVhChunk, nowork.nest(InteropCore.PR_PATH));
            for (VersionHistory tgtVH : tgtVhChunk) {
                Version srcVersion = sd.tgtVh2srcVer.get(tgtVH);
                ControllableResource tgtCR = tgtVhs2Crs.get(tgtVH);
                if (tgtCR == null || sd.tgtProcessed.contains(tgtVH.location().string()) || srcVersion instanceof FolderVersion || srcVersion instanceof SymbolicLinkVersion || !isTree && !InteropUtilities.isPathAChildOf(tgtCR, sd.tgtRootPaths)) continue;
                sd.tgtProcessed.add(tgtVH.location().string());
                String name = InteropUtilities.getFriendlyPathname((Resource)tgtCR, 200, nowork);
                InteropCore.copyVersionToCR(tgtCR, srcVersion, false, isTree, nowork);
                nowork.notifyCompleted(nowork.format(Messages.InteropStream_MSG_UPDATED, new Object[]{name}));
                sd.reportProgress();
                InteropCore.incrementSyncStat(InteropCore.SyncStatType.FILES_UPDATED, (Resource)tgtCR, 1);
            }
        }
    }

    private ResourceList<Component> createThatBaselinesForRoots(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace thatSyncWs = this.thatSyncWs();
        Stream thatSyncStream = this.thatSyncStream();
        ResourceList<Component> namedComponents = this.readSentoverComponentsWithNames(f.nest());
        int n = namedComponents.size();
        int i = 0;
        for (Component comp : namedComponents) {
            Configuration conf = InteropUtilities.doFindConfigurationInWorkspace(thatSyncWs, comp, nowork);
            String compName = comp.getDisplayName();
            conf.doCheckout(null, nowork);
            conf.doCheckin(null, nowork);
            f.notifyCompleted(f.format(Messages.InteropStream_MSG_BASELINED_COMPONENT, new Object[]{compName}));
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
        }
        InteropUtilities.updateStreamWithWorkspace(thatSyncStream, thatSyncWs, nowork);
        return namedComponents;
    }

    private void setThatSentover(Feedback f) throws WvcmException {
        if (this.thatSegment().numSyncRoots() == 0) {
            return;
        }
        Feedback nowork = f.nest();
        ResourceList<Component> oldComponents = this.readSentoverComponents(nowork);
        int n = oldComponents.size();
        if (n > 0 && InteropUtilities.shouldForceException((Provider)this.thatProvider(), 13)) {
            n = 0;
        }
        if (n == 0) {
            throw new WvcmException("No baselines found", WvcmException.ReasonCode.CONFLICT);
        }
        String[] baselineNames = new String[n];
        Feedback f_PR_VH_NAME = f.nest(InteropCore.PR_VH_NAME);
        Feedback f_PR_CI = f.nest(InteropCore.PR_CI);
        int i = 0;
        for (VersionHistory comp : oldComponents) {
            Configuration conf = InteropUtilities.doFindConfigurationInWorkspace(this.thatSyncWs(), (Component)comp, f_PR_VH_NAME);
            String compName = conf.getVersionHistory().getDisplayName();
            conf.doCheckout(null, nowork);
            conf = (Configuration)conf.doCheckin(null, f_PR_CI);
            baselineNames[i] = conf.getCheckedIn().getResourceIdentifier();
            f.notifyCompleted(f.format(Messages.InteropStream_MSG_BASELINED_COMPONENT, new Object[]{compName}));
            f.notifyPercentComplete(100 * (i + 1) / n);
            ++i;
        }
        this.thatSegment().set_sentoverBaselinePaths(baselineNames);
    }

    private void sendoverTree(ControllableResource tgtCR, Stream tgtStream, Set<String> tgtRootPaths, ControllableResource srcCR, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider thatP = srcCR.workspaceProvider();
        Workspace tgtWs = tgtCR.getWorkspace();
        ResourceList srcChangedVersions = thatP.resourceList((Resource[])new Version[0]);
        String rootName = InteropUtilities.getFriendlyPathname((Resource)srcCR, 100, nowork);
        f.notifyActive(f.format(Messages.InteropStream_MSG_RETRIEVING_METADATA, new Object[]{rootName}));
        ControllableResource srcRootCR = (ControllableResource)srcCR.doReadProperties(f.nest(InteropCore.PR_CI_VH_CLONE, 1));
        srcChangedVersions.add((Object)srcRootCR.getCheckedIn());
        Map<VersionHistory, Version> srcVh2srcVer = InteropCore.create_srcVh2srcVer(srcRootCR, tgtCR, tgtRootPaths, f.nest(5));
        this.sendoverChanges(tgtWs, tgtRootPaths, (ResourceList<Version>)srcChangedVersions, srcCR.getWorkspace(), true, srcVh2srcVer, f.nest(100));
    }

    private Workspace newInteropStreamWs(String wsName, InteropStreamSegment segment, Workspace oldWorkspace, boolean updateFromOld, Stream stream, boolean isIsolated, Feedback f) throws WvcmException {
        Workspace ws = InteropCore.createInteropWorkspace(wsName, isIsolated, stream, f);
        if (isIsolated && updateFromOld) {
            Stream oldStream = (Stream)InteropUtilities.doReadProperty((Resource)oldWorkspace, Workspace.STREAM, f.nest());
            ws.doUpdate(InteropUtilities.makeList(oldStream), f.nest());
        }
        if (segment.get_initArgs().get("com.ibm.rational.wvcm.WORKSPACE_LOCATION") != null) {
            segment.put_initArgs("com.ibm.rational.wvcm.WORKSPACE_LOCATION", ws.location().string());
        }
        try {
            oldWorkspace.doUnbindAll(f.nest());
        }
        catch (Exception exception) {}
        return ws;
    }

    private static String getVersionField(String[] fields) {
        return fields[0];
    }

    private static String getStateIdField(String[] fields) {
        return fields[5];
    }

    private static InteropStream parse(String interopStreamValue, ProviderFactory.Callback callback, Feedback f) {
        int i;
        if (interopStreamValue == null) {
            return null;
        }
        String[] field = interopStreamValue.split(TERMINATOR1_PAT, -1);
        int major_version = Integer.parseInt(InteropStream.getVersionField(field));
        if (major_version > CURRENT_MAJOR_VERSION) {
            throw new RuntimeException(InteropCore.msg(f, InteropCore.Msg.ERROR_OLD_CLIENT, CURRENT_MAJOR_VERSION));
        }
        int minor_version = Integer.parseInt(field[8]);
        InteropStreamSegment thisSegment = new InteropStreamSegment(field[1], minor_version, callback);
        InteropStreamSegment thatSegment = new InteropStreamSegment(field[2], minor_version, callback);
        if (major_version < 10) {
            thisSegment.get_initArgs().put("com.ibm.team.interop.RESTARTABLE_IMPORTS", InteropUtilities.FALSE_STRING);
        }
        long lastAttemptedSyncDate = Long.parseLong(field[3]);
        long lastSyncDate = Long.parseLong(field[4]);
        long stateId = Long.parseLong(InteropStream.getStateIdField(field));
        InteropCore.InteropStreamOperation operation = InteropCore.InteropStreamOperation.valueOf(field[6]);
        String[] newRootListFields = field[7].split(TERMINATOR3_PAT);
        InteropCore.NewRoot[] roots = new InteropCore.NewRoot[newRootListFields.length];
        if (major_version < 10) {
            i = 0;
            while (i < newRootListFields.length) {
                roots[i] = new InteropCore.NewRoot(newRootListFields[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < newRootListFields.length) {
                String[] newRootFields = newRootListFields[i].split(TERMINATOR4_PAT);
                roots[i] = newRootFields.length == 1 ? new InteropCore.NewRoot(newRootFields[0]) : new InteropCore.NewRoot(newRootFields[0], newRootFields[1].split(TERMINATOR5_PAT), new InteropStreamSegment.SyncRoots(newRootFields[2].split(TERMINATOR5_PAT)), new InteropStreamSegment.SyncRoots(newRootFields[3].split(TERMINATOR5_PAT)));
                ++i;
            }
        }
        String upgradeMessage = null;
        if (minor_version < CURRENT_MINOR_VERSION) {
            upgradeMessage = f.format(Messages.InteropStream_WARNING_UPGRADING_METADATA_VERSION, new Object[]{String.valueOf(minor_version), String.valueOf(CURRENT_MINOR_VERSION)});
            minor_version = CURRENT_MINOR_VERSION;
        }
        InteropStream is = new InteropStream(thisSegment, thatSegment, minor_version, lastAttemptedSyncDate, lastSyncDate, stateId, operation, roots);
        is._upgradeMessage = upgradeMessage;
        return is;
    }

    private void unparsePaths(StringBuffer s, String[] paths, String terminator) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            s.append(path);
            s.append(terminator);
            ++n2;
        }
        if (paths.length == 0) {
            s.append(terminator);
        }
    }

    private void unparseNewSyncRoots(StringBuffer s) {
        InteropCore.NewRoot[] newRootArray = this._newSyncRoots;
        int n = this._newSyncRoots.length;
        int n2 = 0;
        while (n2 < n) {
            InteropCore.NewRoot newRoot = newRootArray[n2];
            s.append(newRoot.path);
            if (newRoot.pendingSubRootPaths != null && this.isRestartableImports()) {
                s.append(TERMINATOR4);
                this.unparsePaths(s, newRoot.pendingSubRootPaths, TERMINATOR5);
                s.append(TERMINATOR4);
                this.unparsePaths(s, newRoot.srcSubRootPaths.paths, TERMINATOR5);
                s.append(TERMINATOR4);
                this.unparsePaths(s, newRoot.tgtSubRootPaths.paths, TERMINATOR5);
            }
            s.append(TERMINATOR3);
            ++n2;
        }
        if (this._newSyncRoots.length == 0) {
            s.append(TERMINATOR3);
        }
    }

    private String unparse() {
        StringBuffer s = new StringBuffer();
        s.append(this.isRestartableImports() ? CURRENT_MAJOR_VERSION : 8);
        s.append(TERMINATOR1);
        s.append(this._thisSegment.toString());
        s.append(TERMINATOR1);
        s.append(this._thatSegment.toString());
        s.append(TERMINATOR1);
        s.append(this._lastAttemptedSyncDate);
        s.append(TERMINATOR1);
        s.append(this._lastSyncDate);
        s.append(TERMINATOR1);
        s.append(this._stateId);
        s.append(TERMINATOR1);
        s.append((Object)this._operation);
        s.append(TERMINATOR1);
        this.unparseNewSyncRoots(s);
        s.append(TERMINATOR1);
        s.append(this._minorVersion);
        return s.toString();
    }

    private void internalSetSyncState(InteropCore.InteropStreamState state, Feedback f) throws WvcmException {
        this.set_state(state);
        this.updateISMetadata(f);
    }

    private void internalSync(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Workspace thisCloneWs = this.thisCloneWs();
        if (this.thisSegment().numSyncRoots() == 0) {
            thisCloneWs.doUpdate(InteropUtilities.makeList(this.thisSyncStream()), f.nest(20));
            InteropUtilities.updateStreamWithWorkspace(this.thisCloneStream(), thisCloneWs, f.nest(40));
            this.thisInternalWs().doUpdate(InteropUtilities.makeList(this.thisCloneStream()), f.nest(60));
            InteropUtilities.updateStreamWithWorkspace(this.thisInternalStream(), this.thisInternalWs(), f.nest(80));
            if (this.thatSegment().get_sentoverBaselinePaths().length > 0) {
                this.thatSegment().set_sentoverBaselinePaths(new String[0]);
            }
            this.thatSyncWs().doMerge(InteropUtilities.makeList(this.thatSyncStream()), MF_NO_CHECKOUTS, f.nest(100));
            return;
        }
        this.thatSyncWs().doMerge(InteropUtilities.makeList(this.thatSyncStream()), MF_NO_CHECKOUTS, f.nest(1));
        ResourceList<Component> namedComponents = this.createThatBaselinesForRoots(f.nest(2));
        this.sendoverThatBaselines(namedComponents, null, false, f.nest(50));
        Workspace thisInternalWs = this.thisInternalWs();
        thisInternalWs.doUpdate(InteropUtilities.makeList(this.thisCloneStream()), nowork);
        thisInternalWs.doMerge(InteropUtilities.makeList(this.thisSyncStream()), MF_NO_CHECKOUTS_UPDATE, f.nest(55));
        InteropUtilities.updateStreamWithWorkspace(this.thisInternalStream(), thisInternalWs, nowork);
        this.sendoverThisStream(namedComponents, f.nest(100));
        this.set_state(InteropCore.InteropStreamState.OPERATION_ACTIVE);
        this.updateISMetadata(nowork);
    }

    private ControllableResource createClone(Workspace tgtWorkspace, Stream tgtStream, InteropStreamSegment.SyncRoots tgtDoneRoots, ControllableResource srcCloneRoot, String srcCloneRootName, Workspace srcWorkspace, Feedback f) throws WvcmException {
        WorkspaceProvider tgtP = tgtWorkspace.workspaceProvider();
        WorkspaceProvider srcP = srcWorkspace.workspaceProvider();
        ControllableResource tgtCloneRoot = null;
        Set<String> tgtDoneRootPaths = InteropCore.getSyncRootPaths(tgtWorkspace, tgtDoneRoots, f.nest(1));
        boolean isOverwrite = false;
        VersionHistory srcVH = srcCloneRoot.getVersionHistory();
        String tgtCloneVHPath = InteropCore.lookupClonePath(srcVH, tgtP);
        if (InteropCore.isFakeClonePath(tgtCloneVHPath)) {
            throw new WvcmException(Messages.InteropStream_ERROR_ONLY_ONE_SYNCHRONIZED_PROJECT, WvcmException.ReasonCode.FORBIDDEN);
        }
        VersionHistory tgtCloneVH = InteropCore.buildProxy(srcVH, (Provider)tgtP, tgtCloneVHPath);
        if (tgtCloneVH != null) {
            isOverwrite = true;
            tgtCloneRoot = InteropUtilities.doFindCRInWorkspace(tgtWorkspace, tgtCloneVH, f.nest(InteropCore.PR_CFG_PATH_WS_VH_CLONE));
        }
        if (tgtCloneRoot == null) {
            Configuration srcConfig = srcCloneRoot.getConfiguration();
            ControllableFolder tgtBCF = InteropCore.getTgtBaselineControlledFolder(tgtWorkspace, tgtStream, srcConfig, this.isImportOnly(), f.nest(InteropCore.PR_VH_CLONE));
            Location srcBCFPath = srcConfig.getRootFolder().getPathnameLocation();
            ControllableResource srcRoot = srcP.controllableResource(srcCloneRoot.getPathnameLocation());
            tgtCloneRoot = InteropCore.createCloneRoot(true, tgtBCF, tgtWorkspace, srcRoot, srcBCFPath, f.nest(2));
            tgtCloneRoot = (ControllableResource)tgtCloneRoot.doReadProperties(f.nest(InteropCore.PR_CFG_PATH_WS_VH_CLONE));
        }
        try {
            if (!InteropUtilities.isPathAChildOf(tgtCloneRoot, tgtDoneRootPaths)) {
                this.sendoverTree(tgtCloneRoot, tgtStream, tgtDoneRootPaths, srcCloneRoot, f.nest(90));
            }
        }
        catch (WvcmException e) {
            this.cleanupWorkspace(tgtWorkspace, f);
            throw e;
        }
        String msg = isOverwrite ? Messages.InteropStream_MSG_OVERWRITE_TASKNAME : Messages.InteropStream_MSG_BRING_OVER_TASKNAME;
        InteropCore.closeCurrentActivity(tgtWorkspace, f.format(msg, new Object[]{srcCloneRootName}), f.nest(100));
        return tgtCloneRoot;
    }

    private void internalDeleteSyncRoots(boolean isThis, Collection<VersionHistory> deletedSyncRoots, Feedback f) throws WvcmException {
        if (deletedSyncRoots.size() == 0) {
            return;
        }
        HashSet<String> dsrPaths = new HashSet<String>(deletedSyncRoots.size());
        for (VersionHistory dvh : deletedSyncRoots) {
            dsrPaths.add(dvh.location().string());
        }
        String[] thisSyncRootPaths = this.thisSegment().get_syncRootPaths();
        String[] thatSyncRootPaths = this.thatSegment().get_syncRootPaths();
        String[] compareSyncRootPaths = isThis ? thisSyncRootPaths : thatSyncRootPaths;
        ArrayList<String> newThisSyncRootList = new ArrayList<String>();
        ArrayList<String> newThatSyncRootList = new ArrayList<String>();
        int i = 0;
        while (i < compareSyncRootPaths.length) {
            if (!dsrPaths.contains(compareSyncRootPaths[i])) {
                newThisSyncRootList.add(thisSyncRootPaths[i]);
                newThatSyncRootList.add(thatSyncRootPaths[i]);
            }
            ++i;
        }
        int newSize = newThisSyncRootList.size();
        String[] newThisSyncRootPaths = new String[newSize];
        String[] newThatSyncRootPaths = new String[newSize];
        int i2 = 0;
        while (i2 < newSize) {
            newThisSyncRootPaths[i2] = (String)newThisSyncRootList.get(i2);
            newThatSyncRootPaths[i2] = (String)newThatSyncRootList.get(i2);
            ++i2;
        }
        this.thisSegment().set_syncRootPaths(newThisSyncRootPaths);
        this.thatSegment().set_syncRootPaths(newThatSyncRootPaths);
        HashSet<VersionHistory> thatComponents = new HashSet<VersionHistory>();
        List<ControllableResource> thatRoots = this.thatSyncRoots(this.thatSyncWs(), f.nest(InteropCore.PR_CONFIG_VH, 70));
        for (ControllableResource thatRoot : thatRoots) {
            Configuration config = thatRoot.getConfiguration();
            if (config == null) continue;
            thatComponents.add(config.getVersionHistory());
        }
        ArrayList<String> newBaselines = new ArrayList<String>();
        ResourceList<Baseline> oldBaselines = this.getSentoverBaselines();
        ResourceList<Component> oldComponents = this.readSentoverComponents(f.nest(100));
        int i3 = 0;
        while (i3 < oldBaselines.size()) {
            Baseline oldBaseline = (Baseline)oldBaselines.get(i3);
            Component oldComponent = (Component)oldComponents.get(i3);
            if (thatComponents.contains(oldComponent)) {
                newBaselines.add(oldBaseline.location().string());
            }
            ++i3;
        }
        String[] baselineNames = newBaselines.toArray(new String[newBaselines.size()]);
        this.thatSegment().set_sentoverBaselinePaths(baselineNames);
    }

    private void deleteAllSyncRoots() {
        this.thisSegment().set_syncRootPaths(new String[0]);
        this.thatSegment().set_syncRootPaths(new String[0]);
    }

    private void removePendingSubRoot(InteropCore.NewRoot newSyncRoot, String path) {
        int oldSize = newSyncRoot.pendingSubRootPaths.length;
        String[] newPendingSubRootPaths = new String[oldSize - 1];
        int j = 0;
        int i = 0;
        while (i < oldSize) {
            if (!newSyncRoot.pendingSubRootPaths[i].equals(path)) {
                newPendingSubRootPaths[j] = newSyncRoot.pendingSubRootPaths[i];
                ++j;
            }
            ++i;
        }
        newSyncRoot.pendingSubRootPaths = newPendingSubRootPaths;
    }

    private void removePendingSyncRoot(InteropCore.NewRoot newSyncRoot) {
        int oldSize = this._newSyncRoots.length;
        InteropCore.NewRoot[] newNewSyncRoots = new InteropCore.NewRoot[oldSize - 1];
        int j = 0;
        int i = 0;
        while (i < oldSize) {
            if (!this._newSyncRoots[i].path.equals(newSyncRoot.path)) {
                newNewSyncRoots[j] = this._newSyncRoots[i];
                ++j;
            }
            ++i;
        }
        this._newSyncRoots = newNewSyncRoots;
    }

    private void clear_newSyncRootPaths(Feedback f) throws WvcmException {
        if (this._newSyncRoots.length > 0) {
            this._newSyncRoots = new InteropCore.NewRoot[0];
        }
    }

    private boolean isRestartableImports() {
        try {
            return InteropUtilities.TRUE_STRING.equals(this.thisProvider().initArgs().get("com.ibm.team.interop.RESTARTABLE_IMPORTS"));
        }
        catch (WvcmException wvcmException) {
            return false;
        }
    }

    private int getMaximumMemberCount(Feedback nowork) throws WvcmException {
        return InteropCore.getInt((Provider)this.thisProvider(), "com.ibm.team.interop.MAXIMUM_MEMBER_COUNT", nowork);
    }

    private List<String> findBigFolderRoots(WorkspaceProvider srcP, String syncRootPath, Feedback f) throws WvcmException {
        ArrayList<String> results = new ArrayList<String>();
        int threshold = this.getMaximumMemberCount(f);
        if (threshold < 1) {
            return results;
        }
        f.notifyActive(f.format(Messages.InteropStream_MSG_SCANNING_FOR_BIG_FOLDERS, new Object[]{String.valueOf(threshold)}));
        ControllableResource srcCR = srcP.controllableResource(srcP.location(syncRootPath));
        Workspace srcWorkspace = (Workspace)InteropUtilities.doReadProperty((Resource)srcCR, ControllableResource.WORKSPACE, f.nest());
        ControllableResource srcCloneRoot = InteropCore.findCloneRoot(srcCR, srcWorkspace, f.nest(InteropCore.PR_CFG_RF_PATH_WS_VH_CLONE));
        if (srcCloneRoot != null && srcCloneRoot instanceof ControllableFolder) {
            ControllableFolder query = srcCloneRoot.workspaceProvider().controllableFolder(srcCloneRoot.location());
            query.setProperty(InteropCore.PN_MAXIMUM_MEMBER_COUNT, (Object)threshold);
            ResourceList.ResponseIterator folders = query.doFindAll(f.nest(InteropCore.PR_PATH, 100));
            while (folders.hasNext()) {
                ControllableFolder tempCloneRoot = (ControllableFolder)folders.next();
                String name = InteropUtilities.getFriendlyPathname((Resource)tempCloneRoot, 0, f);
                f.notifyCompleted(f.format(Messages.InteropStream_ADDING_TEMP_SYNC_ROOT, new Object[]{name}));
                String folderPath = tempCloneRoot.getPathnameLocation().string();
                results.add(folderPath);
            }
        }
        return results;
    }

    private void addCloneRoot(boolean isImport, InteropStreamSegment.SyncRoots srcSyncRoots, Workspace srcWorkspace, InteropStreamSegment.SyncRoots tgtSyncRoots, InteropStreamSegment.SyncRoots tgtDoneSyncRoots, Workspace tgtWorkspace, Stream tgtStream, String syncRootPath, Component2Baselines thatComponents2Baselines, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        Feedback fcrNoWork = f.nest(InteropCore.PR_CFG_RF_PATH_WS_VH_CLONE);
        WorkspaceProvider srcP = srcWorkspace.workspaceProvider();
        ControllableResource srcCR = srcP.controllableResource(srcP.location(syncRootPath));
        ControllableResource srcCloneRoot = InteropCore.findCloneRoot(srcCR, srcWorkspace, fcrNoWork);
        String name = InteropUtilities.getFriendlyPathname((Resource)srcCloneRoot, 100, nowork);
        try {
            ControllableResource tgtCloneRoot = this.createClone(tgtWorkspace, tgtStream, tgtDoneSyncRoots, srcCloneRoot, name, srcWorkspace, f.nest(100));
            String srcRootName = srcCloneRoot.getVersionHistory().location().string();
            String tgtRootName = tgtCloneRoot.getVersionHistory().location().string();
            int oldSize = srcSyncRoots.paths.length;
            if (!Arrays.asList(srcSyncRoots.paths).contains(srcRootName)) {
                String[] newSrcRootPaths = new String[oldSize + 1];
                String[] newTgtRootPaths = new String[oldSize + 1];
                int i = 0;
                while (i < oldSize) {
                    newSrcRootPaths[i] = srcSyncRoots.paths[i];
                    newTgtRootPaths[i] = tgtSyncRoots.paths[i];
                    ++i;
                }
                newSrcRootPaths[oldSize] = srcRootName;
                newTgtRootPaths[oldSize] = tgtRootName;
                srcSyncRoots.paths = newSrcRootPaths;
                tgtSyncRoots.paths = newTgtRootPaths;
            }
            ControllableResource thatCloneRoot = isImport ? srcCloneRoot : tgtCloneRoot;
            Configuration thatRootConfig = thatCloneRoot.getConfiguration();
            Component thatRootComponent = (Component)thatRootConfig.getVersionHistory();
            Baseline baselineToRecord = null;
            if (this.isImportOnly()) {
                baselineToRecord = (Baseline)thatRootConfig.getCheckedIn();
            } else {
                boolean needNewBaseline;
                boolean bl = needNewBaseline = !isImport || thatComponents2Baselines.needsNewBaseline(thatRootComponent);
                if (needNewBaseline) {
                    baselineToRecord = InteropUtilities.makeBaseline(thatRootConfig, null, f.nest(10));
                }
            }
            if (baselineToRecord != null) {
                thatComponents2Baselines.update(thatRootComponent, baselineToRecord);
                this.thatSegment().set_sentoverBaselinePaths(thatComponents2Baselines.getBaselinePaths());
            }
        }
        catch (Exception e) {
            WvcmException.ReasonCode reason = e instanceof WvcmException ? ((WvcmException)((Object)e)).getReasonCode() : WvcmException.ReasonCode.FORBIDDEN;
            throw new WvcmException(InteropCore.msg(f, InteropCore.Msg.ERROR_COULD_NOT_TRANSFER_ROOT, syncRootPath), null, reason, (Throwable)e);
        }
        f.notifyCompleted(f.format(Messages.InteropStream_MSG_TRANSFERRED_ROOT, new Object[]{name}));
    }

    private void tryAddCloneRoots(boolean isImport, InteropStreamSegment.SyncRoots srcSyncRoots, Workspace srcWorkspace, InteropStreamSegment.SyncRoots tgtSyncRoots, Workspace tgtWorkspace, Stream tgtStream, List<WvcmException> exceptions, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider srcP = srcWorkspace.workspaceProvider();
        WorkspaceProvider tgtP = tgtWorkspace.workspaceProvider();
        ArrayList<InteropCore.NewRoot> pendingRoots = new ArrayList<InteropCore.NewRoot>(Arrays.asList(this._newSyncRoots));
        int done = 0;
        int todo = pendingRoots.size();
        InteropCore.NewRoot[] newRootArray = this._newSyncRoots;
        int n = this._newSyncRoots.length;
        int n2 = 0;
        while (n2 < n) {
            InteropCore.NewRoot newRoot = newRootArray[n2];
            if (newRoot.pendingSubRootPaths == null) {
                List<String> paths = this.findBigFolderRoots(srcWorkspace.workspaceProvider(), newRoot.path, nowork);
                newRoot.pendingSubRootPaths = paths.toArray(new String[paths.size()]);
                newRoot.srcSubRootPaths = new InteropStreamSegment.SyncRoots(new String[0]);
                newRoot.tgtSubRootPaths = new InteropStreamSegment.SyncRoots(new String[0]);
            }
            todo += newRoot.pendingSubRootPaths.length;
            ++n2;
        }
        Component2Baselines components2baselines = new Component2Baselines(this.readSentoverComponentsAndBaselines(f.nest(10)));
        while (!pendingRoots.isEmpty()) {
            InteropCore.NewRoot newSyncRoot = (InteropCore.NewRoot)pendingRoots.remove(0);
            if (newSyncRoot.pendingSubRootPaths.length > 0) {
                HashSet<String> failedSubPaths = new HashSet<String>();
                String[] stringArray = newSyncRoot.pendingSubRootPaths;
                int n3 = newSyncRoot.pendingSubRootPaths.length;
                int n4 = 0;
                while (n4 < n3) {
                    block20: {
                        String pendingPath = stringArray[n4];
                        if (InteropUtilities.isAParentOf(pendingPath, failedSubPaths)) {
                            failedSubPaths.add(pendingPath);
                            f.notifyCompleted(f.format(Messages.InteropStream_SKIP_PARENT_OF_FAILED_ROOT, new Object[]{pendingPath}));
                        } else {
                            try {
                                try {
                                    InteropUtilities.forceAbortWvcmException((Provider)srcP, 18, f);
                                    srcP.clearCache(f);
                                    tgtP.clearCache(f);
                                    this.addCloneRoot(isImport, newSyncRoot.srcSubRootPaths, srcWorkspace, newSyncRoot.tgtSubRootPaths, InteropCore.combinedSyncRoots(tgtSyncRoots, newSyncRoot.tgtSubRootPaths), tgtWorkspace, tgtStream, pendingPath, components2baselines, f.nest(100 * ++done / todo));
                                    this.removePendingSubRoot(newSyncRoot, pendingPath);
                                }
                                catch (WvcmException e) {
                                    failedSubPaths.add(pendingPath);
                                    exceptions.add(e);
                                    f.notifyCompleted(f.format(Messages.InteropStream_ERROR_IN_SYNC_OF_A_SUBROOT, new Object[]{pendingPath, e.getReasonCode(), e.getMessage()}));
                                    if (e.getReasonCode() == WvcmException.ReasonCode.ABORTED) {
                                        this.updateISMetadata(nowork);
                                        return;
                                    }
                                    this.updateISMetadata(nowork);
                                    break block20;
                                }
                            }
                            catch (Throwable throwable) {
                                this.updateISMetadata(nowork);
                                throw throwable;
                            }
                            this.updateISMetadata(nowork);
                        }
                    }
                    ++n4;
                }
            }
            try {
                try {
                    if (newSyncRoot.pendingSubRootPaths.length == 0) {
                        srcP.clearCache(f);
                        tgtP.clearCache(f);
                        this.addCloneRoot(isImport, srcSyncRoots, srcWorkspace, tgtSyncRoots, InteropCore.combinedSyncRoots(tgtSyncRoots, newSyncRoot.tgtSubRootPaths), tgtWorkspace, tgtStream, newSyncRoot.path, components2baselines, f.nest(100 * ++done / todo));
                        this.removePendingSyncRoot(newSyncRoot);
                        InteropUtilities.forceAbortWvcmException((Provider)tgtP, 19, f);
                    } else {
                        f.notifyCompleted(f.format(Messages.InteropStream_SKIP_PARENT_OF_FAILED_ROOT, new Object[]{newSyncRoot.path}));
                    }
                }
                catch (WvcmException e) {
                    exceptions.add(e);
                    f.notifyCompleted(f.format(Messages.InteropStream_ERROR_IN_SYNC_OF_A_ROOT, new Object[]{newSyncRoot.path, e.getReasonCode(), e.getMessage()}));
                    if (e.getReasonCode() == WvcmException.ReasonCode.ABORTED) {
                        InteropUtilities.updateStreamWithWorkspace(tgtStream, tgtWorkspace, nowork);
                        this.updateISMetadata(nowork);
                        return;
                    }
                    InteropUtilities.updateStreamWithWorkspace(tgtStream, tgtWorkspace, nowork);
                    this.updateISMetadata(nowork);
                    continue;
                }
            }
            catch (Throwable throwable) {
                InteropUtilities.updateStreamWithWorkspace(tgtStream, tgtWorkspace, nowork);
                this.updateISMetadata(nowork);
                throw throwable;
            }
            InteropUtilities.updateStreamWithWorkspace(tgtStream, tgtWorkspace, nowork);
            this.updateISMetadata(nowork);
        }
    }

    private void addCloneRoots(Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        boolean isImport = this.isImport();
        ArrayList<WvcmException> exceptions = new ArrayList<WvcmException>();
        if (isImport) {
            this.tryAddCloneRoots(isImport, this.thatSegment().get_syncRoots(), this.thatSyncWs(), this.thisSegment().get_syncRoots(), this.thisCloneWs(), this.thisCloneStream(), exceptions, f);
        } else {
            this.tryAddCloneRoots(isImport, this.thisSegment().get_syncRoots(), this.thisCloneWs(), this.thatSegment().get_syncRoots(), this.thatSyncWs(), this.thatSyncStream(), exceptions, f);
        }
        if (isImport) {
            Workspace thisInternalWs = this.thisInternalWs();
            thisInternalWs.doUpdate(InteropUtilities.makeList(this.thisCloneStream()), nowork);
            thisInternalWs.doMerge(InteropUtilities.makeList(this.thisSyncStream()), MF_NO_CHECKOUTS_UPDATE, nowork);
        }
        if (exceptions.size() > 0) {
            if (exceptions.size() == 1) {
                throw (WvcmException)((Object)exceptions.get(0));
            }
            String msg = Messages.InteropStream_ERROR_ADD_SYNC_FILES_FAILED;
            Throwable[] es = exceptions.toArray(new WvcmException[exceptions.size()]);
            throw new WvcmException(msg, null, WvcmException.ReasonCode.CONFLICT, (Throwable)exceptions.get(0), es);
        }
    }

    private void cleanupThat(Feedback f) throws WvcmException {
        this.cleanupWorkspace(this.thatSyncWs(), f);
    }

    private void cleanupThis(Feedback f) throws WvcmException {
        this.cleanupWorkspace(this.thisCloneWs(), f);
    }

    private void cleanupWorkspace(Workspace ws, Feedback f) throws WvcmException {
        String taskName = Messages.InteropStream_MSG_LEFTOVER_CHECKOUTS;
        ws.doCheckinAll(taskName, null, f.nest(60));
        InteropCore.closeCurrentActivity(ws, taskName, f.nest(100));
    }

    private List<ResourceList<Baseline>> createCompositeBaselines(List<ResourceList<Baseline>> baselineHistoryGraphs) throws WvcmException {
        ArrayList<ResourceList<Baseline>> result = new ArrayList<ResourceList<Baseline>>();
        for (List list : baselineHistoryGraphs) {
            int i = 0;
            while (i < list.size()) {
                if (i >= result.size()) {
                    result.add(InteropUtilities.makeList((Baseline)list.get(i)));
                } else {
                    ((ResourceList)result.get(i)).add((Object)((Baseline)list.get(i)));
                }
                ++i;
            }
        }
        return result;
    }

    private void throwBaselineNotFoundMsg(Baseline baseline, List<Baseline> baselines, Component component, Feedback f) throws WvcmException {
        String blMsg = "";
        for (Baseline b : baselines) {
            blMsg = String.valueOf(blMsg) + "\n   loc=" + b.location() + " id=" + (String)InteropUtilities.tryGetProperty((Resource)b, Baseline.RESOURCE_IDENTIFIER);
        }
        throw new WvcmException(f.format(Messages.InteropStream_ERROR_BASELINE_NOT_FOUND, new Object[]{component.location(), this.thatSyncStream().location(), baseline.location(), InteropUtilities.tryGetProperty((Resource)baseline, Baseline.RESOURCE_IDENTIFIER), blMsg}), null, WvcmException.ReasonCode.NOT_FOUND);
    }

    private void importBaselines(ResourceList<Baseline> importBaselines, Feedback f) throws WvcmException {
        String msg = Messages.InteropStream_MSG_IMPORT;
        for (Baseline baseline : importBaselines) {
            msg = f.format("{0} {1}", new Object[]{msg, baseline.getDisplayName()});
        }
        f.notifyActive(msg);
        this.thatSyncWs().doUpdate(importBaselines, f.nest(10));
        Workspace thisCloneWs = this.thisCloneWs();
        if (this.thisSegment().numSyncRoots() == 0) {
            thisCloneWs.doUpdate(InteropUtilities.makeList(this.thisSyncStream()), f.nest(25));
            InteropUtilities.updateStreamWithWorkspace(this.thisCloneStream(), thisCloneWs, f.nest(50));
            this.thisInternalWs().doUpdate(InteropUtilities.makeList(this.thisCloneStream()), f.nest(75));
            InteropUtilities.updateStreamWithWorkspace(this.thisInternalStream(), this.thisInternalWs(), f.nest(100));
            if (this.thatSegment().get_sentoverBaselinePaths().length > 0) {
                this.thatSegment().set_sentoverBaselinePaths(new String[0]);
            }
            return;
        }
        this.sendoverThatBaselines(importBaselines, true, f.nest(100));
    }

    private void baselineNewThatRootComponents(ResourceList<Baseline> origThatBaselines, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        HashSet<Component> origThatComponentSet = new HashSet<Component>();
        for (Baseline origThatBaseline : origThatBaselines) {
            origThatComponentSet.add((Component)origThatBaseline.getVersionHistory());
        }
        ResourceList<Baseline> currentThatBaselines = this.readSentoverBaselines((Feedback)InteropCore.PR_NAME_VH);
        Workspace thisWs = this.thisSyncWs().doUpdate(InteropUtilities.makeList(this.thisCloneStream()), nowork);
        for (Baseline thatBaseline : currentThatBaselines) {
            Component thatComp = (Component)thatBaseline.getVersionHistory();
            if (origThatComponentSet.contains(thatComp)) continue;
            Component thisComp = (Component)InteropCore.lookupClone(thatComp, thisWs.workspaceProvider()).doReadProperties((Feedback)InteropUtilities.PR_DN);
            String thisCompName = thisComp.getDisplayName();
            Configuration thisConf = InteropUtilities.doFindConfigurationInWorkspace(thisWs, thisComp, nowork);
            String name = thatBaseline.getDisplayName();
            Baseline thisBl = InteropUtilities.makeBaseline(thisConf, name, (Feedback)InteropUtilities.PR_DN);
            String thisBlName = thisBl.getDisplayName();
            f.notifyCompleted(f.format(Messages.InteropStream_MSG_BASELINED_COMPONENT_WITH_BL_DN, new Object[]{thisBlName, thisCompName}));
        }
    }

    private void importStream(Feedback f) throws WvcmException {
        block20: {
            long syncDate = new Date().getTime();
            Feedback nowork = f.nest();
            this.reserveInteropStream(nowork);
            try {
                try {
                    InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 15, f);
                    this.set_state(InteropCore.InteropStreamState.OPERATION_ACTIVE);
                    this._lastAttemptedSyncDate = syncDate;
                    this.updateISMetadata(nowork);
                    this.cleanupThis(nowork);
                    if (this._newSyncRoots.length != 0) {
                        ResourceList<Baseline> origBaselines = this.readSentoverBaselines((Feedback)InteropCore.PR_NAME_VH);
                        this.addCloneRoots(f.nest(4));
                        this.baselineNewThatRootComponents(origBaselines, nowork);
                    }
                    ResourceList<Baseline> currentBaselines = this.getSentoverBaselines();
                    ResourceList<Component> currentComponents = this.readSentoverComponents(f.nest(5));
                    ArrayList<ResourceList<Baseline>> componentBaselineLists = new ArrayList<ResourceList<Baseline>>();
                    int n = currentBaselines.size();
                    PropertyNameList.PropertyName baselineFilterPropertyName = null;
                    PropertyRequestItem.PropertyRequest propertyRequest = InteropCore.PR_BL;
                    String baselineFilter = this.getBaselineFilter();
                    if (baselineFilter != null && !baselineFilter.equals("")) {
                        baselineFilterPropertyName = new PropertyNameList.PropertyName("com.ibm.team.importer", baselineFilter);
                        propertyRequest = new PropertyRequestItem.PropertyRequest(new PropertyRequestItem[]{baselineFilterPropertyName, Baseline.SUCCESSOR_LIST, Baseline.DISPLAY_NAME});
                    }
                    int i = 0;
                    while (i < n) {
                        Baseline current = (Baseline)currentBaselines.get(i);
                        Component component = (Component)currentComponents.get(i);
                        List<Baseline> streamBaselines = InteropUtilities.doFindAllBaselinesInStreamInComponent(this.thatSyncStream(), component, f.nest(propertyRequest, InteropUtilities.LP(100, i, n, 5, 25)));
                        if (streamBaselines.size() > 0) {
                            int iCur = streamBaselines.indexOf(current);
                            if (iCur < 0) {
                                this.throwBaselineNotFoundMsg(current, streamBaselines, component, f);
                            }
                            ResourceList newBaselines = current.provider().resourceList((Resource[])new Baseline[0]);
                            Baseline bl = InteropUtilities.lookupNextVersionInList(streamBaselines.get(iCur), streamBaselines);
                            while (bl != null) {
                                if (baselineFilterPropertyName == null || bl.getProperty(baselineFilterPropertyName) != null) {
                                    newBaselines.add((Object)bl);
                                }
                                bl = InteropUtilities.lookupNextVersionInList(bl, streamBaselines);
                            }
                            if (newBaselines.size() > 0) {
                                componentBaselineLists.add((ResourceList<Baseline>)newBaselines);
                            }
                        }
                        ++i;
                    }
                    List<ResourceList<Baseline>> compositeBaselineLists = this.createCompositeBaselines(componentBaselineLists);
                    n = compositeBaselineLists.size();
                    int i2 = 0;
                    for (ResourceList<Baseline> baselines : compositeBaselineLists) {
                        this.importBaselines(baselines, f.nest(InteropUtilities.LP(100, i2, n, 25, 95)));
                        ++i2;
                    }
                    Workspace thisInternalWs = this.thisInternalWs();
                    thisInternalWs.doUpdate(InteropUtilities.makeList(this.thisCloneStream()), f.nest(96));
                    thisInternalWs.doMerge(InteropUtilities.makeList(this.thisSyncStream()), MF_NO_CHECKOUTS_UPDATE, f.nest(97));
                    InteropUtilities.updateStreamWithWorkspace(this.thisInternalStream(), thisInternalWs, f.nest(98));
                    this.thisSyncWs().doUpdate(InteropUtilities.makeList(this.thisSyncStream()), f.nest(99));
                    this.set_state(InteropCore.InteropStreamState.OK);
                    this._lastSyncDate = syncDate;
                }
                catch (Throwable e) {
                    this.setInteropStreamState(e);
                    this.unreserveInteropStream(f.nest(99));
                    try {
                        InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 11, f);
                        this.updateISMetadata(f.nest(100));
                    }
                    catch (Exception exception) {
                        f.notifyWarning(Messages.InteropStream_ERROR_METADATA_UPDATE_FAILED);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                this.unreserveInteropStream(f.nest(99));
                try {
                    InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 11, f);
                    this.updateISMetadata(f.nest(100));
                }
                catch (Exception exception) {
                    f.notifyWarning(Messages.InteropStream_ERROR_METADATA_UPDATE_FAILED);
                }
                throw throwable;
            }
            this.unreserveInteropStream(f.nest(99));
            try {
                InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 11, f);
                this.updateISMetadata(f.nest(100));
            }
            catch (Exception exception) {
                f.notifyWarning(Messages.InteropStream_ERROR_METADATA_UPDATE_FAILED);
            }
        }
    }

    private void desync(String desyncVal, Feedback f) throws WvcmException {
        Feedback nowork = f.nest();
        WorkspaceProvider thisP = this.thisProvider();
        this.reserveInteropStream(nowork);
        try {
            InteropUtilities.forceAbortWvcmException((Provider)thisP, 20, f);
            this.internalSetSyncState(InteropCore.InteropStreamState.OPERATION_ACTIVE, nowork);
            if (!this._operation.equals((Object)InteropCore.InteropStreamOperation.EXPORT)) {
                throw new WvcmException("Can only DESYNC Jazz files", WvcmException.ReasonCode.CONFLICT);
            }
            int n = this._newSyncRoots.length;
            int i = 0;
            InteropCore.NewRoot[] newRootArray = this._newSyncRoots;
            int n2 = this._newSyncRoots.length;
            int n3 = 0;
            while (n3 < n2) {
                InteropCore.NewRoot thisRoot = newRootArray[n3];
                String thisRootPath = thisRoot.path;
                try {
                    InteropUtilities.forceAbortWvcmException((Provider)thisP, 21, f);
                    ControllableResource root = thisP.controllableResource(thisP.location(thisRootPath));
                    root = (ControllableResource)root.doReadProperties(f.nest(InteropCore.PR_PATH_VH_CLONE));
                    String name = InteropUtilities.getFriendlyPathname((Resource)root, 0, f);
                    if (desyncVal.equals("component")) {
                        root = (ControllableResource)root.doReadProperties(f.nest(InteropCore.PR_CONFIG_VH_CLONE));
                        root = root.getConfiguration();
                        name = f.format(Messages.InteropStream_MSG_COMPONENT_OF, new Object[]{name});
                    }
                    VersionHistory vh = root.getVersionHistory();
                    String msg = f.format(Messages.InteropStream_MSG_NOT_CURRENTLY_SYNCHRONIZED, new Object[]{name});
                    if (InteropUtilities.getProperty((Resource)vh, InteropCore.PN_CLONE) != null) {
                        vh.removeProperty(InteropCore.PN_CLONE);
                        vh.doWriteProperties(nowork);
                        msg = f.format(Messages.InteropStream_MSG_DESYNCHRONIZED, new Object[]{name});
                    }
                    f.notifyCompleted(msg);
                }
                catch (WvcmException e) {
                    String msg = f.format(Messages.InteropStream_ERROR_TRYING_TO_DESYNCHRONIZE, new Object[]{e.getMessage()});
                    f.notifyWarning(msg);
                }
                f.notifyPercentComplete(100 * (i + 1) / n);
                ++i;
                ++n3;
            }
        }
        finally {
            this.clear_newSyncRootPaths(nowork);
            this.thisSegment().put_initArgs("com.ibm.team.interop.DESYNC", "");
            this.set_state(InteropCore.InteropStreamState.OK);
            this.updateISMetadata(nowork);
            this.unreserveInteropStream(nowork);
        }
    }

    private static InteropCore.NewRoot[] appendRoots(List<ControllableResource> requestedRoots, InteropCore.NewRoot[] existingRoots, Feedback f) throws WvcmException {
        ArrayList<String> paths = new ArrayList<String>(requestedRoots.size() + existingRoots.length);
        ArrayList<InteropCore.NewRoot> newRoots = new ArrayList<InteropCore.NewRoot>(requestedRoots.size() + existingRoots.length);
        InteropCore.NewRoot[] newRootArray = existingRoots;
        int n = existingRoots.length;
        int n2 = 0;
        while (n2 < n) {
            InteropCore.NewRoot root = newRootArray[n2];
            paths.add(root.path);
            newRoots.add(root);
            ++n2;
        }
        for (ControllableResource requestedRoot : requestedRoots) {
            String path = ((Location)InteropUtilities.doReadProperty((Resource)requestedRoot, Resource.PATHNAME_LOCATION, f)).string();
            if (paths.contains(path)) continue;
            paths.add(path);
            newRoots.add(new InteropCore.NewRoot(path));
        }
        return newRoots.toArray(new InteropCore.NewRoot[0]);
    }

    private void internalPostOperation(InteropCore.InteropStreamOperation operation, List<ControllableResource> roots, Feedback f) throws WvcmException {
        this.clear_newSyncRootPaths(f);
        this._operation = operation;
        if (roots != null) {
            this._newSyncRoots = InteropStream.appendRoots(roots, this._newSyncRoots, f);
        }
        this.set_state(InteropCore.InteropStreamState.OPERATION_PENDING);
    }

    private void internalPostAppendOperation(InteropCore.InteropStreamOperation operation, List<ControllableResource> roots, Feedback f) throws WvcmException {
        InteropCore.InteropStreamState state = this.get_state();
        if (state != InteropCore.InteropStreamState.OPERATION_PENDING && state != InteropCore.InteropStreamState.OK) {
            throw new WvcmException("cannot append roots when the sync stream is in state: " + state.toString(), WvcmException.ReasonCode.PROPERTY_OVERWRITE_FORBIDDEN);
        }
        this._operation = operation;
        if (roots != null) {
            this._newSyncRoots = InteropStream.appendRoots(roots, this._newSyncRoots, f);
        }
        this.set_state(InteropCore.InteropStreamState.OPERATION_PENDING);
    }

    private void postOperation(InteropCore.InteropStreamOperation operation, List<ControllableResource> roots, Feedback f) throws WvcmException {
        this.reserveInteropStream(f);
        try {
            InteropUtilities.forceAbortWvcmException((Provider)this.thisProvider(), 22, f);
            this.internalPostOperation(operation, roots, f.nest(5));
            this.updateISMetadata(f.nest(40));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    private void postAppendOperation(InteropCore.InteropStreamOperation operation, List<ControllableResource> roots, Feedback f) throws WvcmException {
        this.reserveInteropStream(f);
        try {
            InteropUtilities.forceAbortWvcmException((Provider)this.thisProvider(), 22, f);
            this.internalPostAppendOperation(operation, roots, f.nest(5));
            this.updateISMetadata(f.nest(40));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public String toString() {
        try {
            InteropUtilities.forceWvcmException((Provider)this.thisProvider(), 23);
            return (String)InteropUtilities.doReadProperty((Resource)this.thisSyncStream(), Stream.DISPLAY_NAME, null);
        }
        catch (WvcmException wvcmException) {
            return this.unparse();
        }
    }

    public String toVerboseString() {
        return this.unparse();
    }

    public String diagThatSentoverBaselines() {
        return InteropUtilities.join('\n', this.thatSegment().get_sentoverBaselinePaths());
    }

    public InteropStreamSegment thisSegment() {
        return this._thisSegment;
    }

    public InteropStreamSegment thatSegment() {
        return this._thatSegment;
    }

    public InteropCore.InteropStreamState get_state() {
        return this.thisSegment().get_state();
    }

    private void set_state(InteropCore.InteropStreamState state) {
        this.thisSegment().set_state(state);
    }

    private boolean isImport() throws WvcmException {
        boolean isImport;
        if (this._operation.equals((Object)InteropCore.InteropStreamOperation.EXPORT)) {
            isImport = false;
        } else if (this._operation.equals((Object)InteropCore.InteropStreamOperation.IMPORT)) {
            isImport = true;
        } else {
            throw new WvcmException("Illegal operation: " + (Object)((Object)this._operation), WvcmException.ReasonCode.FORBIDDEN);
        }
        return isImport;
    }

    public InteropCore.InteropStreamOperation get_operation() {
        if (this.get_state().equals((Object)InteropCore.InteropStreamState.OPERATION_PENDING) && this._newSyncRoots.length == 0) {
            return InteropCore.InteropStreamOperation.SYNCHRONIZE;
        }
        return this._operation;
    }

    public String[] get_unprocessedArguments() {
        if (this._newSyncRoots.length == 0) {
            return null;
        }
        String[] args = new String[this._newSyncRoots.length];
        int i = 0;
        while (i < this._newSyncRoots.length) {
            args[i] = this._newSyncRoots[i].path;
            ++i;
        }
        return args;
    }

    public long lastAttemptedSyncDate() {
        return this._lastAttemptedSyncDate;
    }

    public long lastSyncDate() {
        return this._lastSyncDate;
    }

    public WorkspaceProvider thisProvider() throws WvcmException {
        return this.thisSegment().provider();
    }

    public WorkspaceProvider thatProvider() throws WvcmException {
        return this.thatSegment().provider();
    }

    public Stream thisCloneStream() throws WvcmException {
        return this.thisSegment().cloneStream();
    }

    public Workspace thisCloneWs() throws WvcmException {
        return this.thisSegment().cloneWs();
    }

    public Stream thisSyncStream() throws WvcmException {
        return this.thisSegment().syncStream();
    }

    public Workspace thisSyncWs() throws WvcmException {
        return this.thisSegment().syncWs();
    }

    public Stream thisInternalStream() throws WvcmException {
        return this.thisSegment().internalStream();
    }

    public Workspace thisInternalWs() throws WvcmException {
        return this.thisSegment().internalWs();
    }

    public Workspace thisMergeWs() throws WvcmException {
        WorkspaceProvider p = this.thisProvider();
        String wsPath = (String)this.thisProvider().initArgs().get("com.ibm.team.interop.MERGE_WORKSPACE");
        if (wsPath == null) {
            return null;
        }
        return p.workspace(p.location(wsPath));
    }

    public List<ControllableResource> thisSyncRoots(Workspace ws, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        List<ControllableResource> roots = this.getPrunedSyncRoots(true, ws, null, f);
        f.notifyPercentComplete(100);
        return roots;
    }

    public Stream thatSyncStream() throws WvcmException {
        return this.thatSegment().syncStream();
    }

    public Workspace thatSyncWs() throws WvcmException {
        return this.thatSegment().syncWs();
    }

    public List<ControllableResource> thatSyncRootsInComponentList(Workspace ws, ResourceList<Component> optionalThatNamedComponents, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        List<ControllableResource> roots = this.getPrunedSyncRoots(false, ws, optionalThatNamedComponents, f);
        f.notifyPercentComplete(100);
        return roots;
    }

    public List<ControllableResource> thatSyncRoots(Workspace ws, Feedback feedback) throws WvcmException {
        return this.thatSyncRootsInComponentList(ws, null, feedback);
    }

    public static InteropStream lookupInteropStream(Stream thisSyncStream, Feedback feedback) throws WvcmException {
        if (thisSyncStream == null) {
            return null;
        }
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        Stream stream = (Stream)thisSyncStream.doReadProperties(f.nest(InteropCore.PR_IS, 100));
        InteropStream is = InteropStream.parse(InteropUtilities.getProperty((Resource)stream, InteropCore.PN_INTEROP_STREAM), thisSyncStream.provider().callback(), f);
        if (is != null && is._upgradeMessage != null) {
            try {
                is.reserveInteropStream(nowork);
                try {
                    is.updateISMetadata(nowork);
                }
                finally {
                    is.unreserveInteropStream(nowork);
                }
            }
            catch (WvcmException wvcmException) {
                f.notifyWarning(Messages.InteropStream_WARN_COULD_NOT_RESERVE);
            }
        }
        return is;
    }

    public void initialize(Stream thatStream, boolean isImportOnly, ResourceList<?> initialThisSource, Feedback feedback) throws WvcmException {
        long syncDate;
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        Stream thatSyncStream = thatStream;
        this.thatSegment().set_syncStreamPath(thatSyncStream.location().string());
        String thatSyncStreamName = (String)InteropUtilities.doReadProperty((Resource)thatSyncStream, Stream.DISPLAY_NAME, nowork);
        f.notifyPercentComplete(10);
        String thatWsName = this.createThatWorkspaceName(thatSyncStreamName, nowork);
        Workspace thatSyncWs = InteropCore.createInteropWorkspace(thatWsName, isImportOnly, thatSyncStream, nowork);
        f.notifyPercentComplete(40);
        this.thatSegment().set_syncWsPath(thatSyncWs.location().string());
        f.notifyPercentComplete(60);
        HashMap<String, String> thatInitArgs = new HashMap<String, String>();
        InteropCore.setHasCloneInfo(thatInitArgs, false);
        thatInitArgs.put("com.ibm.team.interop.OTHER_WORKSPACE_NAME", "");
        thatInitArgs.put("com.ibm.team.interop.OTHER_STREAM_LOCATION", thatStream.location().string());
        thatInitArgs.put("com.ibm.rational.wvcm.WORKSPACE_LOCATION", thatSyncWs.location().string());
        thatInitArgs.put("com.ibm.team.interop.FORCE_EXCEPTION", "");
        thatInitArgs.put("com.ibm.team.interop.IMPORT_ONLY", isImportOnly ? InteropUtilities.TRUE_STRING : InteropUtilities.FALSE_STRING);
        this.thatSegment().putAll_initArgs(thatInitArgs);
        HashMap<String, String> thisInitArgs = new HashMap<String, String>();
        InteropCore.setHasCloneInfo(thisInitArgs, true);
        thisInitArgs.put("com.ibm.team.interop.DESYNC", "");
        thisInitArgs.put("com.ibm.team.interop.FORCE_EXCEPTION", "");
        this.thisSegment().putAll_initArgs(thisInitArgs);
        WorkspaceProvider thisP = this.thisProvider();
        Stream thisSyncStream = InteropUtilities.createStream(thatSyncStreamName, thisP, null, f.nest(InteropCore.PR_WORKSPACE));
        if (initialThisSource != null) {
            thisSyncStream.doUpdate(initialThisSource, f);
        }
        this.thisSegment().set_syncStreamPath(thisSyncStream.location().string());
        Workspace thisSyncWs = thisSyncStream.getWorkspace();
        this.thisSegment().set_syncWsPath(thisSyncWs.location().string());
        f.notifyPercentComplete(70);
        String internalWsName = f.format("INTERNAL_{0}", new Object[]{thatSyncStreamName});
        Workspace thisInternalWs = InteropCore.createInteropWorkspace(internalWsName, true, thisSyncStream, f.nest(InteropCore.PR_STREAM));
        this.thisSegment().set_internalWsPath(thisInternalWs.location().string());
        Stream thisInternalStream = thisInternalWs.getStream();
        this.thisSegment().set_internalStreamPath(thisInternalStream.location().string());
        f.notifyPercentComplete(80);
        String cloneWsName = f.format("CLONE_{0}", new Object[]{thatSyncStreamName});
        Workspace thisCloneWs = InteropCore.createInteropWorkspace(cloneWsName, true, thisSyncStream, f.nest(InteropCore.PR_STREAM));
        this.thisSegment().set_cloneWsPath(thisCloneWs.location().string());
        Stream thisCloneStream = thisCloneWs.getStream();
        this.thisSegment().set_cloneStreamPath(thisCloneStream.location().string());
        f.notifyPercentComplete(90);
        this._minorVersion = CURRENT_MINOR_VERSION;
        this._lastAttemptedSyncDate = syncDate = new Date().getTime();
        this._lastSyncDate = syncDate;
        this.updateISMetadata(nowork);
        f.notifyPercentComplete(100);
    }

    public boolean isImportOnly() throws WvcmException {
        String importOnlyInitArg = (String)this.thatProvider().initArgs().get("com.ibm.team.interop.IMPORT_ONLY");
        return importOnlyInitArg != null && Boolean.parseBoolean(importOnlyInitArg);
    }

    public String getBaselineFilter() throws WvcmException {
        return (String)this.thatProvider().initArgs().get("com.ibm.team.importer.BASELINE_ATTRIBUTE");
    }

    public void setBaselineFilter(String baselineFilter, Feedback feedback) throws WvcmException {
        HashMap<String, String> newInitArgs = new HashMap<String, String>();
        newInitArgs.put("com.ibm.team.importer.BASELINE_ATTRIBUTE", baselineFilter);
        this.updateThatInitArgs(newInitArgs, feedback);
    }

    public boolean isLocked(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        String reservedBy = InteropUtilities.doReadProperty((Resource)this.thatSyncStream(), InteropCore.PN_RESERVED_FOR_INTEROP, f.nest(50));
        if (reservedBy != null) {
            return true;
        }
        String reserved = InteropUtilities.doReadProperty((Resource)this.thisSyncStream(), InteropCore.PN_INTEROP_STREAM_LOCKED, f.nest(100));
        return reserved != null;
    }

    public void unlock(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.unreserveThatStream(f.nest(50));
        this.unreserveInteropStream(f.nest(100));
    }

    public void delete(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.thisSyncStream().doUnbindAll(f.nest(20));
        try {
            InteropUtilities.forceAbortWvcmException((Provider)this.thisProvider(), 24, f);
            this.thatSyncWs().doUnbindAll(f);
        }
        catch (WvcmException e) {
            f.notifyWarning(e.getLocalizedMessage());
        }
        f.notifyPercentComplete(100);
    }

    public InteropStream refresh(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        String interopStreamValue = InteropUtilities.doReadProperty((Resource)this.thisSyncStream(), InteropCore.PN_INTEROP_STREAM, f.nest(50));
        String[] field = interopStreamValue.split(TERMINATOR1_PAT, -1);
        long stateId = Long.parseLong(InteropStream.getStateIdField(field));
        if (stateId == this._stateId) {
            return this;
        }
        InteropStream result = InteropStream.parse(interopStreamValue, this.thisProvider().callback(), f);
        f.notifyPercentComplete(100);
        return result;
    }

    public void updateThisInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(25));
        try {
            this.thisSegment().putAll_initArgs(newInitArgs);
            this.updateISMetadata(f.nest(50));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void updateThatInitArgs(Map<String, String> newInitArgs, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(25));
        try {
            this.thatSegment().putAll_initArgs(newInitArgs);
            this.updateISMetadata(f.nest(50));
        }
        finally {
            this.unreserveInteropStream(f.nest(75));
            if (newInitArgs.containsKey("com.ibm.team.connector.scm.LINE_DELIMITER") || newInitArgs.containsKey("com.ibm.team.connector.scm.LINE_DELIMITER_WORKSPACE")) {
                this.newThatSyncWs(f.nest(100));
            }
        }
    }

    private void setInteropStreamState(Throwable e) throws WvcmException {
        if (!(e instanceof WvcmException)) {
            this.set_state(InteropCore.InteropStreamState.OPERATION_ERROR);
            throw new WvcmException("Runtime Error", null, WvcmException.ReasonCode.FORBIDDEN, e);
        }
        WvcmException we = (WvcmException)e;
        switch (we.getReasonCode()) {
            case CANNOT_MERGE_CHECKOUT_NOT_ALLOWED: {
                this.set_state(InteropCore.InteropStreamState.MERGE_NEEDED);
                break;
            }
            case ABORTED: {
                this.set_state(InteropCore.InteropStreamState.OPERATION_CANCELED);
                break;
            }
            default: {
                this.set_state(InteropCore.InteropStreamState.OPERATION_ERROR);
                throw we;
            }
        }
    }

    public void setSyncPending(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(25));
        try {
            this.internalSetSyncState(InteropCore.InteropStreamState.OPERATION_PENDING, f.nest(50));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void setSyncFailed(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(40));
        try {
            this.internalSetSyncState(InteropCore.InteropStreamState.OPERATION_ERROR, f.nest(60));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void newThatSyncStream(Stream thatStream, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.reserveInteropStream(nowork);
        try {
            this.thatSegment().set_syncStreamPath(thatStream.location().string());
            this.thatSegment().get_initArgs().put("com.ibm.team.interop.OTHER_STREAM_LOCATION", thatStream.location().string());
            String streamName = (String)InteropUtilities.doReadProperty((Resource)thatStream, Stream.DISPLAY_NAME, nowork);
            String wsName = this.createThatWorkspaceName(streamName, nowork);
            Workspace thatWs = this.newInteropStreamWs(wsName, this.thatSegment(), this.thatSyncWs(), false, this.thatSyncStream(), false, f.nest(50));
            this.thatSegment().set_syncWsPath(thatWs.location().string());
            List<ControllableResource> roots = this.thatSyncRoots(this.thatSyncWs(), f.nest(90));
            this.internalPostOperation(InteropCore.InteropStreamOperation.IMPORT, roots, nowork);
            this.deleteAllSyncRoots();
            this.updateISMetadata(nowork);
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void newThatSyncWs(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.reserveInteropStream(nowork);
        try {
            String streamName = (String)InteropUtilities.doReadProperty((Resource)this.thatSyncStream(), Stream.DISPLAY_NAME, nowork);
            String wsName = this.createThatWorkspaceName(streamName, f);
            Workspace ws = this.newInteropStreamWs(wsName, this.thatSegment(), this.thatSyncWs(), false, this.thatSyncStream(), this.isImportOnly(), f.nest(95));
            this.thatSegment().set_syncWsPath(ws.location().string());
            this.updateISMetadata(nowork);
        }
        finally {
            this.unreserveInteropStream(nowork);
            f.notifyPercentComplete(100);
        }
    }

    public void newThisCloneWs(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        Feedback nowork = f.nest();
        this.reserveInteropStream(nowork);
        try {
            String streamName = (String)InteropUtilities.doReadProperty((Resource)this.thatSyncStream(), Stream.DISPLAY_NAME, nowork);
            String wsName = f.format("INTERNAL_{0}", new Object[]{streamName});
            Workspace internalWs = this.newInteropStreamWs(wsName, this.thisSegment(), this.thisInternalWs(), false, this.thisSyncStream(), true, f.nest(InteropCore.PR_STREAM, 50));
            this.thisSegment().set_internalWsPath(internalWs.location().string());
            this.thisSegment().set_internalStreamPath(internalWs.getStream().location().string());
            wsName = f.format("CLONE_{0}", new Object[]{streamName});
            Workspace cloneWs = this.newInteropStreamWs(wsName, this.thisSegment(), this.thisCloneWs(), true, this.thisSyncStream(), true, f.nest(InteropCore.PR_STREAM, 95));
            this.thisSegment().set_cloneWsPath(cloneWs.location().string());
            this.thisSegment().set_cloneStreamPath(cloneWs.getStream().location().string());
            this.updateISMetadata(nowork);
            Workspace mergeWs = this.thisMergeWs();
            try {
                InteropUtilities.forceAbortWvcmException((Provider)this.thisProvider(), 25, f);
                mergeWs.setSourceList(InteropUtilities.makeList(this.thisCloneStream()));
                mergeWs.doWriteProperties(feedback);
            }
            catch (WvcmException wvcmException) {
                String mergeWsName = (String)InteropUtilities.doReadProperty((Resource)InteropUtilities.createNewProxy(mergeWs), Workspace.DISPLAY_NAME, nowork);
                f.notifyWarning(f.format(Messages.InteropStream_WARNING_CANNOT_UPDATE_MERGEWS, new Object[]{mergeWsName}));
            }
        }
        finally {
            this.unreserveInteropStream(nowork);
            f.notifyPercentComplete(100);
        }
    }

    public Workspace newThisMergeWs(String name, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        WorkspaceProvider thisP = this.thisProvider();
        Location loc = thisP.rootLocation().child(name);
        Workspace ws = thisP.workspace(loc);
        Stream stream = this.thisSyncStream();
        ws.setIsolatedTarget(stream);
        ResourceList streamList = thisP.resourceList((Resource[])new Stream[]{this.thisCloneStream()});
        ws.setSourceList(streamList);
        this.reserveInteropStream(f.nest(10));
        try {
            ws = ws.doCreateGeneratedResource(f.nest(50));
            this.thisSegment().put_initArgs("com.ibm.team.interop.MERGE_WORKSPACE", ws.getResourceIdentifier());
            this.updateISMetadata(f.nest(55));
            Workspace workspace = ws = ws.doUpdate(InteropUtilities.makeList(stream), f.nest(f.getPropertyRequestForResult(), 90));
            return workspace;
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void deleteThisSyncRoots(Collection<VersionHistory> thisSyncRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(10));
        try {
            this.internalDeleteSyncRoots(true, thisSyncRoots, f.nest(90));
            this.updateISMetadata(f.nest(95));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public void deleteThatSyncRoots(Collection<VersionHistory> thatSyncRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.reserveInteropStream(f.nest(10));
        try {
            this.internalDeleteSyncRoots(false, thatSyncRoots, f.nest(90));
            this.updateISMetadata(f.nest(95));
        }
        finally {
            this.unreserveInteropStream(f.nest(100));
        }
    }

    public InteropCore.SyncStats getThisSyncStats() throws WvcmException {
        return InteropCore.getSyncStats((Provider)this.thisProvider());
    }

    public InteropCore.SyncStats getThatSyncStats() throws WvcmException {
        return InteropCore.getSyncStats((Provider)this.thatProvider());
    }

    public void importCloneRoots(List<ControllableResource> thatRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropCore.InteropStreamOperation.IMPORT, thatRoots, f.nest(100));
    }

    public void importAppendCloneRoots(List<ControllableResource> thatRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postAppendOperation(InteropCore.InteropStreamOperation.IMPORT, thatRoots, f.nest(100));
    }

    public void exportCloneRoots(List<ControllableResource> thisRoots, Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropCore.InteropStreamOperation.EXPORT, thisRoots, f.nest(100));
    }

    public void sync(Feedback feedback) throws WvcmException {
        Feedback f = DetailedFeedback.fb((Feedback)feedback);
        this.postOperation(InteropCore.InteropStreamOperation.SYNCHRONIZE, null, f.nest(100));
    }

    public void doOperation(Feedback feedback) throws WvcmException {
        block18: {
            Feedback f = DetailedFeedback.fb((Feedback)feedback);
            Feedback nowork = f.nest();
            if (this._newSyncRoots.length == 0) {
                this._operation = InteropCore.InteropStreamOperation.SYNCHRONIZE;
            }
            InteropCore.clearInteropStats();
            String desyncVal = (String)this.thisProvider().initArgs().get("com.ibm.team.interop.DESYNC");
            if (desyncVal != null && !desyncVal.equals("")) {
                this.desync(desyncVal, f.nest(100));
                return;
            }
            f.notifyActive(f.format(Messages.InteropStream_MSG_STARTING, new Object[]{this._operation.get_name()}));
            this.thisSegment().clearProviderCache();
            this.thatSegment().clearProviderCache();
            if (this.isImportOnly()) {
                this.importStream(f.nest(100));
                return;
            }
            long syncDate = new Date().getTime();
            this.reserveInteropStream(nowork);
            try {
                InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 26, f);
                this.set_state(InteropCore.InteropStreamState.OPERATION_ACTIVE);
                this._lastAttemptedSyncDate = syncDate;
                this.updateISMetadata(nowork);
                this.cleanupThis(nowork);
                this.reserveThatStream(nowork);
            }
            catch (WvcmException e) {
                this.set_state(InteropCore.InteropStreamState.OPERATION_ERROR);
                this.updateISMetadata(f.nest(50));
                this.unreserveInteropStream(f.nest(100));
                throw e;
            }
            try {
                try {
                    InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 15, f);
                    this.cleanupThat(nowork);
                    if (this._newSyncRoots.length != 0) {
                        this.internalSync(f.nest(2));
                        this.addCloneRoots(f.nest(100));
                    } else {
                        this.updateISMetadata(nowork);
                        this.internalSync(f.nest(100));
                    }
                    this.thisSyncWs().doUpdate(InteropUtilities.makeList(this.thisSyncStream()), null);
                    this.set_state(InteropCore.InteropStreamState.OK);
                    this._lastSyncDate = syncDate;
                }
                catch (Throwable e) {
                    this.setInteropStreamState(e);
                    try {
                        InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 11, f);
                        this.updateISMetadata(nowork);
                    }
                    catch (Exception exception) {
                        f.notifyWarning(Messages.InteropStream_ERROR_METADATA_UPDATE_FAILED);
                    }
                    this.unreserveThatStream(nowork);
                    this.unreserveInteropStream(nowork);
                    f.notifyPercentComplete(100);
                    break block18;
                }
            }
            catch (Throwable throwable) {
                try {
                    InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 11, f);
                    this.updateISMetadata(nowork);
                }
                catch (Exception exception) {
                    f.notifyWarning(Messages.InteropStream_ERROR_METADATA_UPDATE_FAILED);
                }
                this.unreserveThatStream(nowork);
                this.unreserveInteropStream(nowork);
                f.notifyPercentComplete(100);
                throw throwable;
            }
            try {
                InteropUtilities.forceAbortWvcmException((Provider)this.thatProvider(), 11, f);
                this.updateISMetadata(nowork);
            }
            catch (Exception exception) {
                f.notifyWarning(Messages.InteropStream_ERROR_METADATA_UPDATE_FAILED);
            }
            this.unreserveThatStream(nowork);
            this.unreserveInteropStream(nowork);
            f.notifyPercentComplete(100);
        }
    }

    private static class C2BMapEntry {
        final boolean isOriginalEntry;
        final Baseline baseline;

        private C2BMapEntry(boolean isNewEntry, Baseline baseline) {
            this.isOriginalEntry = isNewEntry;
            this.baseline = baseline;
        }

        static C2BMapEntry createNewEntry(Baseline b) {
            return new C2BMapEntry(true, b);
        }

        static C2BMapEntry createUpdateEntry(Baseline b) {
            return new C2BMapEntry(false, b);
        }
    }

    public class Component2Baselines {
        private final Map<Component, C2BMapEntry> data;

        public Component2Baselines(Map<Component, Baseline> componentsAndBaselines) {
            int n = componentsAndBaselines.size();
            this.data = new LinkedHashMap<Component, C2BMapEntry>(n);
            for (Map.Entry<Component, Baseline> entry : componentsAndBaselines.entrySet()) {
                this.data.put(entry.getKey(), C2BMapEntry.createNewEntry(entry.getValue()));
            }
        }

        public String[] getBaselinePaths() throws WvcmException {
            int n = this.data.size();
            String[] results = new String[n];
            if (n > 0) {
                int i = 0;
                Set<Map.Entry<Component, C2BMapEntry>> es = this.data.entrySet();
                for (Map.Entry<Component, C2BMapEntry> entry : es) {
                    C2BMapEntry value = entry.getValue();
                    results[i++] = value.baseline.getResourceIdentifier();
                }
            }
            return results;
        }

        public boolean needsNewBaseline(Component c) {
            C2BMapEntry entry = this.data.get(c);
            return entry == null || entry.isOriginalEntry;
        }

        public void update(Component c, Baseline b) {
            this.data.put(c, C2BMapEntry.createUpdateEntry(b));
        }
    }
}

