/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.interop;

import com.ibm.rational.wvcm.interop.InteropCore;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.interop.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wvcm.ControllableResource;
import javax.wvcm.Feedback;
import javax.wvcm.FolderVersion;
import javax.wvcm.Resource;
import javax.wvcm.ResourceList;
import javax.wvcm.Version;
import javax.wvcm.VersionHistory;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;

public class SendoverData {
    public Workspace srcWorkspace;
    public Workspace tgtWorkspace;
    public Set<String> tgtRootPaths;
    public Map<VersionHistory, Version> tgtVh2srcVer;
    private Map<ControllableResource, Version> tgtCr2srcVer;
    public Map<VersionHistory, FolderVersion> tgtChildRemoved;
    public Map<VersionHistory, Version> srcVh2srcVer;
    public List<String> tgtProcessed;
    public List<String> tgtCreated;
    private List<Resource> clonesToUpdate;
    private Set<Resource> cloneSources;
    private Set<Resource> cloneTargets;
    private Feedback _f;
    private int _numToProcess;
    private int _numProcessed;
    public Map<ControllableResource, InteropCore.FilesToRestoreInfo> filesToRestoreInfo;

    public SendoverData(Workspace arg_tgtWorkspace, Set<String> arg_tgtRootPaths, ResourceList<Version> arg_srcChangedVersions, Workspace arg_srcWorkspace, Map<VersionHistory, Version> arg_srcVh2srcVer, Feedback arg_f) throws WvcmException {
        this.tgtWorkspace = arg_tgtWorkspace;
        this.tgtRootPaths = arg_tgtRootPaths;
        this.srcWorkspace = arg_srcWorkspace;
        this.srcVh2srcVer = arg_srcVh2srcVer;
        this.tgtVh2srcVer = InteropCore.computeTargetVh2SrcVerMap(this.tgtWorkspace.workspaceProvider(), arg_srcChangedVersions, this.srcWorkspace.workspaceProvider());
        this.tgtChildRemoved = new HashMap<VersionHistory, FolderVersion>();
        this.tgtProcessed = new ArrayList<String>();
        this.tgtCreated = new ArrayList<String>();
        this.tgtCr2srcVer = new HashMap<ControllableResource, Version>();
        this.clonesToUpdate = new ArrayList<Resource>();
        this.cloneSources = new HashSet<Resource>();
        this.cloneTargets = new HashSet<Resource>();
        this._f = arg_f;
        int n = this._numToProcess = this.srcVh2srcVer != null ? this.srcVh2srcVer.size() : arg_srcChangedVersions.size();
        if (this._numToProcess == 0) {
            this._numToProcess = 1;
        }
        this._numProcessed = 0;
        this.filesToRestoreInfo = new HashMap<ControllableResource, InteropCore.FilesToRestoreInfo>();
    }

    public void reportProgress() throws WvcmException {
        int oldPercentComplete = this._numProcessed * 100 / this._numToProcess;
        ++this._numProcessed;
        int percentComplete = this._numProcessed * 100 / this._numToProcess;
        if (percentComplete > 100) {
            percentComplete = 100;
        }
        this._f.notifyPercentComplete(percentComplete);
        if (percentComplete > oldPercentComplete) {
            this._f.notifyActive(this._f.format(Messages.InteropStream_MSG_PROGRESS, new Object[]{this._numProcessed, this._numToProcess}));
        }
    }

    public List<Resource> getClonesToUpdate() {
        return Collections.unmodifiableList(this.clonesToUpdate);
    }

    public void clearClonesToUpdate() {
        this.clonesToUpdate.clear();
        this.cloneSources.clear();
        this.cloneTargets.clear();
    }

    public int clonesToUpdateSize() {
        return this.clonesToUpdate.size();
    }

    public void updateThisClone(VersionHistory srcVH, VersionHistory tgtVH) throws WvcmException {
        if (this.cloneSources.contains(srcVH) || this.cloneTargets.contains(tgtVH)) {
            ControllableResource srcCR = InteropUtilities.doFindCRInWorkspace(this.srcWorkspace, srcVH, (Feedback)InteropCore.PR_PATH);
            String msg = this._f.format(Messages.InteropCore_WARNING_HARD_LINK_IGNORED, new Object[]{InteropUtilities.getFriendlyPathname((Resource)srcCR, 0, this._f)});
            this._f.notifyWarning(msg);
            return;
        }
        this.cloneSources.add((Resource)srcVH);
        this.cloneTargets.add((Resource)tgtVH);
        this.clonesToUpdate.add(InteropCore.initCloneLink((Resource)srcVH, (Resource)tgtVH, this._f));
    }

    public Map<ControllableResource, Version> getTgtCr2srcVer() {
        return Collections.unmodifiableMap(this.tgtCr2srcVer);
    }

    public void putTgtCr2srcVer(ControllableResource tgtCr, Version srcVer) throws WvcmException {
        if (this.tgtCr2srcVer.values().contains(srcVer)) {
            String msg = this._f.format(Messages.InteropCore_WARNING_HARD_LINK_IGNORED, new Object[]{tgtCr.location()});
            this._f.notifyWarning(msg);
            return;
        }
        this.tgtCr2srcVer.put(tgtCr, srcVer);
    }
}

