/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.impl;

import com.ibm.team.repository.common.internal.marshal.MarshalFactory;
import com.ibm.team.repository.common.internal.marshal.Marshaller;
import com.ibm.team.repository.common.internal.marshal.MarshallerType;
import com.ibm.team.repository.common.internal.marshal.MarshallingException;
import com.ibm.team.repository.common.internal.marshal.MarshallingExceptionReasonCode;
import com.ibm.team.repository.common.internal.marshal.impl.ComplexTypeMarshallerImpl;
import com.ibm.team.repository.common.internal.marshal.util.MarshallerUtil;
import com.ibm.team.repository.common.model.RepositoryPackage;
import com.ibm.team.repository.common.serialize.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;
import java.util.Map;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractEObjectMarshaller
extends ComplexTypeMarshallerImpl {
    protected static final String EMF_TYPE_NAME = "org.eclipse.emf.EObject";
    protected static final String EOBJECT_REGISTRATION_NAME = "org.eclipse.emf.ecore.EObject";
    protected static final String EXTENDED_METADATA_ANNOTATION = "http:///org/eclipse/emf/ecore/util/ExtendedMetaData";
    protected static final String NAME_ANNOTATION_KEY = "name";
    protected static final String NAMESPACE_ANNOTATION_KEY = "namespace";
    public static final String OPTION_SAVE_TYPE_INFORMATION = "SAVE_TYPE_INFORMATION";
    protected boolean saveTypeInformation = false;

    protected AbstractEObjectMarshaller(Class clazz, MarshallerType marshallerType) {
        this.setSupportedType(clazz);
        this.setMarshallerType(marshallerType);
    }

    protected AbstractEObjectMarshaller(Class clazz, MarshallerType marshallerType, Map options) {
        this.setSupportedType(clazz);
        this.setMarshallerType(marshallerType);
        if (Boolean.TRUE.equals(options.get(OPTION_SAVE_TYPE_INFORMATION))) {
            this.saveTypeInformation = true;
        }
    }

    @Override
    public String getRegistrationName() {
        return EOBJECT_REGISTRATION_NAME;
    }

    @Override
    public boolean canMarshal(Object object) {
        return object instanceof EObject;
    }

    @Override
    public boolean canMarshal(Class type) {
        return EObject.class.isAssignableFrom(type);
    }

    public boolean canMarshal(String typeName) throws MarshallingException {
        return typeName.equals(EMF_TYPE_NAME);
    }

    protected String getQualifiedEClassName(EClass eClass) {
        return this.getQualifiedEClassName(eClass, eClass.getEPackage().getNsURI());
    }

    @Deprecated
    protected String getQualifiedEClassName(EObject eObject) {
        return this.getQualifiedEClassName(eObject.eClass(), eObject.eClass().getEPackage().getNsURI());
    }

    protected String getQualifiedEClassName(EObject eObject, Map<String, String> nsURIToNsPrefixMap) {
        return this.getQualifiedEClassName(eObject.eClass(), nsURIToNsPrefixMap);
    }

    protected String getQualifiedEClassName(EClass eClass, Map<String, String> nsURIToNsPrefixMap) {
        String nsURI = eClass.getEPackage().getNsURI();
        String nsPrefix = nsURIToNsPrefixMap.get(nsURI);
        if (nsPrefix == null) {
            nsPrefix = eClass.getEPackage().getNsPrefix();
        }
        return this.getQualifiedEClassName(eClass, nsPrefix);
    }

    protected String getQualifiedEClassName(EClass eClass, String nsPrefix) {
        return String.valueOf(nsPrefix) + ':' + eClass.getName();
    }

    protected String getQualifieldEClassName(EObject eObject, String name) {
        return String.valueOf(eObject.eClass().getEPackage().getNsPrefix()) + ':' + name;
    }

    protected boolean shouldMarshalAsXMLAttribute(EAttribute attribute) {
        return attribute == RepositoryPackage.eINSTANCE.getItemHandle_ItemId();
    }

    protected boolean shouldAddTypeInformation(EObject eObject, String containingReferenceType, Map nsUriToNsPrefix) {
        String eObjectReferenceType = this.getQualifiedEClassName(eObject, (Map<String, String>)nsUriToNsPrefix);
        return this.saveTypeInformation || !eObjectReferenceType.equals(containingReferenceType);
    }

    protected boolean shouldBeMarshalled(EObject eObject, EStructuralFeature structuralFeature) {
        return MarshallerUtil.shouldBeMarshalled(eObject, structuralFeature);
    }

    protected String getStringValueUsingFactory(EObject eObject, EAttribute attribute, Object objectValue) {
        return eObject.eClass().getEPackage().getEFactoryInstance().convertToString(attribute.getEAttributeType(), objectValue);
    }

    protected String serializeEAttributeValue(EObject eObject, EAttribute attribute) throws MarshallingException {
        Object objectValue = eObject.eGet((EStructuralFeature)attribute);
        if (objectValue == null) {
            return null;
        }
        Class classZ = attribute.getEType().getInstanceClass();
        String attributeValueAsString = null;
        if (classZ == null) {
            attributeValueAsString = this.getStringValueUsingFactory(eObject, attribute, objectValue);
        } else {
            Marshaller marshaller = MarshalFactory.eINSTANCE.getMarshaller(classZ);
            if (marshaller != null) {
                attributeValueAsString = marshaller.marshalObjectToString(objectValue);
            } else if (attribute.getEType().getName().equals(Object.class.getSimpleName())) {
                attributeValueAsString = this.getStringValueUsingFactory(eObject, attribute, objectValue);
            } else {
                String message = this.createCannotMarshalAttributeMessage(eObject, attribute);
                throw new MarshallingException(MarshallingExceptionReasonCode.CANNOT_MARSHAL_LITERAL, message);
            }
        }
        return attributeValueAsString;
    }

    protected final String createCannotMarshalAttributeMessage(EObject eObject, EAttribute attribute) {
        Class classZ = attribute.getEType().getInstanceClass();
        String typeName = classZ == null ? attribute.getEType().getName() : classZ.getName();
        return NLS.bind((String)Messages.getServerString("AbstractEObjectMarshaller.MarshallerNotFound"), (Object)eObject.eClass().getName(), (Object[])new Object[]{attribute.getName(), typeName});
    }

    protected String getReferenceName(EObject eObject, EStructuralFeature structuralFeature) {
        if (structuralFeature.getEAnnotations().size() > 0) {
            String nameAnnotationValue = MarshallerUtil.getAnnotation(structuralFeature, EXTENDED_METADATA_ANNOTATION, NAME_ANNOTATION_KEY);
            String namespaceAnnotationValue = MarshallerUtil.getAnnotation(structuralFeature, EXTENDED_METADATA_ANNOTATION, NAMESPACE_ANNOTATION_KEY);
            if (nameAnnotationValue != null && namespaceAnnotationValue != null) {
                return this.getQualifieldEClassName(eObject, nameAnnotationValue);
            }
        }
        return structuralFeature.getName();
    }

    protected String createHREFs(EObject eObject, EReference reference) {
        EClassifier eClassifier = (EClassifier)eObject.eGet((EStructuralFeature)reference);
        StringBuffer hRefURI = new StringBuffer("href = \"");
        hRefURI.append(eClassifier.getEPackage().getNsURI());
        hRefURI.append("#//");
        hRefURI.append(eClassifier.getName());
        hRefURI.append("\"");
        return hRefURI.toString();
    }
}

