/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.links.common.internal;

import com.ibm.team.links.common.IReference;
import com.ibm.team.links.internal.links.Reference;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import java.net.URI;

public class ReferenceUtils {
    public static final ReferenceUtils INSTANCE = new ReferenceUtils();

    private ReferenceUtils() {
    }

    public void checkValidity(IReference reference) {
        Reference ref = (Reference)reference;
        if (ref == null) {
            throw new IllegalArgumentException("reference must not be null");
        }
        if (ref.isItemReference()) {
            if (!ref.isSetReferencedItem()) {
                throw new IllegalArgumentException("IItemReference.referencedItem is not set");
            }
            if (ref.getReferencedItem() == null) {
                throw new IllegalArgumentException("IItemReference.referencedItem is null");
            }
            if (ref.getReferencedItem().getItemId() == null) {
                throw new IllegalArgumentException("IItemReference.referencedItem.itemId is null");
            }
            if (ref.isSetUri() && ref.getUri() != null && !"".equals(ref.getUri())) {
                throw new IllegalArgumentException("Reference is to item, but also has URI");
            }
        } else if (ref.isURIReference()) {
            if (!ref.isSetUri()) {
                throw new IllegalArgumentException("IURIReference.uri is not set");
            }
            if (ref.getUri() == null) {
                throw new IllegalArgumentException("IURIReference.uri is null");
            }
            if (ref.getURI() == null) {
                throw new IllegalArgumentException("IURIReference.uri is not a URI");
            }
            if (ref.isSetReferencedItem() && ref.getReferencedItem() != null) {
                throw new IllegalArgumentException("Reference is a URI, but also has item handle");
            }
        } else {
            throw new IllegalArgumentException("Reference is of unknown type: " + (Object)((Object)ref.getReferenceType()));
        }
    }

    public Object resolveURI(URI u) {
        try {
            IItemHandle result = Location.location(u).getItemHandle();
            return result;
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public Object resolveURI(String uri) {
        return this.resolveURI(URI.create(uri));
    }
}

