/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.model.RepositoryFactory;
import com.ibm.team.repository.common.model.StringDTO;
import com.ibm.team.repository.common.util.NLS;

public final class NotLoggedInException
extends TeamRepositoryException {
    private static final long serialVersionUID = 1L;
    public static final String REPOSITORY_URL_KEY = NotLoggedInException.class + ".repositoryUrl";

    public NotLoggedInException(String repositoryUrl) {
        super(NLS.bind(Messages.getServerString("NotLoggedInException.ERROR_NOT_LOGGED_IN_URL"), repositoryUrl, new Object[0]));
        this.setExtraData(REPOSITORY_URL_KEY, this.createExtraDataDTO(repositoryUrl));
    }

    public NotLoggedInException() {
        super(Messages.getServerString("NotLoggedInException.ERROR_NOT_LOGGED_IN"));
    }

    public String getRepositoryUrl() {
        Object stringDTO = this.getExtraData(REPOSITORY_URL_KEY);
        if (stringDTO == null) {
            return null;
        }
        return ((StringDTO)stringDTO).getString();
    }

    private StringDTO createExtraDataDTO(String repositoryUrl) {
        StringDTO dto = RepositoryFactory.eINSTANCE.createStringDTO();
        dto.setString(repositoryUrl);
        return dto;
    }
}

