/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.content.util.tar;

import com.ibm.team.repository.common.internal.content.util.tar.ITarFileEntriesMap;
import com.ibm.team.repository.common.internal.content.util.tar.PartialTarFileEntriesMap;
import com.ibm.team.repository.common.internal.content.util.tar.TarEntry;
import com.ibm.team.repository.common.internal.content.util.tar.TarFileEntriesMap;
import com.ibm.team.repository.common.internal.content.util.tar.TarInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class TarFile {
    private final RandomAccessFile file;
    private final String name;
    private final ITarFileEntriesMap entries;
    private final Object lock = new Object();
    private final CountDownLatch allDone = new CountDownLatch(1);
    private IOException[] exception = new IOException[1];

    public TarFile(File f, EntryFilter filter, boolean contentOnly) throws IOException {
        this.file = new RandomAccessFile(f, "r");
        try {
            this.name = f.getPath();
            this.entries = this.createEntriesMap(contentOnly);
            RandomAccessFileInputStream entriesInputStream = new RandomAccessFileInputStream(this.file.getChannel(), 0L, this.file.length());
            this.entries.loadMapInBackground(entriesInputStream, this.lock, this.allDone, filter, this.exception);
        }
        catch (IOException e) {
            this.file.close();
            throw e;
        }
        catch (RuntimeException e) {
            this.file.close();
            throw e;
        }
    }

    public TarFile(File f, EntryFilter filter) throws IOException {
        this(f, filter, false);
    }

    public TarFile(File f) throws IOException {
        this(f, null);
    }

    public TarFile(String filename, EntryFilter filter) throws IOException {
        this(new File(filename), filter);
    }

    public TarFile(String filename) throws IOException {
        this(new File(filename));
    }

    protected ITarFileEntriesMap createEntriesMap(boolean partial) throws IOException {
        if (partial) {
            return new PartialTarFileEntriesMap(this.file.length());
        }
        return new TarFileEntriesMap(this.file.length());
    }

    public TarEntry getEntry(String name) throws IOException {
        boolean interruptedFlag = Thread.interrupted();
        try {
            TarEntry entry;
            do {
                if ((entry = this.getEntryFromMap(name)) == null) continue;
                TarEntry tarEntry = entry;
                return tarEntry;
            } while (!this.allDone.await(1L, TimeUnit.SECONDS));
            entry = this.getEntryFromMap(name);
            if (entry == null && this.exception[0] != null) {
                throw this.exception[0];
            }
            TarEntry tarEntry = entry;
            return tarEntry;
        }
        finally {
            if (interruptedFlag) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TarEntry getEntryFromMap(String name) {
        Object object = this.lock;
        synchronized (object) {
            TarEntry entry = this.entries.get(name);
            return entry;
        }
    }

    public InputStream getInputStream(TarEntry entry) throws IOException {
        return this.getInputStream(entry.getName());
    }

    public InputStream getInputStream(String name) throws IOException {
        TarEntry entry = this.getEntry(name);
        if (entry == null || !TarInputStream.hasContent(entry)) {
            return null;
        }
        return new RandomAccessFileInputStream(this.file.getChannel(), entry.getOffset(), entry.getOffset() + entry.getSize());
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        boolean interruptedFlag = Thread.interrupted();
        try {
            while (true) {
                try {
                    this.allDone.await();
                }
                catch (InterruptedException interruptedException) {
                    interruptedFlag = true;
                    continue;
                }
                break;
            }
            Object object = this.lock;
            synchronized (object) {
                int size;
                int n = size = this.entries.size();
                return n;
            }
        }
        finally {
            if (interruptedFlag) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void close() throws IOException {
        this.file.close();
    }

    public static interface EntryFilter {
        public boolean skipEntry(TarEntry var1);
    }

    private static class RandomAccessFileInputStream
    extends InputStream {
        private final FileChannel channel;
        private long offset;
        private final long maxOffset;
        private boolean closed;
        private final byte[] ONE_BYTE_BUF = new byte[1];

        public RandomAccessFileInputStream(FileChannel fileChannel, long startOffset, long maxOffset) {
            if (startOffset < 0L || maxOffset < 0L || startOffset > maxOffset) {
                throw new IllegalArgumentException();
            }
            this.channel = fileChannel;
            this.offset = startOffset;
            this.maxOffset = maxOffset;
        }

        @Override
        public int read() throws IOException {
            this.checkClosed();
            if (this.offset >= this.maxOffset) {
                return -1;
            }
            try {
                int bytesRead;
                ByteBuffer buf = ByteBuffer.wrap(this.ONE_BYTE_BUF);
                while ((bytesRead = this.channel.read(buf, this.offset)) == 0) {
                }
                if (bytesRead == -1) {
                    return -1;
                }
            }
            catch (InterruptedIOException e) {
                this.offset += (long)e.bytesTransferred;
                throw e;
            }
            ++this.offset;
            return this.ONE_BYTE_BUF[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead;
            block4: {
                this.checkClosed();
                if (this.offset >= this.maxOffset) {
                    return -1;
                }
                try {
                    ByteBuffer buf = ByteBuffer.wrap(b, off, (int)Math.min((long)len, this.maxOffset - this.offset));
                    bytesRead = this.channel.read(buf, this.offset);
                    if (bytesRead != -1) break block4;
                    return -1;
                }
                catch (InterruptedIOException e) {
                    this.offset += (long)e.bytesTransferred;
                    throw e;
                }
            }
            this.offset += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public int available() throws IOException {
            this.checkClosed();
            return (int)Math.min(Integer.MAX_VALUE, this.maxOffset - this.offset);
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
        }

        @Override
        public long skip(long n) throws IOException {
            this.checkClosed();
            if (n <= 0L) {
                return 0L;
            }
            long skipped = Math.min(n, this.maxOffset - this.offset);
            this.offset += skipped;
            return skipped;
        }

        private void checkClosed() throws IOException {
            if (this.closed) {
                throw new IOException("The stream has been closed");
            }
        }
    }
}

