/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.util;

import com.ibm.team.repository.common.IItemHandle;
import java.util.List;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EObjectUtil {
    public static boolean areEqual(EObject left, EObject right, boolean traverseAllReferences) {
        if (left.eClass() != right.eClass()) {
            return false;
        }
        for (EStructuralFeature feature : left.eClass().getEAllStructuralFeatures()) {
            boolean innerRecursive = feature instanceof EAttribute;
            if (feature instanceof EReference) {
                innerRecursive = ((EReference)feature).isContainment() ? true : traverseAllReferences;
            }
            Object leftValue = left.eGet(feature);
            Object rightValue = right.eGet(feature);
            if (feature.isMany() && leftValue instanceof List) {
                List leftList = (List)leftValue;
                List rightList = (List)rightValue;
                if (leftList.size() != rightList.size()) {
                    return false;
                }
                int i = 0;
                while (i < rightList.size()) {
                    Object rightItem;
                    Object leftItem = leftList.get(i);
                    if (!EObjectUtil.areEqual(leftItem, rightItem = rightList.get(i), innerRecursive, traverseAllReferences)) {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            if (EObjectUtil.areEqual(leftValue, rightValue, innerRecursive, traverseAllReferences)) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(Object left, Object right, boolean recursive, boolean traverseReferences) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        if (!recursive && left instanceof IItemHandle && right instanceof IItemHandle) {
            return ((IItemHandle)left).sameItemId((IItemHandle)right);
        }
        if (recursive && left instanceof EObject && right instanceof EObject) {
            EObject leftObject = (EObject)left;
            EObject rightObject = (EObject)right;
            return EObjectUtil.areEqual(leftObject, rightObject, traverseReferences);
        }
        return left.equals(right);
    }
}

