/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.oauth;

public class ServiceProviderInfo {
    private String realm;
    private String requestTokenURL;
    private String accessTokenURL;
    private String consumerKey;
    private String consumerSecret;

    public static ServiceProviderInfo createRegistration(String jtsBaseURL, String consumerKey, String consumerSecret) {
        return new ServiceProviderInfo(jtsBaseURL, consumerKey, consumerSecret);
    }

    private ServiceProviderInfo(String jtsBaseURL, String consumerKey, String consumerSecret) {
        if (jtsBaseURL == null) {
            throw new IllegalArgumentException("The jtsBaseURL cannot be null");
        }
        if (consumerKey == null) {
            throw new IllegalArgumentException("The consumer key cannot be null");
        }
        if (consumerSecret == null) {
            throw new IllegalArgumentException("The consumer secret cannot be null");
        }
        if (!jtsBaseURL.endsWith("/")) {
            jtsBaseURL = String.valueOf(jtsBaseURL) + "/";
        }
        this.realm = String.valueOf(jtsBaseURL) + "oauth/";
        this.requestTokenURL = String.valueOf(jtsBaseURL) + "oauth-request-token";
        this.accessTokenURL = String.valueOf(jtsBaseURL) + "oauth-access-token";
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
    }

    public String getRequestTokenURL() {
        return this.requestTokenURL;
    }

    public String getAccessTokenURL() {
        return this.accessTokenURL;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }
}

