/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.UUID;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ParameterConverter {
    protected static final Log logger = LogFactory.getLog(ParameterConverter.class);
    private static Map typeMap = new HashMap();

    static {
        typeMap.put(Byte.TYPE, ParameterConverter.getParameterConverterByte());
        typeMap.put(Short.TYPE, ParameterConverter.getParameterConverterShort());
        typeMap.put(Integer.TYPE, ParameterConverter.getParameterConverterInt());
        typeMap.put(Long.TYPE, ParameterConverter.getParameterConverterLong());
        typeMap.put(Character.TYPE, ParameterConverter.getParameterConverterChar());
        typeMap.put(Float.TYPE, ParameterConverter.getParameterConverterFloat());
        typeMap.put(Double.TYPE, ParameterConverter.getParameterConverterDouble());
        typeMap.put(Boolean.TYPE, ParameterConverter.getParameterConverterBoolean());
        typeMap.put(Byte.class, ParameterConverter.getParameterConverterByte());
        typeMap.put(Short.class, ParameterConverter.getParameterConverterShort());
        typeMap.put(Integer.class, ParameterConverter.getParameterConverterInt());
        typeMap.put(Long.class, ParameterConverter.getParameterConverterLong());
        typeMap.put(Character.class, ParameterConverter.getParameterConverterChar());
        typeMap.put(Float.class, ParameterConverter.getParameterConverterFloat());
        typeMap.put(Double.class, ParameterConverter.getParameterConverterDouble());
        typeMap.put(Boolean.class, ParameterConverter.getParameterConverterBoolean());
        typeMap.put(String.class, ParameterConverter.getParameterConverterString());
        typeMap.put(Timestamp.class, ParameterConverter.getParameterConverterTimestamp());
        typeMap.put(UUID.class, ParameterConverter.getParameterConverterUUID());
    }

    public static ParameterConverter getParameterConverterForClass(Class clazz) {
        return (ParameterConverter)typeMap.get(clazz);
    }

    public abstract Object convertToObject(Class<?> var1, String var2);

    public abstract String convertToString(Class<?> var1, Object var2);

    private static ParameterConverter getParameterConverterByte() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return new Byte(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterShort() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return new Short(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterInt() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return new Integer(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterLong() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return new Long(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterChar() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                if (param.length() == 0) {
                    return null;
                }
                return Character.valueOf(param.charAt(0));
            }
        };
    }

    private static ParameterConverter getParameterConverterFloat() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return new Float(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterDouble() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return new Double(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterBoolean() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return Boolean.valueOf(param);
            }
        };
    }

    private static ParameterConverter getParameterConverterString() {
        return new ParameterConverterWithToString(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return param;
            }
        };
    }

    private static ParameterConverter getParameterConverterTimestamp() {
        return new ParameterConverter(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                Long longValue = Long.valueOf(param);
                return new Timestamp(longValue);
            }

            @Override
            public String convertToString(Class<?> baseType, Object param) {
                if (param == null) {
                    return null;
                }
                return String.valueOf(((Timestamp)param).getTime());
            }
        };
    }

    private static ParameterConverter getParameterConverterUUID() {
        return new ParameterConverter(){

            @Override
            public Object convertToObject(Class<?> type, String param) {
                if (param == null) {
                    return null;
                }
                return UUID.valueOf(param);
            }

            @Override
            public String convertToString(Class<?> baseType, Object param) {
                if (param == null) {
                    return null;
                }
                return ((UUID)param).getUuidValue();
            }
        };
    }

    protected static abstract class ParameterConverterWithToString
    extends ParameterConverter {
        protected ParameterConverterWithToString() {
        }

        @Override
        public String convertToString(Class<?> baseType, Object param) {
            if (param == null) {
                return null;
            }
            return param.toString();
        }
    }
}

