/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.transport;

import com.ibm.team.repository.common.internal.nls.Messages;
import com.ibm.team.repository.common.util.NLS;

public class TeamServerConfiguration {
    public static final int DEFAULT_SOCKET_TIMEOUT = TeamServerConfiguration.getDefaultSocketTimeout(480000);
    private static final String PROPERTY_SOCKET_TIMEOUT = "com.ibm.team.repository.common.transport.TeamServerConfiguration.socketTimeout";
    private static final String PROPERTY_OLD_SOCKET_TIMEOUT = "com.ibm.team.TeanRepository.timeout.minutes";
    private int socketTimeout = DEFAULT_SOCKET_TIMEOUT;

    private static int getDefaultSocketTimeout(int defaultValue) {
        String valueString = System.getProperty(PROPERTY_SOCKET_TIMEOUT);
        if (valueString != null) {
            try {
                int valueInt = Integer.parseInt(valueString);
                if (valueInt >= -1) {
                    return valueInt;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((valueString = System.getProperty(PROPERTY_OLD_SOCKET_TIMEOUT)) != null) {
            String msg = NLS.bind(Messages.getServerString("TeamServerConfiguration.ErrorDeprecatedSystemProperty"), PROPERTY_OLD_SOCKET_TIMEOUT, PROPERTY_SOCKET_TIMEOUT);
            System.err.println(msg);
            try {
                int valueInt = Integer.parseInt(valueString);
                if (valueInt >= -1) {
                    return valueInt * 60 * 1000;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return defaultValue;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public TeamServerConfiguration setSocketTimeout(int value) {
        if (value < -1) {
            throw new IllegalArgumentException();
        }
        this.socketTimeout = value;
        return this;
    }
}

