/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.common.internal.marshal.util;

public class NumberHelper {
    private static IllegalArgumentException createIllegalArgumentException(Class claz) {
        return new IllegalArgumentException("The value cannot be converted to an " + claz.getName());
    }

    public static int getInteger(Object value) throws IllegalArgumentException {
        int rValue;
        if (value instanceof Number) {
            rValue = ((Number)value).intValue();
        } else if (value instanceof String) {
            rValue = Integer.parseInt((String)value);
        } else {
            throw NumberHelper.createIllegalArgumentException(Integer.TYPE);
        }
        return rValue;
    }

    public static long getLong(Object value) throws IllegalArgumentException {
        long rValue;
        if (value instanceof Number) {
            rValue = ((Number)value).longValue();
        } else if (value instanceof String) {
            rValue = Long.parseLong((String)value);
        } else {
            throw NumberHelper.createIllegalArgumentException(Long.TYPE);
        }
        return rValue;
    }

    public static short getShort(Object value) throws IllegalArgumentException {
        short rValue;
        if (value instanceof Number) {
            rValue = ((Number)value).shortValue();
        } else if (value instanceof String) {
            rValue = Short.parseShort((String)value);
        } else {
            throw NumberHelper.createIllegalArgumentException(Short.TYPE);
        }
        return rValue;
    }

    public static float getFloat(Object value) throws IllegalArgumentException {
        float rValue;
        if (value instanceof Number) {
            rValue = ((Number)value).floatValue();
        } else if (value instanceof String) {
            rValue = Float.parseFloat((String)value);
        } else {
            throw NumberHelper.createIllegalArgumentException(Float.TYPE);
        }
        return rValue;
    }

    public static double getDouble(Object value) throws IllegalArgumentException {
        double rValue;
        if (value instanceof Number) {
            rValue = ((Number)value).doubleValue();
        } else if (value instanceof String) {
            rValue = Double.parseDouble((String)value);
        } else {
            throw NumberHelper.createIllegalArgumentException(Float.TYPE);
        }
        return rValue;
    }

    public static byte getByte(Object value) throws IllegalArgumentException {
        byte rValue;
        if (value instanceof Number) {
            rValue = ((Number)value).byteValue();
        } else if (value instanceof String) {
            rValue = Byte.parseByte((String)value);
        } else {
            throw NumberHelper.createIllegalArgumentException(Float.TYPE);
        }
        return rValue;
    }
}

