/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.providers.entity;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.wink.common.internal.MultivaluedMapImpl;
import org.apache.wink.common.internal.uri.UriEncoder;
import org.apache.wink.common.internal.utils.UriHelper;
import org.apache.wink.common.utils.ProviderUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class FormMultivaluedMapProvider
implements MessageBodyWriter<MultivaluedMap<String, ? extends Object>>,
MessageBodyReader<MultivaluedMap<String, String>> {
    @Override
    public long getSize(MultivaluedMap<String, ? extends Object> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultivaluedMap.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(MultivaluedMap<String, ? extends Object> t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        String string = MultivaluedMapImpl.toString(t, "&");
        string = UriEncoder.encodeQuery(string, true);
        ProviderUtils.writeToStream(string, entityStream, mediaType);
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (MultivaluedMap.class != type || !(genericType instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType pType = (ParameterizedType)genericType;
        Type[] actualTypeArguments = pType.getActualTypeArguments();
        Type type1 = actualTypeArguments[0];
        Type type2 = actualTypeArguments[1];
        return type1 instanceof Class && ((Class)type1).equals(String.class) && type2 instanceof Class && ((Class)type2).equals(String.class);
    }

    @Override
    public MultivaluedMap<String, String> readFrom(Class<MultivaluedMap<String, String>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        MultivaluedMapImpl<String, String> map = new MultivaluedMapImpl();
        String string = ProviderUtils.readFromStreamAsString(entityStream, mediaType);
        map = UriHelper.parseQuery(string);
        return map;
    }
}

