/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.core.query.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.lyo.core.query.InTerm;
import org.eclipse.lyo.core.query.SimpleTerm;
import org.eclipse.lyo.core.query.Value;
import org.eclipse.lyo.core.query.impl.ComparisonTermInvocationHandler;
import org.eclipse.lyo.core.query.impl.SimpleTermInvocationHandler;

class InTermInvocationHandler
extends SimpleTermInvocationHandler {
    private List<Value> values = null;

    public InTermInvocationHandler(CommonTree tree, Map<String, String> prefixMap) {
        super(tree, SimpleTerm.Type.IN_TERM, prefixMap);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        boolean isValues = methodName.equals("values");
        if (!isValues && !methodName.equals("toString")) {
            return super.invoke(proxy, method, args);
        }
        if (this.values == null) {
            List treeValues = ((CommonTree)this.tree.getChild(1)).getChildren();
            this.values = new ArrayList<Value>(treeValues.size() - 1);
            for (CommonTree treeValue : treeValues) {
                Value value = ComparisonTermInvocationHandler.createValue(treeValue, "unspported literal value type", this.prefixMap);
                this.values.add(value);
            }
            this.values = Collections.unmodifiableList(this.values);
        }
        if (isValues) {
            return this.values;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(((InTerm)proxy).property().toString());
        buffer.append(" in [");
        boolean first = true;
        for (Value value : this.values) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            buffer.append(value.toString());
        }
        buffer.append(']');
        return buffer.toString();
    }
}

