/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.apache.wink.client.ClientResponse;
import org.eclipse.lyo.oslc4j.client.OslcRestClient;
import org.eclipse.lyo.oslc4j.client.ServiceProviderRegistryURIs;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreApplicationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreDeregistrationException;
import org.eclipse.lyo.oslc4j.core.exception.OslcCoreRegistrationException;
import org.eclipse.lyo.oslc4j.core.model.CreationFactory;
import org.eclipse.lyo.oslc4j.core.model.QueryCapability;
import org.eclipse.lyo.oslc4j.core.model.Service;
import org.eclipse.lyo.oslc4j.core.model.ServiceProvider;
import org.eclipse.lyo.oslc4j.core.model.ServiceProviderCatalog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServiceProviderRegistryClient {
    private final OslcRestClient client;

    public ServiceProviderRegistryClient(Set<Class<?>> providers, String mediaType, String uri) {
        this.client = new OslcRestClient(providers, uri, mediaType);
    }

    public ServiceProviderRegistryClient(Set<Class<?>> providers, String mediaType) {
        this(providers, mediaType, ServiceProviderRegistryURIs.getServiceProviderRegistryURI());
    }

    public ServiceProviderRegistryClient(Set<Class<?>> providers) {
        this(providers, "application/rdf+xml");
    }

    public URI registerServiceProvider(ServiceProvider serviceProviderToRegister) throws OslcCoreApplicationException, URISyntaxException {
        ServiceProvider[] serviceProviders;
        URI typeServiceProviderURI = new URI("http://open-services.net/ns/core#ServiceProvider");
        URI oslcUsageDefault = new URI("http://open-services.net/ns/core#default");
        ServiceProviderCatalog serviceProviderCatalog = this.getServiceProviderCatalog();
        if (serviceProviderCatalog != null) {
            serviceProviders = serviceProviderCatalog.getServiceProviders();
        } else {
            ServiceProvider serviceProvider = this.getServiceProvider();
            if (serviceProvider != null) {
                serviceProviders = new ServiceProvider[]{serviceProvider};
            } else {
                throw new OslcCoreRegistrationException(serviceProviderToRegister, 404, "ServiceProviderCatalog");
            }
        }
        if (serviceProviders != null) {
            CreationFactory firstCreationFactory = null;
            CreationFactory firstDefaultCreationFactory = null;
            for (int serviceProviderIndex = 0; serviceProviderIndex < serviceProviders.length && firstDefaultCreationFactory == null; ++serviceProviderIndex) {
                ServiceProvider serviceProvider = serviceProviders[serviceProviderIndex];
                Service[] services = serviceProvider.getServices();
                if (services == null) continue;
                for (int serviceIndex = 0; serviceIndex < services.length && firstDefaultCreationFactory == null; ++serviceIndex) {
                    Service service = services[serviceIndex];
                    CreationFactory[] creationFactories = service.getCreationFactories();
                    if (creationFactories == null) continue;
                    for (int creationFactoryIndex = 0; creationFactoryIndex < creationFactories.length && firstDefaultCreationFactory == null; ++creationFactoryIndex) {
                        CreationFactory creationFactory = creationFactories[creationFactoryIndex];
                        URI[] resourceTypes = creationFactory.getResourceTypes();
                        if (resourceTypes == null) continue;
                        for (int resourceTypeIndex = 0; resourceTypeIndex < resourceTypes.length && firstDefaultCreationFactory == null; ++resourceTypeIndex) {
                            URI resourceType = resourceTypes[resourceTypeIndex];
                            if (!typeServiceProviderURI.equals(resourceType)) continue;
                            if (firstCreationFactory == null) {
                                firstCreationFactory = creationFactory;
                            }
                            URI[] usages = creationFactory.getUsages();
                            for (int usageIndex = 0; usageIndex < usages.length && firstDefaultCreationFactory == null; ++usageIndex) {
                                URI usage = usages[usageIndex];
                                if (!oslcUsageDefault.equals(usage)) continue;
                                firstDefaultCreationFactory = creationFactory;
                            }
                        }
                    }
                }
            }
            if (firstCreationFactory != null) {
                CreationFactory creationFactory = firstDefaultCreationFactory != null ? firstDefaultCreationFactory : firstCreationFactory;
                URI creation = creationFactory.getCreation();
                OslcRestClient oslcRestClient = new OslcRestClient(this.client.getProviders(), creation);
                ClientResponse clientResponse = oslcRestClient.addOslcResourceReturnClientResponse(serviceProviderToRegister);
                int statusCode = clientResponse.getStatusCode();
                if (statusCode != 201) {
                    throw new OslcCoreRegistrationException(serviceProviderToRegister, statusCode, clientResponse.getMessage());
                }
                String location = clientResponse.getHeaders().getFirst("Location");
                return new URI(location);
            }
        }
        throw new OslcCoreRegistrationException(serviceProviderToRegister, 404, "CreationFactory");
    }

    public void deregisterServiceProvider(URI serviceProviderURI) throws OslcCoreApplicationException {
        ClientResponse clientResponse = this.client.getClientResource().uri(serviceProviderURI).delete();
        int statusCode = clientResponse.getStatusCode();
        if (statusCode != 200) {
            throw new OslcCoreDeregistrationException(serviceProviderURI, statusCode, clientResponse.getMessage());
        }
    }

    public ServiceProviderCatalog getServiceProviderCatalog() {
        return this.client.getOslcResource(ServiceProviderCatalog.class);
    }

    public ServiceProvider getServiceProvider() {
        return this.client.getOslcResource(ServiceProvider.class);
    }

    public ServiceProvider[] getServiceProviders() {
        Service[] services;
        ServiceProviderCatalog serviceProviderCatalog = this.getServiceProviderCatalog();
        if (serviceProviderCatalog != null) {
            return serviceProviderCatalog.getServiceProviders();
        }
        ServiceProvider serviceProvider = this.getServiceProvider();
        if (serviceProvider != null && (services = serviceProvider.getServices()) != null) {
            QueryCapability firstQueryCapability = null;
            QueryCapability firstDefaultQueryCapability = null;
            for (int serviceIndex = 0; serviceIndex < services.length && firstDefaultQueryCapability == null; ++serviceIndex) {
                Service service = services[serviceIndex];
                QueryCapability[] queryCapabilities = service.getQueryCapabilities();
                if (queryCapabilities == null) continue;
                for (int queryCapabilityIndex = 0; queryCapabilityIndex < queryCapabilities.length && firstDefaultQueryCapability == null; ++queryCapabilityIndex) {
                    QueryCapability queryCapability = queryCapabilities[queryCapabilityIndex];
                    URI[] resourceTypes = queryCapability.getResourceTypes();
                    if (resourceTypes == null) continue;
                    for (int resourceTypeIndex = 0; resourceTypeIndex < resourceTypes.length && firstDefaultQueryCapability == null; ++resourceTypeIndex) {
                        URI resourceType = resourceTypes[resourceTypeIndex];
                        if (!"http://open-services.net/ns/core#ServiceProvider".equals(String.valueOf(resourceType))) continue;
                        if (firstQueryCapability == null) {
                            firstQueryCapability = queryCapability;
                        }
                        URI[] usages = queryCapability.getUsages();
                        for (int usageIndex = 0; usageIndex < usages.length && firstDefaultQueryCapability == null; ++usageIndex) {
                            URI usage = usages[usageIndex];
                            if (!"http://open-services.net/ns/core#default".equals(String.valueOf(usage))) continue;
                            firstDefaultQueryCapability = queryCapability;
                        }
                    }
                }
            }
            if (firstQueryCapability != null) {
                QueryCapability queryCapability = firstDefaultQueryCapability != null ? firstDefaultQueryCapability : firstQueryCapability;
                URI queryBase = queryCapability.getQueryBase();
                String query2 = queryBase.toString() + "?oslc.select=*";
                OslcRestClient oslcRestClient = new OslcRestClient(this.client.getProviders(), query2);
                return (ServiceProvider[])oslcRestClient.getOslcResources(ServiceProvider[].class);
            }
        }
        return null;
    }

    public OslcRestClient getClient() {
        return this.client;
    }
}

