/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.oslc4j.provider.jena;

import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFErrorHandler;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.RSIterator;
import com.hp.hpl.jena.rdf.model.ReifiedStatement;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.rdf.model.impl.Util;
import com.hp.hpl.jena.util.CharEncoding;
import com.hp.hpl.jena.util.FileUtils;
import com.hp.hpl.jena.util.iterator.Filter;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RdfXmlAbbreviatedWriter
implements RDFWriter {
    private final Map<AnonId, String> resourceIdToShortIdMap = new HashMap<AnonId, String>();
    private int shortIdCounter = 0;
    private Boolean showXmlDeclaration = null;
    private int indent = 0;
    private int tab = 2;
    private RDFErrorHandler errorHandler = null;
    private static String RDF_PROPERTY_SHOW_XML_DECLARATION = "showXmlDeclaration";
    private static String RDF_PROPERTY_INDENT = "indent";
    private static String RDF_PROPERTY_TAB = "tab";
    private static String RDF_ELEMENT_RDF = "RDF";
    private static String RDF_ELEMENT_DESCRIPTION = "Description";
    private static String RDF_ATTRIBUTE_ABOUT = "about";
    private static String RDF_ATTRIBUTE_ID = "ID";
    private static String RDF_ATTRIBUTE_RESOURCE = "resource";
    private static String RDF_ATTRIBUTE_LANG = "lang";
    private static String RDF_ATTRIBUTE_PARSE_TYPE = "parseType";
    private static String RDF_ATTRIBUTE_DATATYPE = "datatype";
    private static String RDF_CONSTANT_LITERAL = "Literal";
    private static String RDF_CONSTANT_RESOURCE = "Resource";
    private static final Logger logger = Logger.getLogger(RdfXmlAbbreviatedWriter.class.getName());
    private static String XML_DECLARATION_ENCODING = "<?xml version=\"1.0\" encoding=\"{0}\"?>";
    private static String ENCODING_UTF8 = "UTF-8";
    private static String ENCODING_UTF16 = "UTF-16";
    private static String NAMESPACE_URI_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static String NAMESPACE_URI_XML = "http://www.w3.org/XML/1998/namespace";
    private static String PREFIX_XMLNS = "xmlns";
    private static String PREFIX_RDF = "rdf";

    @Override
    public Object setProperty(String propName, Object propValue) {
        String oldPropertyValue;
        block20: {
            oldPropertyValue = null;
            if (RDF_PROPERTY_SHOW_XML_DECLARATION.equals(propName)) {
                if (this.showXmlDeclaration != null) {
                    oldPropertyValue = String.valueOf(this.showXmlDeclaration);
                }
                if (propValue instanceof Boolean) {
                    this.showXmlDeclaration = (Boolean)propValue;
                } else if (propValue instanceof String) {
                    this.showXmlDeclaration = Boolean.valueOf((String)propValue);
                }
            } else if (RDF_PROPERTY_TAB.equals(propName)) {
                oldPropertyValue = String.valueOf(this.tab);
                if (propValue instanceof Integer) {
                    this.tab = (Integer)propValue;
                } else if (propValue instanceof String) {
                    try {
                        this.tab = Integer.valueOf((String)propValue);
                    }
                    catch (NumberFormatException n) {
                        if (this.errorHandler != null) {
                            this.errorHandler.warning(n);
                        }
                    }
                }
            } else if (RDF_PROPERTY_INDENT.equals(propName)) {
                oldPropertyValue = String.valueOf(this.indent);
                if (propValue instanceof Integer) {
                    this.indent = (Integer)propValue;
                } else if (propValue instanceof String) {
                    try {
                        this.indent = Integer.valueOf((String)propValue);
                    }
                    catch (NumberFormatException n) {
                        if (this.errorHandler == null) break block20;
                        this.errorHandler.warning(n);
                    }
                }
            }
        }
        return oldPropertyValue;
    }

    @Override
    public RDFErrorHandler setErrorHandler(RDFErrorHandler errorHandler) {
        RDFErrorHandler oldErrorHandler = this.errorHandler;
        this.errorHandler = errorHandler;
        return oldErrorHandler;
    }

    @Override
    public void write(Model model, OutputStream out, String base) {
        this.write(model, FileUtils.asUTF8(out), base);
    }

    @Override
    public void write(Model model, Writer writer, String base) {
        XMLWriter xmlWriter = new XMLWriter(writer, model, this.indent, this.tab);
        if (this.showXmlDeclaration == null || Boolean.TRUE.equals(this.showXmlDeclaration)) {
            String writerEncoding;
            String encoding = null;
            if (writer instanceof OutputStreamWriter && !(writerEncoding = ((OutputStreamWriter)writer).getEncoding()).equals(ENCODING_UTF8) && !writerEncoding.equals(ENCODING_UTF16)) {
                encoding = CharEncoding.create(writerEncoding).name();
            }
            if (encoding != null || Boolean.TRUE.equals(this.showXmlDeclaration)) {
                xmlWriter.xmlDeclaration(encoding);
            }
        }
        xmlWriter.rootStartTag(RDF.getURI(), RDF_ELEMENT_RDF);
        Filter<Statement> filter = new Filter<Statement>(){

            @Override
            public boolean accept(Statement statement) {
                Property predicate = statement.getPredicate();
                return !statement.isReified() && statement.getObject().isResource() && !RDF.subject.equals(predicate) && !RDF.predicate.equals(predicate) && !RDF.object.equals(predicate);
            }
        };
        ArrayList<Resource> objects = new ArrayList<Resource>();
        StmtIterator statementIterator = model.listStatements().filterKeep(filter);
        while (statementIterator.hasNext()) {
            Statement stmt = (Statement)statementIterator.next();
            logger.finest("Added model object: " + ((Object)stmt.getSubject()).toString() + " " + stmt.getPredicate().toString() + " " + ((Object)stmt.getObject()).toString());
            Resource resource = stmt.getObject().asResource();
            if (objects.contains(resource)) continue;
            objects.add(resource);
        }
        ArrayList<Resource> rootResources = new ArrayList<Resource>();
        statementIterator = model.listStatements();
        while (statementIterator.hasNext()) {
            Resource subject = ((Statement)statementIterator.next()).getSubject();
            if (objects.contains(subject) && subject.isAnon() || rootResources.contains(subject)) continue;
            rootResources.add(subject);
            logger.finest("Added proposed root: " + subject.getURI());
        }
        HashSet<Resource> removalCandidates = new HashSet<Resource>();
        HashSet<Resource> rootTestAgainst = new HashSet<Resource>();
        rootTestAgainst.addAll(rootResources);
        rootTestAgainst.addAll(objects);
        for (Resource rootCandidate : rootResources) {
            logger.finest("validating root candidate: " + ((Object)rootCandidate).toString());
            for (Resource rootTest : rootTestAgainst) {
                logger.finest("testing against resource: " + ((Object)rootTest).toString());
                if (((Object)rootTest).equals(rootCandidate)) continue;
                boolean rootCandidateIsObject = model.listStatements(rootTest, null, rootCandidate).hasNext();
                boolean objectIsReification = model.listStatements(rootTest, RDF.type, RDF.Statement).hasNext();
                if (!rootCandidateIsObject || objectIsReification) continue;
                removalCandidates.add(rootCandidate);
                logger.finest("removed: " + ((Object)rootCandidate).toString());
            }
        }
        if (removalCandidates.size() != rootResources.size()) {
            rootResources.removeAll(removalCandidates);
        }
        ArrayList<Resource> serializedResources = new ArrayList<Resource>();
        for (Resource rootResource : rootResources) {
            if (rootResource.canAs(ReifiedStatement.class) || serializedResources.contains(rootResource)) continue;
            serializedResources.add(rootResource);
            String rootResourceNameSpace = RDF.getURI();
            String rootResourceName = RDF_ELEMENT_DESCRIPTION;
            Statement rootResourceType = rootResource.getProperty(RDF.type);
            if (rootResourceType != null) {
                Resource rootResourceTypeResource = (Resource)rootResourceType.getObject();
                rootResourceNameSpace = rootResourceTypeResource.getNameSpace();
                rootResourceName = rootResourceTypeResource.getLocalName();
            }
            xmlWriter.startTag(rootResourceNameSpace, rootResourceName, true);
            if (!rootResource.isAnon()) {
                xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_ABOUT, Util.substituteEntitiesInElementContent(rootResource.getURI()));
            }
            xmlWriter.closeStartTag(true);
            this.serializeStatements(rootResource, xmlWriter, serializedResources);
            xmlWriter.endTag(rootResourceNameSpace, rootResourceName, true);
        }
        RSIterator reifiedStatementsIterator = model.listReifiedStatements();
        while (reifiedStatementsIterator.hasNext()) {
            Resource reifiedStatement = (Resource)reifiedStatementsIterator.next();
            xmlWriter.startTag(RDF.getURI(), RDF_ELEMENT_DESCRIPTION, true);
            if (reifiedStatement.isAnon()) {
                xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_ABOUT, '#' + this.getShortId(reifiedStatement.getId()));
            } else {
                xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_ABOUT, Util.substituteEntitiesInElementContent(reifiedStatement.getURI()));
            }
            xmlWriter.closeStartTag(true);
            this.serializeStatements(reifiedStatement, xmlWriter, serializedResources);
            xmlWriter.endTag(RDF.getURI(), RDF_ELEMENT_DESCRIPTION, true);
        }
        xmlWriter.rootEndTag(RDF.getURI(), RDF_ELEMENT_RDF, true);
        xmlWriter.end();
    }

    private void serializeStatements(Resource resource, XMLWriter xmlWriter, List<Resource> serializedResources) {
        StmtIterator statementIterator = resource.getModel().listStatements(resource, null, (RDFNode)null);
        HashSet<Statement> visitedStatements = new HashSet<Statement>();
        while (statementIterator.hasNext()) {
            this.serializeStatement((Statement)statementIterator.next(), xmlWriter, serializedResources, visitedStatements);
        }
    }

    private void serializeStatement(Statement statement, XMLWriter xmlWriter, List<Resource> serializedResources, Set<Statement> visitedStatements) {
        visitedStatements.add(statement);
        Model model = statement.getModel();
        Property predicate = statement.getPredicate();
        if (!(RDF.type.equals(predicate) || RDF.subject.equals(predicate) || RDF.predicate.equals(predicate) || RDF.object.equals(predicate))) {
            RDFNode object = statement.getObject();
            if (object.isResource()) {
                xmlWriter.startTag(predicate.getNameSpace(), predicate.getLocalName(), true);
                if (statement.isReified()) {
                    RSIterator reifiedStatementsIterator = model.listReifiedStatements(statement);
                    String reifiedStatementShortId = this.getShortId(((ReifiedStatement)reifiedStatementsIterator.next()).getId());
                    while (reifiedStatementsIterator.hasNext()) {
                        AnonId reifiedStatementId = ((ReifiedStatement)reifiedStatementsIterator.next()).getId();
                        if (this.resourceIdToShortIdMap.containsKey(reifiedStatementId)) continue;
                        this.resourceIdToShortIdMap.put(reifiedStatementId, reifiedStatementShortId);
                    }
                    xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_ID, reifiedStatementShortId);
                }
                if (predicate.isAnon() && predicate.getProperty(RDF.type) == null) {
                    xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_PARSE_TYPE, RDF_CONSTANT_RESOURCE);
                }
                Resource resource = object.asResource();
                StmtIterator statementIterator = model.listStatements(resource, null, (RDFNode)null);
                Statement firstResourceStatement = null;
                List statementList = null;
                if (statementIterator.hasNext()) {
                    statementList = statementIterator.toList();
                    firstResourceStatement = (Statement)statementList.get(0);
                }
                if (firstResourceStatement != null && !visitedStatements.contains(firstResourceStatement) && serializedResources.add(resource)) {
                    xmlWriter.closeStartTag(true);
                    String resourceNameSpace = RDF.getURI();
                    String resourceName = RDF_ELEMENT_DESCRIPTION;
                    Statement resourceType = resource.getProperty(RDF.type);
                    if (resourceType != null) {
                        Resource resourceTypeResource = (Resource)resourceType.getObject();
                        resourceNameSpace = resourceTypeResource.getNameSpace();
                        resourceName = resourceTypeResource.getLocalName();
                    }
                    xmlWriter.startTag(resourceNameSpace, resourceName, true);
                    if (!resource.isAnon()) {
                        xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_ABOUT, Util.substituteEntitiesInElementContent(resource.getURI()));
                    }
                    xmlWriter.closeStartTag(true);
                    for (Statement nextStatement : statementList) {
                        this.serializeStatement(nextStatement, xmlWriter, serializedResources, visitedStatements);
                    }
                    xmlWriter.endTag(resourceNameSpace, resourceName, true);
                    xmlWriter.endTag(predicate.getNameSpace(), predicate.getLocalName(), true);
                } else {
                    if (!resource.isAnon()) {
                        xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_RESOURCE, Util.substituteEntitiesInElementContent(resource.getURI()));
                    }
                    xmlWriter.closeEmptyStartTag();
                }
            } else {
                Literal literal = (Literal)object;
                xmlWriter.startTag(predicate.getNameSpace(), predicate.getLocalName(), true);
                String language = literal.getLanguage();
                if (language != null && language.length() > 0) {
                    xmlWriter.attribute(NAMESPACE_URI_XML, RDF_ATTRIBUTE_LANG, Util.substituteEntitiesInElementContent(language));
                }
                String content = literal.getLexicalForm();
                if (literal.isWellFormedXML()) {
                    xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_PARSE_TYPE, RDF_CONSTANT_LITERAL);
                    xmlWriter.closeStartTag(false);
                    xmlWriter.literal(content);
                } else {
                    String dataTypeUri = literal.getDatatypeURI();
                    if (dataTypeUri != null) {
                        xmlWriter.attribute(RDF.getURI(), RDF_ATTRIBUTE_DATATYPE, Util.substituteEntitiesInElementContent(dataTypeUri));
                    }
                    xmlWriter.closeStartTag(false);
                    xmlWriter.literal(Util.substituteEntitiesInElementContent(content));
                }
                xmlWriter.endTag(predicate.getNameSpace(), predicate.getLocalName(), false);
            }
        }
    }

    private String getShortId(AnonId resourceId) {
        String shortId = this.resourceIdToShortIdMap.get(resourceId);
        if (shortId == null) {
            shortId = 'n' + String.valueOf(this.shortIdCounter++);
            this.resourceIdToShortIdMap.put(resourceId, shortId);
        }
        return shortId;
    }

    private class XMLWriter {
        private final PrintWriter printWriter;
        private final Map<String, String> namespaceMap;
        private final int indent;
        private final int tab;
        private int tabCount = 0;

        public XMLWriter(Writer writer, Model model, int indent, int tab) {
            this.printWriter = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
            this.namespaceMap = new HashMap<String, String>();
            Map<String, String> modelNamespacePrefixMap = model.getNsPrefixMap();
            for (Map.Entry<String, String> namespaceEntry : modelNamespacePrefixMap.entrySet()) {
                this.namespaceMap.put(namespaceEntry.getValue(), namespaceEntry.getKey());
            }
            this.namespaceMap.put(NAMESPACE_URI_RDF, PREFIX_RDF);
            int unknownNamespacePrefixCounter = 0;
            StmtIterator statementIterator = model.listStatements();
            while (statementIterator.hasNext()) {
                Statement statement = (Statement)statementIterator.next();
                Property predicate = statement.getPredicate();
                if (RDF.subject.equals(predicate) || RDF.predicate.equals(predicate) || RDF.object.equals(predicate)) continue;
                String namespace = null;
                namespace = RDF.type.equals(predicate) ? statement.getObject().asResource().getNameSpace() : predicate.getNameSpace();
                if (this.namespaceMap.containsKey(namespace)) continue;
                this.namespaceMap.put(namespace, "j." + unknownNamespacePrefixCounter++);
            }
            this.indent = indent;
            this.tab = tab;
        }

        public void xmlDeclaration(String encoding) {
            if (encoding != null) {
                this.printWriter.print(MessageFormat.format(XML_DECLARATION_ENCODING, encoding));
            } else {
                this.printWriter.print(XML_DECLARATION_ENCODING);
            }
            this.printWriter.println();
        }

        public void rootStartTag(String namespaceUri, String localName) {
            this.tab();
            ++this.tabCount;
            this.startTag(namespaceUri, localName, false);
            for (Map.Entry<String, String> namespaceEntry : this.namespaceMap.entrySet()) {
                this.printWriter.println();
                this.tab();
                this.tab();
                StringBuilder buffer = new StringBuilder();
                buffer.append(PREFIX_XMLNS);
                buffer.append(':');
                buffer.append(namespaceEntry.getValue());
                buffer.append("=\"");
                buffer.append(namespaceEntry.getKey());
                buffer.append('\"');
                this.printWriter.print(buffer.toString());
            }
            this.closeStartTag(true);
            --this.tabCount;
        }

        public void startTag(String namespaceUri, String localName, boolean isChildStartTag) {
            if (isChildStartTag) {
                ++this.tabCount;
                this.tab();
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append('<');
            buffer.append(this.namespaceMap.get(namespaceUri));
            buffer.append(':');
            buffer.append(localName);
            this.printWriter.print(buffer.toString());
        }

        public void attribute(String namespaceUri, String localName, String value) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(' ');
            buffer.append(this.namespaceMap.get(namespaceUri));
            buffer.append(':');
            buffer.append(localName);
            buffer.append("=\"");
            buffer.append(value);
            buffer.append('\"');
            this.printWriter.print(buffer.toString());
        }

        public void closeEmptyStartTag() {
            this.printWriter.print("/>");
            this.printWriter.println();
            --this.tabCount;
        }

        public void closeStartTag(boolean isParent) {
            this.printWriter.print(">");
            if (isParent) {
                this.printWriter.println();
            }
        }

        public void literal(String literal) {
            this.printWriter.print(literal);
        }

        public void endTag(String namespaceUri, String localName, boolean isParent) {
            this.rootEndTag(namespaceUri, localName, isParent);
            --this.tabCount;
        }

        public void rootEndTag(String namespaceUri, String localName, boolean isParent) {
            if (isParent) {
                this.tab();
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("</");
            buffer.append(this.namespaceMap.get(namespaceUri));
            buffer.append(':');
            buffer.append(localName);
            buffer.append('>');
            this.printWriter.print(buffer.toString());
            this.printWriter.println();
        }

        public void end() {
            this.printWriter.flush();
        }

        private void tab() {
            char[] spaces = new char[this.tab * this.tabCount + this.indent];
            if (spaces.length > 0) {
                Arrays.fill(spaces, ' ');
                this.printWriter.print(new String(spaces));
            }
        }
    }
}

