/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.rtc.common.internal.setup.builders;

import com.ibm.team.process.common.internal.setup.builders.IProcessBuilderContext;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.service.IContributorService;
import com.ibm.team.repository.common.service.IExternalUserRegistryService;
import com.ibm.team.rtc.common.internal.setup.builders.AbstractArtifactBuilder;
import com.ibm.team.rtc.common.internal.setup.builders.BuildContext;
import com.ibm.team.rtc.common.internal.setup.builders.ValueKey;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class ContributorBuilder
extends AbstractArtifactBuilder<IContributor> {
    public static final String DEFAULT_PASSWORD = "password";
    protected static final ValueKey<String> NAME_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".name");
    protected static final ValueKey<UUID> CONTEXT_ID_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".contextId");
    protected static final ValueKey<String> USER_ID_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".userId");
    protected static final ValueKey<String> EMAIL_ADDRESS_KEY = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".emailAddress");
    protected static final ValueKey<List<String>> JAZZ_ROLES = new ValueKey(String.valueOf(ContributorBuilder.class.getName()) + ".jazzRoles");

    public ContributorBuilder(IProcessBuilderContext buildContext) {
        super(buildContext);
        this.setBuilderValue(JAZZ_ROLES, new LinkedList());
    }

    public ContributorBuilder contextId(UUID contextId) {
        this.setBuilderValue(CONTEXT_ID_KEY, contextId);
        return this;
    }

    public ContributorBuilder name(String name) {
        this.setBuilderValue(NAME_KEY, name);
        return this;
    }

    public ContributorBuilder userId(String userId) {
        this.setBuilderValue(USER_ID_KEY, userId);
        return this;
    }

    public ContributorBuilder email(String emailAddress) {
        this.setBuilderValue(EMAIL_ADDRESS_KEY, emailAddress);
        return this;
    }

    public ContributorBuilder role(String ... roles) {
        this.getBuilderValue(JAZZ_ROLES).addAll(Arrays.asList(roles));
        return this;
    }

    @Override
    protected IProcessBuilderContext getContext() {
        return (IProcessBuilderContext)super.getContext();
    }

    @Override
    protected IContributor doBuild(BuildContext buildContext) {
        IContributor contributor = (IContributor)this.artifact(IContributor.ITEM_TYPE);
        String uuid = UUID.generate().toString();
        contributor.setContextId(this.chooseValue(CONTEXT_ID_KEY, contributor.getContextId(), UUID.generate()));
        contributor.setName(this.chooseValue(NAME_KEY, contributor.getName(), uuid));
        contributor.setUserId(this.chooseValue(USER_ID_KEY, contributor.getUserId(), uuid));
        contributor.setEmailAddress(this.chooseValue(EMAIL_ADDRESS_KEY, contributor.getEmailAddress(), String.valueOf(uuid) + "@none.com"));
        return contributor;
    }

    @Override
    protected IContributor doSave(BuildContext context) throws TeamRepositoryException {
        IContributor contributor = this.getContext().getLibrary(IContributorService.class).saveContributor((IContributor)this.build(context));
        this.getContext().getLibrary(IExternalUserRegistryService.class).addExternalUser(contributor.getUserId(), DEFAULT_PASSWORD, contributor.getName(), contributor.getEmailAddress(), this.getBuilderValue(JAZZ_ROLES).toArray(new String[0]));
        return (IContributor)this.getContext().resolve((IItemHandle)contributor);
    }
}

