/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.IExternalUserRegistryManager;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamPlatformObject;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.util.ClientUtil;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IExternalGroup;
import com.ibm.team.repository.common.IExternalUser;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UnknownUserRegistryException;
import com.ibm.team.repository.common.UnmodifiableUserRegistryException;
import com.ibm.team.repository.common.model.ExternalGroup;
import com.ibm.team.repository.common.model.ExternalRegistryConfigurationDTO;
import com.ibm.team.repository.common.model.ExternalUsersDTO;
import com.ibm.team.repository.common.model.FetchUserDTO;
import com.ibm.team.repository.common.service.IExternalUserRegistryService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class ExternalUserRegistryManager
extends TeamPlatformObject
implements IExternalUserRegistryManager,
ITeamRepository.ILoginParticipant {
    private final IExternalUserRegistryService externalUserRegistryService;
    private Object INIT_LOCK = new Object();
    private boolean isInitialized = false;
    private boolean isQueryable = false;
    private boolean isWritable = false;
    private int maxLimitForUserSearch = -1;
    private List<String> readOnlyAttributes;
    private Map<String, IExternalGroup> applicationGroupMap;

    public ExternalUserRegistryManager(TeamRepository repository) {
        super(repository);
        this.externalUserRegistryService = (IExternalUserRegistryService)repository.getServiceInterface(IExternalUserRegistryService.class);
        if (this.externalUserRegistryService == null) {
            throw new IllegalStateException("Unable to initialize external user registry service");
        }
        this.readOnlyAttributes = new ArrayList<String>(3);
        this.applicationGroupMap = new HashMap<String, IExternalGroup>(4);
        this.teamRepository().addLoginParticipant(this);
    }

    @Override
    public void handleLogin(ITeamRepository repository) {
    }

    @Override
    public void handleLogout(ITeamRepository repository) {
        this.initializeExternalRegistryConfiguration(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary(IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            if (this.isInitialized) {
                return;
            }
        }
        this.doInitialize(monitor);
    }

    private void doInitialize(IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<ExternalRegistryConfigurationDTO> dtoFetch = new IClientLibraryContext.IServiceRunnable<ExternalRegistryConfigurationDTO>(){

            @Override
            public ExternalRegistryConfigurationDTO run(IProgressMonitor mon) throws TeamRepositoryException {
                return ExternalUserRegistryManager.this.externalUserRegistryService.fetchExternalRegistryConfiguration();
            }
        };
        ExternalRegistryConfigurationDTO dto = null;
        try {
            dto = this.callCancelableService(dtoFetch, ClientUtil.getMonitor(monitor));
        }
        catch (TeamRepositoryException e) {
            this.initializeExternalRegistryConfiguration(null);
            throw e;
        }
        this.initializeExternalRegistryConfiguration(dto);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reinitialize(IProgressMonitor progressMonitor) throws TeamRepositoryException {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            this.isInitialized = false;
        }
        this.doInitialize(ClientUtil.getMonitor(progressMonitor));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeExternalRegistryConfiguration(ExternalRegistryConfigurationDTO dto) {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            if (dto == null) {
                this.isInitialized = false;
                this.isQueryable = false;
                this.isWritable = false;
                this.applicationGroupMap.clear();
                this.maxLimitForUserSearch = -1;
                this.readOnlyAttributes.clear();
            } else {
                this.isInitialized = true;
                this.isQueryable = dto.isQueryable();
                this.isWritable = dto.isWritable();
                this.maxLimitForUserSearch = dto.getMaxLimitForUserSearchQuery();
                this.updateReadOnlyAttributes(dto.getReadOnlyUserAttributes());
                this.updateApplicationGroups(dto.getGroups());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateReadOnlyAttributes(List<String> readOnlyAttribs) {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            this.readOnlyAttributes = new ArrayList<String>(readOnlyAttribs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExternalRegistryQueryable(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            return this.isQueryable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExternalRegistryWriteable(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            return this.isWritable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxLimitForUserSearchQuery(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            return this.maxLimitForUserSearch;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] listAllReadOnlyAttributes(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            return this.readOnlyAttributes.toArray(new String[this.readOnlyAttributes.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IExternalGroup[] listApplicationGroups(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            Collection<IExternalGroup> groups = this.applicationGroupMap.values();
            return groups.toArray(new IExternalGroup[groups.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateApplicationGroups(List<ExternalGroup> groups) {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            this.applicationGroupMap.clear();
            for (IExternalGroup iExternalGroup : groups) {
                this.applicationGroupMap.put(iExternalGroup.getName(), iExternalGroup);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGroupDescription(String groupName, IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            IExternalGroup group = this.applicationGroupMap.get(groupName);
            return group == null ? null : group.getDescription();
        }
    }

    @Override
    public void addExternalUser(final String userId, final String password, final String name, final String emailAddress, final String[] groups, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ExternalUserRegistryManager.this.externalUserRegistryService.addExternalUser(userId, password, name, emailAddress, groups);
                    return null;
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public void updateExternalUser(final String userId, final String name, final String emailAddress, final String[] groups, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ExternalUserRegistryManager.this.externalUserRegistryService.updateExternalUser(userId, name, emailAddress, groups);
                    return null;
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public void addToGroup(final String userId, final String groupName, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ExternalUserRegistryManager.this.externalUserRegistryService.addToGroup(userId, groupName);
                    return null;
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public void removeFromGroup(final String userId, final String groupName, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ExternalUserRegistryManager.this.externalUserRegistryService.removeFromGroup(userId, groupName);
                    return null;
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public boolean isMember(final String userId, final String groupName, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            boolean bl = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<Boolean>(){

                @Override
                public Boolean run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ExternalUserRegistryManager.this.externalUserRegistryService.isMember(userId, groupName);
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
            return bl;
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public IExternalUser fetchUser(final String userId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            FetchUserDTO fetchUserDTO = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<FetchUserDTO>(){

                @Override
                public FetchUserDTO run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ExternalUserRegistryManager.this.externalUserRegistryService.fetchUser2(userId);
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
            IExternalUser user = fetchUserDTO.getExternaluser();
            this.updateReadOnlyAttributes(fetchUserDTO.getReadOnlyProperties());
            IExternalUser iExternalUser = user;
            return iExternalUser;
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public String[] fetchGroupsForUser(final String userId, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            String[] stringArray = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<String[]>(){

                @Override
                public String[] run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ExternalUserRegistryManager.this.externalUserRegistryService.fetchGroupsForUser(userId);
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
            return stringArray;
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public IExternalUser[] findUsersByName(final String name, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            ExternalUsersDTO externalUsersDTO = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ExternalUsersDTO>(){

                @Override
                public ExternalUsersDTO run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ExternalUserRegistryManager.this.externalUserRegistryService.findUsersByName2(name);
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
            IExternalUser[] iExternalUserArray = this.processExternalUsersDTO(externalUsersDTO);
            return iExternalUserArray;
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public IExternalUser[] findUsersByAnyName(final String name, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            ExternalUsersDTO externalUsersDTO = this.callCancelableService(new IClientLibraryContext.IServiceRunnable<ExternalUsersDTO>(){

                @Override
                public ExternalUsersDTO run(IProgressMonitor monitor) throws TeamRepositoryException {
                    return ExternalUserRegistryManager.this.externalUserRegistryService.findUsersByAnyName2(name);
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
            IExternalUser[] iExternalUserArray = this.processExternalUsersDTO(externalUsersDTO);
            return iExternalUserArray;
        }
        finally {
            localMonitor.done();
        }
    }

    private IExternalUser[] processExternalUsersDTO(ExternalUsersDTO externalUsersDTO) {
        List externalUsers = externalUsersDTO.getExternalUsers();
        this.updateMaxLimitForUserSearchQuery(externalUsersDTO.getMaxLimitOfReturnedUsers());
        return externalUsers.toArray(new IExternalUser[externalUsers.size()]);
    }

    @Override
    public void changePassword(final String userId, final String oldPassword, final String newPassword, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ExternalUserRegistryManager.this.externalUserRegistryService.changePassword(userId, oldPassword, newPassword);
                    return null;
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    public void resetPassword(final String userId, final String[] emailAddresses, IProgressMonitor progressMonitor) throws TeamRepositoryException {
        if (userId == null) {
            throw new IllegalArgumentException("User ID must not be null");
        }
        if (emailAddresses == null) {
            throw new IllegalArgumentException("Email Address must not be null");
        }
        IProgressMonitor localMonitor = ClientUtil.beginMonitor(progressMonitor, 100);
        this.initializeIfNecessary((IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        try {
            this.callCancelableService(new IClientLibraryContext.IServiceRunnable(){

                public Object run(IProgressMonitor monitor) throws TeamRepositoryException {
                    ExternalUserRegistryManager.this.externalUserRegistryService.resetPassword(userId, emailAddresses);
                    return null;
                }
            }, (IProgressMonitor)new SubProgressMonitor(localMonitor, 50));
        }
        finally {
            localMonitor.done();
        }
    }

    @Override
    protected <T> T callCancelableService(IClientLibraryContext.IServiceRunnable<T> runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            return super.callCancelableService(runnable, monitor);
        }
        catch (UnmodifiableUserRegistryException e) {
            this.reinitialize(monitor);
            throw e;
        }
        catch (UnknownUserRegistryException e) {
            this.reinitialize(monitor);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxLimitForUserSearchQuery(int maxLimit) {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            this.maxLimitForUserSearch = maxLimit;
        }
    }
}

