/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.repository.client.internal;

import com.ibm.team.repository.client.ILicenseClient;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.internal.nls.Messages;
import com.ibm.team.repository.client.util.EventSource;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IDefaultLicenseProviderService;
import com.ibm.team.repository.common.ILicenseAdminService2;
import com.ibm.team.repository.common.ILicenseService;
import com.ibm.team.repository.common.LicenseNotGrantedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.transport.ServiceNotAvailableException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.transport.client.RepositoryJobSchedulingRule;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class LicenseClient
extends EventSource
implements ILicenseClient {
    public static final Log logger = LogFactory.getLog(LicenseClient.class);
    private final IClientLibraryContext context;
    private final ILicenseService licenseService;
    private final IDefaultLicenseProviderService defaultLicenseProviderService;
    private final ILicenseAdminService2 licenseAdminService;
    private final Map<String, String> cachedLicenseChecks = new HashMap<String, String>();
    private boolean isInitialized = false;
    private Object INIT_LOCK = new Object();
    private List<String> defaultLicenseIds = null;
    private final ITeamRepository.ILoginParticipant cacheFlusher = new ITeamRepository.ILoginParticipant(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleLogout(ITeamRepository repository) {
            LicenseClient.this.flushCache();
            final boolean[] done = new boolean[1];
            final String userId = repository.getUserId();
            final String uri = repository.getRepositoryURI();
            String name = NLS.bind((String)Messages.getClientString("LicenseClient.ReleaseFloatingLicensesOnLogoutJobName"), (Object)userId, (Object[])new Object[]{uri});
            Job terminateJob = new Job(name){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor progress) {
                    IStatus iStatus;
                    try {
                        LicenseClient.this.licenseAdminService.terminateLeases(null);
                        iStatus = Status.OK_STATUS;
                        boolean[] blArray = done;
                    }
                    catch (Throwable e) {
                        Status status;
                        try {
                            String message = NLS.bind((String)Messages.getClientString("LicenseClient.FailureReleasingLeasesDuringLogout"), (Object)userId, (Object[])new Object[]{uri});
                            status = new Status(2, "com.ibm.team.repository.client", message, e);
                            boolean[] blArray = done;
                        }
                        catch (Throwable throwable) {
                            boolean[] blArray = done;
                            synchronized (done) {
                                done[0] = true;
                                done.notifyAll();
                                // ** MonitorExit[var6_6] (shouldn't be in output)
                                throw throwable;
                            }
                        }
                        synchronized (done) {
                            done[0] = true;
                            done.notifyAll();
                            // ** MonitorExit[var6_5] (shouldn't be in output)
                            return status;
                        }
                    }
                    synchronized (done) {
                        done[0] = true;
                        done.notifyAll();
                        // ** MonitorExit[var6_4] (shouldn't be in output)
                        return iStatus;
                    }
                }
            };
            terminateJob.setRule(RepositoryJobSchedulingRule.getReadAccessRule((String)uri));
            terminateJob.schedule();
            boolean[] blArray = done;
            synchronized (done) {
                if (!done[0]) {
                    try {
                        done.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void handleLogin(ITeamRepository repository) {
            LicenseClient.this.flushCache();
        }
    };

    public LicenseClient(IClientLibraryContext context) {
        this.context = context;
        this.licenseService = (ILicenseService)context.getServiceInterface(ILicenseService.class);
        this.defaultLicenseProviderService = (IDefaultLicenseProviderService)context.getServiceInterface(IDefaultLicenseProviderService.class);
        this.licenseAdminService = (ILicenseAdminService2)context.getServiceInterface(ILicenseAdminService2.class);
        context.teamRepository().addLoginParticipant(this.cacheFlusher);
    }

    public void assertLicense(String operationId) throws LicenseNotGrantedException, TeamRepositoryException {
        this.assertLicense(operationId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String[] checkLicenses(final List<String> operationIds, IProgressMonitor monitor) throws TeamRepositoryException {
        if (operationIds == null) {
            throw new IllegalArgumentException("The operationIds must not be null");
        }
        Map<String, String> map = this.cachedLicenseChecks;
        synchronized (map) {
            String[] stringArray;
            String[] results = new String[operationIds.size()];
            boolean allCached = true;
            int i = 0;
            while (i < operationIds.size()) {
                String operationId = operationIds.get(i);
                if (operationId == null) {
                    throw new IllegalArgumentException(NLS.bind((String)"Each operationId must be non-null, but element {0} was null", (Object)i, (Object[])new Object[0]));
                }
                if (!this.cachedLicenseChecks.containsKey(operationId)) {
                    allCached = false;
                    break;
                }
                results[i] = this.cachedLicenseChecks.get(operationId);
                ++i;
            }
            if (!allCached) return this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<String[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String[] run(IProgressMonitor mon) throws TeamRepositoryException {
                    String[] checkLicenses = LicenseClient.this.licenseService.checkLicenses(operationIds.toArray(new String[operationIds.size()]));
                    Map map = LicenseClient.this.cachedLicenseChecks;
                    synchronized (map) {
                        int i = 0;
                        while (i < operationIds.size()) {
                            LicenseClient.this.cachedLicenseChecks.put((String)operationIds.get(i), checkLicenses[i]);
                            ++i;
                        }
                    }
                    return checkLicenses;
                }
            }, monitor);
            if (monitor != null) {
                monitor.beginTask(null, -1);
            }
            try {
                stringArray = results;
                if (monitor == null) return stringArray;
            }
            catch (Throwable throwable) {
                if (monitor == null) throw throwable;
                monitor.done();
                throw throwable;
            }
            monitor.done();
            return stringArray;
        }
    }

    @Override
    public void assertLicenseForContributor(final String operationId, final IContributorHandle contributor, IProgressMonitor monitor) throws LicenseNotGrantedException, TeamRepositoryException {
        if (operationId == null) {
            throw new IllegalArgumentException("The operationId must not be null");
        }
        if (contributor == null) {
            throw new IllegalArgumentException("The contributor must not be null");
        }
        this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

            @Override
            public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                LicenseClient.this.licenseService.assertLicenseForContributor(operationId, contributor);
                return null;
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assertLicense(final String operationId, IProgressMonitor monitor) throws LicenseNotGrantedException, TeamRepositoryException {
        if (operationId == null) {
            throw new IllegalArgumentException("The operationId must not be null");
        }
        Map<String, String> map = this.cachedLicenseChecks;
        synchronized (map) {
            if (this.cachedLicenseChecks.containsKey(operationId)) {
                if (monitor != null) {
                    monitor.beginTask(null, -1);
                }
                try {
                    String message = this.cachedLicenseChecks.get(operationId);
                    if (message != null) {
                        throw new LicenseNotGrantedException(message);
                    }
                    return;
                }
                finally {
                    if (monitor != null) {
                        monitor.done();
                    }
                }
            }
        }
        try {
            this.context.callCancelableService(new IClientLibraryContext.IServiceRunnable<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Object run(IProgressMonitor mon) throws TeamRepositoryException {
                    LicenseClient.this.licenseService.assertLicense(operationId);
                    Map map = LicenseClient.this.cachedLicenseChecks;
                    synchronized (map) {
                        LicenseClient.this.cachedLicenseChecks.put(operationId, null);
                    }
                    return null;
                }
            }, monitor);
        }
        catch (LicenseNotGrantedException exp) {
            Map<String, String> map2 = this.cachedLicenseChecks;
            synchronized (map2) {
                this.cachedLicenseChecks.put(operationId, exp.getMessage());
            }
            throw exp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCache() {
        Object object = this.cachedLicenseChecks;
        synchronized (object) {
            this.cachedLicenseChecks.clear();
        }
        object = this.INIT_LOCK;
        synchronized (object) {
            this.isInitialized = false;
            this.defaultLicenseIds = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDefaultLicenseId(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            block4: {
                if (!this.defaultLicenseIds.isEmpty()) break block4;
                return null;
            }
            return this.defaultLicenseIds.get(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getDefaultLicenseIds(IProgressMonitor monitor) throws TeamRepositoryException {
        this.initializeIfNecessary(monitor);
        Object object = this.INIT_LOCK;
        synchronized (object) {
            return this.defaultLicenseIds.toArray(new String[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeIfNecessary(IProgressMonitor monitor) throws TeamRepositoryException {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            if (this.isInitialized) {
                return;
            }
        }
        this.doInitialize(monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInitialize(IProgressMonitor monitor) throws TeamRepositoryException {
        IClientLibraryContext.IServiceRunnable<List<String>> licensesToAssign = new IClientLibraryContext.IServiceRunnable<List<String>>(){

            @Override
            public List<String> run(IProgressMonitor mon) throws TeamRepositoryException {
                return Arrays.asList(LicenseClient.this.defaultLicenseProviderService.getDefaultLicenseIds());
            }
        };
        List<String> licenseIds = null;
        try {
            licenseIds = this.callCancelableService(licensesToAssign, monitor);
            this.initializeLicenseId(licenseIds);
            return;
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            this.initializeLicenseId(null);
            return;
        }
        catch (TeamRepositoryException e) {
            Object object = this.INIT_LOCK;
            synchronized (object) {
                this.isInitialized = false;
                this.defaultLicenseIds = null;
            }
            throw e;
        }
    }

    protected <T> T callCancelableService(IClientLibraryContext.IServiceRunnable<T> runnable, IProgressMonitor monitor) throws TeamRepositoryException {
        return ((TeamRepository)this.context.teamRepository()).callCancelableService(runnable, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLicenseId(List<String> licenseIds) {
        Object object = this.INIT_LOCK;
        synchronized (object) {
            this.defaultLicenseIds = licenseIds;
            this.isInitialized = true;
        }
    }
}

