/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcComponentInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CCaseVerInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.DiffBLInfo;
import com.ibm.rational.wvcm.ct.Messages;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Version;
import javax.wvcm.VersionSet;
import javax.wvcm.WvcmException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.osgi.util.NLS;

public class CTBranchBaseline
extends CTBaseline {
    private CCaseLib cc = null;

    public CTBranchBaseline(Location location, CTProvider provider) {
        super(location, provider);
        this.cc = provider.getCCaseLib();
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public List<SrvcResource.SrvcCompareReport> doCompareReport(SrvcResource wsContainingNewBaseline, VersionSet.CompareFlag[] flags, SrvcFeedback feedback) throws WvcmException {
        List<Object> findResult = new ArrayList();
        if (!(wsContainingNewBaseline instanceof CTBaseCCView)) {
            throw new IllegalArgumentException("doCompareReport is only supported when the argument is a View");
        }
        CTProvider p = this.provider();
        CTBaseCCView view = (CTBaseCCView)wsContainingNewBaseline;
        CTLocation oldBlLocation = this.location();
        String viewTag = view.getViewTag();
        String searchRoot = CCaseLib.getPathIntoView(viewTag);
        CTLocation vobComponentLocation = oldBlLocation.getContextLocation(CTLocation.Kind.VOBCOMPONENT);
        String componentDisplayname = vobComponentLocation.getDisplayName();
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.cc, componentDisplayname, feedback);
        BaseCcComponentInfo info = BaseCcComponentInfo.valueOf(compObjInfo, feedback);
        String crdPathname = info.getViewRelativePath(view, feedback);
        searchRoot = String.valueOf(searchRoot) + crdPathname;
        CTLocation oldTimeLocation = oldBlLocation.lookupContextLocation(CTLocation.Kind.TIMESTAMP);
        if (oldTimeLocation != null) {
            String oldTime = oldTimeLocation.getDisplayName();
            String branchOid = oldBlLocation.getContextLocation(CTLocation.Kind.BRTYPE).getDisplayName();
            String branch = this.cc.getDisplayName(branchOid, feedback);
            findResult = this.cc.findNewVersions(searchRoot, oldTime, branch, feedback);
        } else {
            String oldLabelType = oldBlLocation.getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
            String newLabelTypeSelector = view.getLabelTypeSelectorForComponent(info, feedback);
            findResult = this.cc.findNewVersionsForImporter(searchRoot, oldLabelType, newLabelTypeSelector, feedback);
        }
        IPath searchRootPath = CommonUtils.getIPathWithoutVerExt(searchRoot);
        ListIterator<Object> iter = findResult.listIterator();
        while (iter.hasNext()) {
            IPath path = CommonUtils.getIPathWithoutVerExt((String)iter.next());
            if (searchRootPath.isPrefixOf(path)) continue;
            iter.remove();
        }
        Map<String, CCaseVerInfo> versionList = CCaseVerInfo.getVerInfos(this.cc, findResult, feedback);
        ArrayList<SrvcResource.SrvcCompareReport> blReports = new ArrayList<SrvcResource.SrvcCompareReport>(versionList.size());
        if (versionList.isEmpty()) {
            return blReports;
        }
        ArrayList<CTVersion> versions = new ArrayList<CTVersion>(versionList.size());
        for (String string : findResult) {
            CCaseVerInfo verInfo = versionList.get(string);
            if (verInfo == null) continue;
            CTVersion version = CTVersion.valueOf(p, verInfo, view, string, feedback);
            versions.add(version);
        }
        for (CTVersion cTVersion : versions) {
            DiffBLInfo diffBLInfo = new DiffBLInfo(null, cTVersion, p);
            SrvcResource.SrvcCompareReport baselineReport = this.computeBlReport(diffBLInfo);
            blReports.add(baselineReport);
        }
        return blReports;
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        Object propertyValue = null;
        if (propertyName.equals((Object)Resource.RESOURCE_IDENTIFIER)) {
            propertyValue = this.location().string();
        }
        if (propertyName.equals((Object)Version.VERSION_HISTORY)) {
            propertyValue = new CTVOB((Location)this.location().getContextLocation(CTLocation.Kind.VOBCOMPONENT), this.provider());
        }
        if ("com.ibm.team.importer".equals(propertyName.getNamespace())) {
            return this.getLabelAttribute(propertyName.getName(), feedback);
        }
        if (propertyName.equals((Object)Resource.DISPLAY_NAME)) {
            return this.getDisplayName(feedback);
        }
        if (propertyValue == null) {
            propertyValue = super.getThisProperty(propertyName, configuration, feedback);
        }
        return propertyValue;
    }

    private String getLabelAttribute(String attribute, SrvcFeedback feedback) throws WvcmException {
        return this.cc.getAttribute(this.location().getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName(), attribute, feedback);
    }

    @Override
    protected String getDisplayName(SrvcFeedback feedback) throws WvcmException {
        String displayName = null;
        CTLocation myLocation = this.location();
        CTLocation timeLocation = myLocation.lookupContextLocation(CTLocation.Kind.TIMESTAMP);
        if (timeLocation != null) {
            String time = timeLocation.getDisplayName();
            String branch = this.location().getContextLocation(CTLocation.Kind.BRTYPE).getDisplayName();
            displayName = NLS.bind((String)Messages.CTBranchBaseline_TIME_BASELINE_DISPLAY_NAME, (Object)branch, (Object)time);
        } else {
            displayName = myLocation.getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
        }
        return displayName;
    }

    public BaselineInfo getInfo(CTBaseCCView view, SrvcFeedback feedback) throws WvcmException {
        CTLocation myLocation = this.location();
        CTLocation timeLocation = myLocation.lookupContextLocation(CTLocation.Kind.TIMESTAMP);
        if (timeLocation != null) {
            throw new IllegalStateException("Cannot get component rule information for a timestamp based baseline");
        }
        String lbtypeSelector = myLocation.getContextLocation(CTLocation.Kind.LBTYPE).getDisplayName();
        String lbtypeName = this.cc.getDisplayName(lbtypeSelector, feedback);
        String vobComponent = myLocation.getContextLocation(CTLocation.Kind.VOBCOMPONENT).getDisplayName();
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(this.cc, vobComponent, feedback);
        BaseCcComponentInfo info = BaseCcComponentInfo.valueOf(compObjInfo, feedback);
        BaselineInfo result = new BaselineInfo(lbtypeSelector, lbtypeName, info);
        return result;
    }

    public static class BaselineInfo {
        final String lbtypeSelector;
        final String lbtypeName;
        final BaseCcComponentInfo compInfo;

        public BaselineInfo(String lbtypeSelector, String lbtypeName, BaseCcComponentInfo info) {
            this.lbtypeSelector = lbtypeSelector;
            this.lbtypeName = lbtypeName;
            this.compInfo = info;
        }
    }
}

