/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.rational.wvcm.ct;

import com.ibm.rational.wvcm.ct.BaseCcComponentInfo;
import com.ibm.rational.wvcm.ct.CCaseLib;
import com.ibm.rational.wvcm.ct.CCaseObjInfo;
import com.ibm.rational.wvcm.ct.CTBaseCCView;
import com.ibm.rational.wvcm.ct.CTBaseline;
import com.ibm.rational.wvcm.ct.CTComponent;
import com.ibm.rational.wvcm.ct.CTControllableFolder;
import com.ibm.rational.wvcm.ct.CTControllableResource;
import com.ibm.rational.wvcm.ct.CTElement;
import com.ibm.rational.wvcm.ct.CTLocation;
import com.ibm.rational.wvcm.ct.CTProvider;
import com.ibm.rational.wvcm.ct.CTUcmView;
import com.ibm.rational.wvcm.ct.CTVOB;
import com.ibm.rational.wvcm.ct.CTVersion;
import com.ibm.rational.wvcm.ct.CTView;
import com.ibm.rational.wvcm.ct.CommonUtils;
import com.ibm.rational.wvcm.ct.ObjSelUtils;
import com.ibm.rational.wvcm.interop.InteropUtilities;
import com.ibm.rational.wvcm.ri.impl.ConfigurationImpl;
import com.ibm.rational.wvcm.ri.impl.PropValue;
import com.ibm.rational.wvcm.ri.srvc.SrvcFeedback;
import com.ibm.rational.wvcm.ri.srvc.SrvcResource;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.wvcm.Configuration;
import javax.wvcm.ControllableResource;
import javax.wvcm.Location;
import javax.wvcm.PropertyNameList;
import javax.wvcm.Resource;
import javax.wvcm.Stream;
import javax.wvcm.Workspace;
import javax.wvcm.WvcmException;
import org.eclipse.osgi.util.NLS;

public class CTWvcmConfiguration
extends CTControllableResource {
    public static final String VOBCOMP_ATTR_NAMESPACE = "com.ibm.team.interop";
    public static final String VOBCOMP_ATTR_NAME = "VobComponent";
    public static final String VOBCOMP_ATTR = "com.ibm.team.interop_VobComponent";
    private static final String DATETIME_FMT = "dd-MMMM-yyyy.HH:mm:ss'UTC'";
    private String _latestBaselineSelector = null;
    private String _timeNow = null;

    CTWvcmConfiguration(Location loc, CTProvider provider) throws WvcmException {
        super(loc, provider);
        CTLocation myLoc = (CTLocation)loc;
        CTLocation.Kind kind = myLoc.getKind();
        if (!CTLocation.Kind.WORKSPACE_CONFIGURATION.equals((Object)kind) && !ObjSelUtils.isUniversalSelector(this.getComponentLocation().getDisplayName())) {
            throw new IllegalArgumentException("Component location must be universal selector");
        }
    }

    public static CTWvcmConfiguration valueOf(CTView view, CTComponent component, SrvcFeedback feedback) throws WvcmException {
        CTLocation myLoc = CTLocation.createConfigurationLoc(view.location(), component.location());
        CTWvcmConfiguration result = (CTWvcmConfiguration)view.provider().get((Location)myLoc, feedback);
        return result;
    }

    @Override
    public Class<?> get_proxyClass() {
        return ConfigurationImpl.class;
    }

    public void doCheckin(ControllableResource.CheckinFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback feedback) throws WvcmException {
        CTLocation myLoc;
        String nameHint = null;
        PropValue pval = updates.remove(Resource.DISPLAY_NAME);
        if (pval != null) {
            nameHint = (String)pval.get_value();
        }
        if ((myLoc = this.location()).hasKind(CTLocation.Kind.WORKSPACE_CONFIGURATION)) {
            CTView view = CTView.getWorkspaceConfigurationWorkspace(this.provider(), myLoc, feedback);
            view.doCreateCompositeBaseline(myLoc, nameHint, flags, updates, updated, feedback);
            return;
        }
        this.createBaseline(nameHint, feedback);
    }

    public void doCheckout(ControllableResource.CheckoutFlag[] flags, Map<PropertyNameList.PropertyName<?>, PropValue> updates, List<PropertyNameList.PropertyName<?>> updated, SrvcFeedback sfb) throws WvcmException {
    }

    @Override
    public Object getThisProperty(PropertyNameList.PropertyName<?> propertyName, SrvcResource configuration, SrvcFeedback feedback) throws WvcmException {
        if (propertyName.equals((Object)Configuration.RESOURCE_IDENTIFIER)) {
            return this.location().string();
        }
        if (propertyName.equals((Object)Configuration.CHECKED_IN)) {
            CTLocation myLoc = this.location();
            if (CTLocation.Kind.WORKSPACE_CONFIGURATION.equals((Object)myLoc.getKind())) {
                CTLocation resultViewLoc = myLoc.getContextLocation(CTLocation.Kind.WORKSPACE);
                CTProvider p = this.provider();
                CTView resultView = (CTView)p.get((Location)resultViewLoc, feedback);
                return resultView.getLatestCompositeBaseline(feedback);
            }
            return this.getLatestBaseline(feedback);
        }
        if (propertyName.equals((Object)Configuration.IS_CHECKED_OUT)) {
            return false;
        }
        if (propertyName.equals((Object)Configuration.VERSION_HISTORY)) {
            CTLocation compLoc = this.getComponentLocation();
            if (compLoc.hasKind(CTLocation.Kind.VOBCOMPONENT)) {
                return new CTVOB((Location)compLoc, this.provider());
            }
            return new CTComponent((Location)compLoc, this.provider());
        }
        if (propertyName.equals((Object)Configuration.ROOT_FOLDER)) {
            CTProvider p = this.provider();
            CTLocation myLoc = this.location();
            CTLocation viewLoc = myLoc.lookupContextLocation(CTLocation.Kind.WORKSPACE);
            String compPathname = null;
            if (viewLoc != null) {
                CTUcmView view = (CTUcmView)p.get((Location)viewLoc, feedback);
                compPathname = view.getComponentPathname(myLoc.getContextLocation(CTLocation.Kind.COMPONENT), feedback);
                if (ObjSelUtils.isUniversalSelector(compPathname)) {
                    throw new IllegalStateException("Need component pathname, not universal selector: " + compPathname);
                }
            } else {
                viewLoc = myLoc.lookupContextLocation(CTLocation.Kind.BASE_CC_VIEW);
                if (viewLoc == null) {
                    throw new IllegalArgumentException("Configuration location for Base CC has no view context");
                }
                CTLocation vobLocation = myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT);
                if (vobLocation == null) {
                    throw new IllegalArgumentException("Configuration location for Base CC has no VOB context");
                }
                CCaseObjInfo info = CCaseObjInfo.getObjInfo(p.getCCaseLib(), vobLocation.getDisplayName(), feedback);
                String mtype = info.getMtype();
                if (mtype.equals("versioned object base")) {
                    String vobTag = p.getCCaseLib().computeVobTagFromVobFamilyUuid(info.getPathName(), feedback);
                    String pathIntoView = String.valueOf(CCaseLib.getPathIntoView(viewLoc.getViewTag())) + vobTag;
                    compPathname = CommonUtils.canonicalizePathname(pathIntoView);
                } else {
                    if (mtype.equals("directory version")) {
                        CTBaseCCView view = (CTBaseCCView)p.get((Location)viewLoc, feedback);
                        CTVersion version = CTVersion.valueOf(p, info, view, info.getPathName(), feedback);
                        CTElement element = version.getVersionHistory(feedback);
                        CTLocation crLoc = element.lookupMyControllableResourceLoc(view, feedback);
                        if (crLoc == null) {
                            throw new WvcmException(NLS.bind((String)"internal error: could not find controllable resource location for {0}", (Object)vobLocation.getDisplayName()), WvcmException.ReasonCode.FORBIDDEN);
                        }
                        return new CTControllableFolder((Location)crLoc, this.provider());
                    }
                    if (mtype.equals("component")) {
                        String componentRootDirPathname = p.getCCaseLib().getComponentRootDirPathname(info.getUniversalSelector(), viewLoc.getViewTag(), feedback);
                        compPathname = CommonUtils.canonicalizePathname(componentRootDirPathname);
                    } else {
                        throw new IllegalStateException("Unexpected mtype for component: " + mtype);
                    }
                }
            }
            CTLocation location = CTLocation.valueOf(CTLocation.Kind.CONTROLLABLE_RESOURCE, compPathname);
            return new CTControllableFolder((Location)location, this.provider());
        }
        return super.getThisProperty(propertyName, configuration, feedback);
    }

    @Override
    protected String computePathname(SrvcFeedback feedback) throws WvcmException {
        return this.location().string();
    }

    private CTLocation getComponentLocation() throws WvcmException {
        CTLocation compLoc = this.location().lookupContextLocation(CTLocation.Kind.COMPONENT);
        if (compLoc != null) {
            return compLoc;
        }
        return this.location().getContextLocation(CTLocation.Kind.VOBCOMPONENT);
    }

    @Override
    public CTLocation getViewLocation(SrvcFeedback feedback) throws WvcmException {
        CTLocation wsLoc = this.location().lookupContextLocation(CTLocation.Kind.WORKSPACE);
        if (wsLoc != null) {
            return wsLoc;
        }
        return this.location().getContextLocation(CTLocation.Kind.BASE_CC_VIEW);
    }

    @Override
    public CTLocation getPathnameLocation(SrvcFeedback feedback) throws WvcmException {
        CCaseLib cc = this.provider().getCCaseLib();
        return CTLocation.valueOf(CTLocation.Kind.CONFIGURATION, cc.getComponentRootDirPathname(this.location().getContextLocation(CTLocation.Kind.COMPONENT).getDisplayName(), this.location().getContextLocation(CTLocation.Kind.WORKSPACE).getViewTag(), feedback));
    }

    public synchronized void createBaseline(String nameHint, SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CTLocation wsLoc = this.getViewLocation(feedback);
        String viewTag = wsLoc.getViewTag();
        String compName = this.getComponentLocation().getDisplayName();
        CCaseLib cc = p.getCCaseLib();
        String baselineBasename = null;
        if (!wsLoc.hasKind(CTLocation.Kind.BASE_CC_VIEW)) {
            List<String> emptyList = Collections.emptyList();
            baselineBasename = cc.makeBaseline(viewTag, compName, nameHint, emptyList, emptyList, feedback);
            if (baselineBasename != null) {
                String pVobSelector = ObjSelUtils.getObjSelVobSel(cc.getStreamUniversalSelector(viewTag, feedback));
                this._latestBaselineSelector = ObjSelUtils.formatSelector("baseline", baselineBasename, pVobSelector);
            }
        } else {
            this._timeNow = CTWvcmConfiguration.timeNow();
            CTLocation brtypeLoc = wsLoc.getContextLocation(CTLocation.Kind.BRTYPE);
            String vobComps = cc.getAttr(VOBCOMP_ATTR, brtypeLoc.getDisplayName(), feedback);
            if (vobComps != null) {
                if (!vobComps.contains(compName)) {
                    vobComps = String.valueOf(vobComps) + CTLocation.INFO_SEPARATOR_STRING + compName;
                    cc.setAttr(VOBCOMP_ATTR, brtypeLoc.getDisplayName(), vobComps, true, feedback);
                }
            } else {
                vobComps = compName;
                cc.setAttr(VOBCOMP_ATTR, brtypeLoc.getDisplayName(), vobComps, false, feedback);
            }
        }
    }

    public synchronized CTBaseline getLatestBaseline(SrvcFeedback feedback) throws WvcmException {
        CTProvider p = this.provider();
        CTLocation myLoc = this.location();
        CCaseLib cc = p.getCCaseLib();
        CTLocation viewLocation = myLoc.lookupContextLocation(CTLocation.Kind.WORKSPACE);
        if (viewLocation != null) {
            if (this._latestBaselineSelector == null) {
                CTView view = (CTView)p.get((Location)viewLocation, feedback);
                String compPath = myLoc.getContextLocation(CTLocation.Kind.COMPONENT).getDisplayName();
                if (!ObjSelUtils.isUniversalSelector(compPath)) {
                    throw new IllegalStateException("Component location must be universal selector");
                }
                this._latestBaselineSelector = cc.lookupLatestBaselineInStreamOfComponent(view.getStreamSelector(feedback), compPath, feedback);
                if (this._latestBaselineSelector == null) {
                    this._latestBaselineSelector = cc.getInitialBaseline(compPath, feedback);
                }
            }
            return (CTBaseline)p.get((Location)p.location(this._latestBaselineSelector), feedback);
        }
        viewLocation = myLoc.getContextLocation(CTLocation.Kind.BASE_CC_VIEW);
        CTLocation vobCompLoc = myLoc.getContextLocation(CTLocation.Kind.VOBCOMPONENT);
        CTLocation brtypeLoc = viewLocation.lookupContextLocation(CTLocation.Kind.BRTYPE);
        if (brtypeLoc != null) {
            if (this._timeNow == null) {
                this._timeNow = CTWvcmConfiguration.timeNow();
            }
            CTLocation timeStampLoc = CTLocation.valueOf(CTLocation.Kind.TIMESTAMP, this._timeNow);
            CTLocation lbtypeLoc = viewLocation.lookupContextLocation(CTLocation.Kind.LBTYPE);
            CTLocation baselineLoc = CTLocation.createBaseCCBaselineLocation(brtypeLoc, lbtypeLoc, vobCompLoc, timeStampLoc);
            return (CTBaseline)p.get((Location)baselineLoc, feedback);
        }
        String vobComponent = vobCompLoc.getDisplayName();
        CTBaseCCView view = (CTBaseCCView)p.get((Location)viewLocation, feedback);
        CCaseObjInfo compObjInfo = CCaseObjInfo.getObjInfo(cc, vobComponent, feedback);
        BaseCcComponentInfo compInfo = BaseCcComponentInfo.valueOf(compObjInfo, feedback);
        CTLocation lbtypeLoc = CTLocation.valueOf(CTLocation.Kind.LBTYPE, view.getLabelTypeSelectorForComponent(compInfo, feedback));
        CTLocation baselineLoc = CTLocation.createBaseCCImporterBaselineLocation(lbtypeLoc, vobCompLoc);
        return (CTBaseline)p.get((Location)baselineLoc, feedback);
    }

    public static String timeNow() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATETIME_FMT, Locale.ENGLISH);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String date = dateFormat.format(calendar.getTime());
        return date;
    }

    public static void setVobCompAttrForBaseCcTests(CCaseLib cc, String vobTag, Stream baseStream, Workspace baseView, SrvcFeedback feedback) throws WvcmException {
        PropertyNameList.PropertyName propName = new PropertyNameList.PropertyName(VOBCOMP_ATTR_NAMESPACE, VOBCOMP_ATTR_NAME);
        if (vobTag == null) {
            baseStream.removeProperty(propName);
        } else {
            String selector = cc.getVobSelector(vobTag, feedback);
            baseStream.setProperty(propName, (Object)selector);
        }
        baseStream.doUpdate(baseView != null ? InteropUtilities.makeList((Resource)baseView) : baseStream.provider().resourceList(new Resource[0]), null);
    }
}

