/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.client.internal.query;

import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IManagedItem;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.internal.query.Messages;
import com.ibm.team.workitem.client.internal.query.QueryDescriptorWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopy;
import com.ibm.team.workitem.client.query.IQueryDescriptorWorkingCopyManager;
import com.ibm.team.workitem.common.query.IQueryDescriptor;
import com.ibm.team.workitem.common.query.IQueryDescriptorHandle;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class QueryDescriptorWorkingCopyManager
implements IQueryDescriptorWorkingCopyManager {
    private final ITeamRepository fRepository;
    private final Map<UUID, QueryDescriptorWorkingCopy> fWorkingCopies;

    public QueryDescriptorWorkingCopyManager(ITeamRepository repository) {
        Assert.isNotNull((Object)repository);
        this.fRepository = repository;
        this.fWorkingCopies = new HashMap<UUID, QueryDescriptorWorkingCopy>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(IQueryDescriptorHandle query, IProgressMonitor monitor) throws TeamRepositoryException {
        Map<UUID, QueryDescriptorWorkingCopy> map = this.fWorkingCopies;
        synchronized (map) {
            if (this.connect(query)) {
                return;
            }
        }
        monitor = ClientUtils.getProgressMonitor(monitor);
        try {
            monitor.beginTask(Messages.QueryDescriptorWorkingCopyManager_CONNECT_QUERY, 100);
            IQueryDescriptor queryDescriptor = this.resolveQueryDescriptor(query, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            Map<UUID, QueryDescriptorWorkingCopy> map2 = this.fWorkingCopies;
            synchronized (map2) {
                block12: {
                    if (!this.connect(query)) break block12;
                    return;
                }
                this.createNewWorkingCopy(queryDescriptor, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
            }
        }
        finally {
            monitor.done();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(IQueryDescriptorHandle query) {
        Map<UUID, QueryDescriptorWorkingCopy> map = this.fWorkingCopies;
        synchronized (map) {
            QueryDescriptorWorkingCopy workingCopy = this.fWorkingCopies.get(query.getItemId());
            if (workingCopy != null) {
                workingCopy.disconnect();
                if (!workingCopy.isReferenced()) {
                    this.fWorkingCopies.remove(query.getItemId());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IQueryDescriptorWorkingCopy getWorkingCopy(IQueryDescriptorHandle query) {
        Map<UUID, QueryDescriptorWorkingCopy> map = this.fWorkingCopies;
        synchronized (map) {
            return this.fWorkingCopies.get(query.getItemId());
        }
    }

    private boolean connect(IQueryDescriptorHandle handle) {
        QueryDescriptorWorkingCopy workingCopy = this.fWorkingCopies.get(handle.getItemId());
        if (workingCopy != null) {
            workingCopy.connect();
            return true;
        }
        return false;
    }

    private IQueryDescriptor resolveQueryDescriptor(IQueryDescriptorHandle query, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            monitor.beginTask(Messages.QueryDescriptorWorkingCopyManager_LOAD_QUERY, 100);
            if (query.hasFullState() && ((IManagedItem)query.getFullState()).isNewItem()) {
                IQueryDescriptor iQueryDescriptor = (IQueryDescriptor)query;
                return iQueryDescriptor;
            }
            IAuditableClient auditableClient = this.getClientLibrary(IAuditableClient.class);
            IQueryDescriptor iQueryDescriptor = (IQueryDescriptor)auditableClient.fetchCurrentAuditable((IAuditableHandle)query, IQueryDescriptor.FULL_PROFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
            return iQueryDescriptor;
        }
        finally {
            monitor.done();
        }
    }

    private void createNewWorkingCopy(IQueryDescriptor queryDescriptor, IProgressMonitor monitor) throws TeamRepositoryException {
        QueryDescriptorWorkingCopy workingCopy = new QueryDescriptorWorkingCopy(queryDescriptor);
        workingCopy.initialize(monitor);
        workingCopy.connect();
        this.fWorkingCopies.put(queryDescriptor.getItemId(), workingCopy);
    }

    private <T> T getClientLibrary(Class<T> clazz) {
        return (T)this.fRepository.getClientLibrary(clazz);
    }
}

