/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.release.rest.models.internal;

import com.jayway.restassured.RestAssured;
import com.urbancode.release.rest.framework.ClientDescribed;
import com.urbancode.release.rest.framework.JsonReadOnly;
import com.urbancode.release.rest.models.internal.DeploymentExecution;
import com.urbancode.release.rest.models.internal.ScheduledDeployment;
import com.urbancode.release.rest.models.internal.TaskExecution;

public class SegmentExecution
extends ClientDescribed<SegmentExecution> {
    @JsonReadOnly
    public String status;
    public TaskExecution[] tasks;
    public Boolean enforceSequential;
    public String executionPattern;
    public String[] prerequisiteIds;
    public ScheduledDeployment scheduledDeployment;
    public DeploymentExecution deploymentExecution;

    public SegmentExecution() {
        this.path = "/segmentExecution/";
        this.prerequisiteIds = new String[0];
    }

    public SegmentExecution executionPattern(String pattern) {
        this.executionPattern = pattern;
        return this;
    }

    public SegmentExecution enforceSequential(Boolean enforce) {
        this.enforceSequential = enforce;
        return this;
    }

    public SegmentExecution execute() {
        RestAssured.given().put(this.path(this.id) + "/execute", new Object[0]);
        return this;
    }

    public SegmentExecution addTask(TaskExecution task) {
        RestAssured.given().post(this.path(this.id) + "/tasks/" + task.id, new Object[0]);
        return this;
    }

    public SegmentExecution scheduledDeployment(ScheduledDeployment sd) {
        this.scheduledDeployment = sd;
        return this;
    }

    public SegmentExecution deploymentExecution(DeploymentExecution de) {
        this.deploymentExecution = de;
        return this;
    }

    public SegmentExecution removeTask(TaskExecution task) {
        RestAssured.given().delete(this.path(this.id) + "/tasks/" + task.id, new Object[0]);
        return this;
    }

    public SegmentExecution removeTask(int index) {
        return this.removeTask(this.tasks[index]);
    }
}

